/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.List;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_HttpConnectionManager;
import net.snowflake.client.jdbc.internal.grpc.xds.Filter;
import net.snowflake.client.jdbc.internal.grpc.xds.VirtualHost;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@AutoValue
abstract class HttpConnectionManager {
    HttpConnectionManager() {
    }

    abstract long httpMaxStreamDurationNano();

    @Nullable
    abstract String rdsName();

    @Nullable
    abstract ImmutableList<VirtualHost> virtualHosts();

    @Nullable
    abstract ImmutableList<Filter.NamedFilterConfig> httpFilterConfigs();

    static HttpConnectionManager forRdsName(long httpMaxStreamDurationNano, String rdsName, @Nullable List<Filter.NamedFilterConfig> httpFilterConfigs) {
        Preconditions.checkNotNull(rdsName, "rdsName");
        return HttpConnectionManager.create(httpMaxStreamDurationNano, rdsName, null, httpFilterConfigs);
    }

    static HttpConnectionManager forVirtualHosts(long httpMaxStreamDurationNano, List<VirtualHost> virtualHosts, @Nullable List<Filter.NamedFilterConfig> httpFilterConfigs) {
        Preconditions.checkNotNull(virtualHosts, "virtualHosts");
        return HttpConnectionManager.create(httpMaxStreamDurationNano, null, virtualHosts, httpFilterConfigs);
    }

    private static HttpConnectionManager create(long httpMaxStreamDurationNano, @Nullable String rdsName, @Nullable List<VirtualHost> virtualHosts, @Nullable List<Filter.NamedFilterConfig> httpFilterConfigs) {
        return new AutoValue_HttpConnectionManager(httpMaxStreamDurationNano, rdsName, virtualHosts == null ? null : ImmutableList.copyOf(virtualHosts), httpFilterConfigs == null ? null : ImmutableList.copyOf(httpFilterConfigs));
    }
}

