/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth;

import java.util.Date;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.ThreadSafe;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.services.securitytoken.model.Credentials;

@ThreadSafe
@SdkInternalApi
final class SessionCredentialsHolder {
    private final AWSSessionCredentials sessionCredentials;
    private final Date sessionCredentialsExpiration;

    SessionCredentialsHolder(Credentials credentials) {
        this.sessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        this.sessionCredentialsExpiration = credentials.getExpiration();
    }

    public AWSSessionCredentials getSessionCredentials() {
        return this.sessionCredentials;
    }

    public Date getSessionCredentialsExpiration() {
        return this.sessionCredentialsExpiration;
    }
}

