/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.uniffle.shaded.com.google.protobuf.ByteString;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;
import org.apache.uniffle.shaded.io.netty.buffer.Unpooled;

public class ByteBufUtils {
    public static int encodedLength(String s2) {
        if (s2 == null) {
            return 4;
        }
        return 4 + s2.getBytes(StandardCharsets.UTF_8).length;
    }

    public static int encodedLength(ByteBuf buf) {
        return 4 + buf.readableBytes();
    }

    public static final void writeLengthAndString(ByteBuf buf, String str) {
        if (str == null) {
            buf.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }

    public static final String readLengthAndString(ByteBuf buf) {
        int length = buf.readInt();
        if (length == -1) {
            return null;
        }
        byte[] bytes = new byte[length];
        buf.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static final void copyByteBuf(ByteBuf from, ByteBuf to) {
        to.writeInt(from.readableBytes());
        to.writeBytes(from);
        from.resetReaderIndex();
    }

    public static final byte[] readByteArray(ByteBuf byteBuf) {
        int length = byteBuf.readInt();
        if (length < 0) {
            return null;
        }
        byte[] data = new byte[length];
        byteBuf.readBytes(data);
        return data;
    }

    public static final ByteBuf readSlice(ByteBuf from) {
        int length = from.readInt();
        return from.retain().readSlice(length);
    }

    public static final byte[] readBytes(ByteBuf byteBuf) {
        ByteBuf buf = byteBuf.duplicate();
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return bytes;
    }

    public static void readBytes(ByteBuf from, byte[] to, int offset, int length) {
        from.readBytes(to, offset, length);
        from.resetReaderIndex();
    }

    public static ByteBuf byteStringToByteBuf(ByteString bytes) {
        ByteBuffer byteBuffer = bytes.asReadOnlyByteBuffer();
        return Unpooled.wrappedBuffer(byteBuffer);
    }

    public static ByteBuf copy(ByteBuf from) {
        ByteBuf newByteBuf = Unpooled.directBuffer(from.readableBytes());
        newByteBuf.writeBytes(from);
        from.resetReaderIndex();
        return newByteBuf;
    }
}

