/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer.writable;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.WritableUtils;
import org.apache.uniffle.common.serializer.SerOutputStream;
import org.apache.uniffle.common.serializer.SerializationStream;
import org.apache.uniffle.common.serializer.writable.WritableSerializerInstance;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;

public class BufferedRawWritableSerializationStream<K, V>
extends SerializationStream {
    private long totalBytesWritten = 0L;
    private SerOutputStream output;
    private DataOutputStream dataOut;

    public BufferedRawWritableSerializationStream(WritableSerializerInstance instance, SerOutputStream output) {
        this.output = output;
    }

    @Override
    public void init() {
        this.dataOut = new DataOutputStream(this.output);
    }

    @Override
    public void writeRecord(Object key, Object value) throws IOException {
        ByteBuf keyBuffer = (ByteBuf)key;
        ByteBuf valueBuffer = (ByteBuf)value;
        int keyLength = keyBuffer.readableBytes();
        int valueLength = valueBuffer.readableBytes();
        int toWriteLength = WritableUtils.getVIntSize((long)keyLength) + WritableUtils.getVIntSize((long)valueLength) + keyLength + valueLength;
        this.output.preAllocate(toWriteLength);
        WritableUtils.writeVInt((DataOutput)this.dataOut, (int)keyLength);
        WritableUtils.writeVInt((DataOutput)this.dataOut, (int)valueLength);
        this.output.write(keyBuffer);
        this.output.write(valueBuffer);
        this.totalBytesWritten += (long)toWriteLength;
    }

    @Override
    public void flush() throws IOException {
        this.dataOut.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.close();
            this.dataOut = null;
        }
    }

    @Override
    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }
}

