/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.metrics;

import java.util.HashMap;
import java.util.function.Supplier;
import org.apache.uniffle.common.metrics.MetricsManager;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Maps;
import org.apache.uniffle.shaded.io.prometheus.client.CollectorRegistry;

public class CommonMetrics {
    public static final String JVM_PAUSE_TOTAL_EXTRA_TIME = "JvmPauseMonitorTotalExtraTime";
    public static final String JVM_PAUSE_INFO_TIME_EXCEEDED = "JvmPauseMonitorInfoTimeExceeded";
    public static final String JVM_PAUSE_WARN_TIME_EXCEEDED = "JvmPauseMonitorWarnTimeExceeded";
    private static MetricsManager metricsManager;
    private static boolean isRegister;

    @VisibleForTesting
    public static void clear() {
        isRegister = false;
        CollectorRegistry.defaultRegistry.clear();
    }

    public static CollectorRegistry getCollectorRegistry() {
        if (!isRegister) {
            return null;
        }
        return metricsManager.getCollectorRegistry();
    }

    public static <T extends Number> void addLabeledGauge(String name, Supplier<T> supplier) {
        CommonMetrics.addLabeledCacheGauge(name, supplier, 0L);
    }

    public static <T extends Number> void addLabeledCacheGauge(String name, Supplier<T> supplier, long updateInterval) {
        if (!isRegister) {
            return;
        }
        metricsManager.addLabeledCacheGauge(name, supplier, updateInterval);
    }

    public static void unregisterSupplierGauge(String name) {
        if (!isRegister) {
            return;
        }
        metricsManager.unregisterSupplierGauge(name);
    }

    public static void register(CollectorRegistry collectorRegistry, String tags) {
        if (!isRegister) {
            HashMap<String, String> labels = Maps.newHashMap();
            labels.put("tags", tags);
            metricsManager = new MetricsManager(collectorRegistry, labels);
            isRegister = true;
        }
    }

    static {
        isRegister = false;
    }
}

