/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.org.eclipse.jetty.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uniffle.shaded.org.eclipse.jetty.client.ConnectionPool;
import org.apache.uniffle.shaded.org.eclipse.jetty.client.api.Connection;
import org.apache.uniffle.shaded.org.eclipse.jetty.client.api.Destination;
import org.apache.uniffle.shaded.org.eclipse.jetty.util.Callback;
import org.apache.uniffle.shaded.org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.apache.uniffle.shaded.org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.apache.uniffle.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.uniffle.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.uniffle.shaded.org.eclipse.jetty.util.thread.Scheduler;

public class ValidatingConnectionPool
extends ConnectionPool {
    private static final Logger LOG = Log.getLogger(ValidatingConnectionPool.class);
    private final Scheduler scheduler;
    private final long timeout;
    private final Map<Connection, Holder> quarantine;

    public ValidatingConnectionPool(Destination destination, int maxConnections, Callback requester, Scheduler scheduler, long timeout) {
        super(destination, maxConnections, requester);
        this.scheduler = scheduler;
        this.timeout = timeout;
        this.quarantine = new HashMap<Connection, Holder>(maxConnections);
    }

    @ManagedAttribute(value="The number of validating connections", readonly=true)
    public int getValidatingConnectionCount() {
        return this.quarantine.size();
    }

    @Override
    public boolean release(Connection connection) {
        this.lock();
        try {
            if (!this.getActiveConnections().remove(connection)) {
                boolean bl = false;
                return bl;
            }
            Holder holder = new Holder(connection);
            holder.task = this.scheduler.schedule(holder, this.timeout, TimeUnit.MILLISECONDS);
            this.quarantine.put(connection, holder);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validating for {}ms {}", this.timeout, connection);
            }
        }
        finally {
            this.unlock();
        }
        this.released(connection);
        return true;
    }

    @Override
    public boolean remove(Connection connection) {
        boolean cancelled;
        Holder holder;
        this.lock();
        try {
            holder = this.quarantine.remove(connection);
        }
        finally {
            this.unlock();
        }
        if (holder == null) {
            return super.remove(connection);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removed while validating {}", connection);
        }
        if (cancelled = holder.cancel()) {
            return this.remove(connection, true);
        }
        return super.remove(connection);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        ContainerLifeCycle.dump(out, indent, this.quarantine.values());
    }

    @Override
    public String toString() {
        int size;
        this.lock();
        try {
            size = this.quarantine.size();
        }
        finally {
            this.unlock();
        }
        return String.format("%s[v=%d]", super.toString(), size);
    }

    private class Holder
    implements Runnable {
        private final long timestamp = System.nanoTime();
        private final AtomicBoolean latch = new AtomicBoolean();
        private final Connection connection;
        public Scheduler.Task task;

        public Holder(Connection connection) {
            this.connection = connection;
        }

        @Override
        public void run() {
            if (this.latch.compareAndSet(false, true)) {
                boolean idle;
                ValidatingConnectionPool.this.lock();
                try {
                    ValidatingConnectionPool.this.quarantine.remove(this.connection);
                    idle = ValidatingConnectionPool.this.offerIdle(this.connection);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Validated {}", this.connection);
                    }
                }
                finally {
                    ValidatingConnectionPool.this.unlock();
                }
                if (ValidatingConnectionPool.this.idle(this.connection, idle)) {
                    ValidatingConnectionPool.this.proceed();
                }
            }
        }

        public boolean cancel() {
            if (this.latch.compareAndSet(false, true)) {
                this.task.cancel();
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format("%s[validationLeft=%dms]", this.connection, ValidatingConnectionPool.this.timeout - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.timestamp));
        }
    }
}

