/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.uniffle.common.netty.IOMode;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;
import org.apache.uniffle.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.uniffle.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.uniffle.shaded.io.netty.channel.Channel;
import org.apache.uniffle.shaded.io.netty.channel.ChannelFuture;
import org.apache.uniffle.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.uniffle.shaded.io.netty.channel.EventLoopGroup;
import org.apache.uniffle.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.uniffle.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.uniffle.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.uniffle.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.uniffle.shaded.io.netty.util.internal.PlatformDependent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUtils {
    private static final Logger logger = LoggerFactory.getLogger(NettyUtils.class);
    private static final long MAX_DIRECT_MEMORY_IN_BYTES = PlatformDependent.maxDirectMemory();
    private static int MAX_DEFAULT_NETTY_THREADS = 8;
    private static final AtomicReferenceArray<PooledByteBufAllocator> SHARED_POOLED_BYTE_BUF_ALLOCATOR = new AtomicReferenceArray(2);
    private static volatile UnpooledByteBufAllocator sharedUnpooledByteBufAllocator;

    public static EventLoopGroup createEventLoop(IOMode mode, int numThreads, String threadPrefix) {
        ThreadFactory threadFactory = ThreadUtils.getNettyThreadFactory(threadPrefix);
        switch (mode) {
            case NIO: {
                return new NioEventLoopGroup(numThreads, threadFactory);
            }
            case EPOLL: {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static Class<? extends Channel> getClientChannelClass(IOMode mode) {
        switch (mode) {
            case NIO: {
                return NioSocketChannel.class;
            }
            case EPOLL: {
                return EpollSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static int defaultNumThreads(int numUsableCores) {
        int availableCores = numUsableCores > 0 ? numUsableCores : Runtime.getRuntime().availableProcessors();
        return Math.min(availableCores, MAX_DEFAULT_NETTY_THREADS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PooledByteBufAllocator getSharedPooledByteBufAllocator(boolean allowDirectBufs, boolean allowCache, int numCores) {
        int index = allowCache ? 0 : 1;
        PooledByteBufAllocator allocator = SHARED_POOLED_BYTE_BUF_ALLOCATOR.get(index);
        if (allocator != null) return allocator;
        Class<NettyUtils> clazz = NettyUtils.class;
        synchronized (NettyUtils.class) {
            allocator = SHARED_POOLED_BYTE_BUF_ALLOCATOR.get(index);
            if (allocator != null) return allocator;
            allocator = NettyUtils.createPooledByteBufAllocator(allowDirectBufs, allowCache, numCores);
            SHARED_POOLED_BYTE_BUF_ALLOCATOR.set(index, allocator);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return allocator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized UnpooledByteBufAllocator getSharedUnpooledByteBufAllocator(boolean allowDirectBufs) {
        if (sharedUnpooledByteBufAllocator != null) return sharedUnpooledByteBufAllocator;
        Class<NettyUtils> clazz = NettyUtils.class;
        synchronized (NettyUtils.class) {
            if (sharedUnpooledByteBufAllocator != null) return sharedUnpooledByteBufAllocator;
            sharedUnpooledByteBufAllocator = NettyUtils.createUnpooledByteBufAllocator(allowDirectBufs);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sharedUnpooledByteBufAllocator;
        }
    }

    public static PooledByteBufAllocator createPooledByteBufAllocator(boolean allowDirectBufs, boolean allowCache, int numCores) {
        numCores = NettyUtils.defaultNumThreads(numCores);
        return new PooledByteBufAllocator(allowDirectBufs && PlatformDependent.directBufferPreferred(), Math.min(PooledByteBufAllocator.defaultNumHeapArena(), numCores), Math.min(PooledByteBufAllocator.defaultNumDirectArena(), allowDirectBufs ? numCores : 0), PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), allowCache ? PooledByteBufAllocator.defaultSmallCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultNormalCacheSize() : 0, allowCache && PooledByteBufAllocator.defaultUseCacheForAllThreads());
    }

    public static String getRemoteAddress(Channel channel) {
        if (channel != null && channel.remoteAddress() != null) {
            return channel.remoteAddress().toString();
        }
        return "<unknown remote>";
    }

    public static ChannelFuture writeResponseMsg(ChannelHandlerContext ctx, Message msg, boolean doWriteType) {
        ByteBuf responseMsgBuf = ctx.alloc().buffer(msg.encodedLength());
        try {
            if (doWriteType) {
                responseMsgBuf.writeByte(msg.type().id());
            }
            msg.encode(responseMsgBuf);
            return ctx.writeAndFlush(responseMsgBuf);
        }
        catch (Throwable ex) {
            logger.warn("Caught exception, releasing ByteBuf", ex);
            responseMsgBuf.release();
            throw ex;
        }
    }

    public static String getServerConnectionInfo(ChannelHandlerContext ctx) {
        return NettyUtils.getServerConnectionInfo(ctx.channel());
    }

    public static String getServerConnectionInfo(Channel channel) {
        return String.format("[%s -> %s]", channel.localAddress(), channel.remoteAddress());
    }

    public static UnpooledByteBufAllocator createUnpooledByteBufAllocator(boolean preferDirect) {
        return new UnpooledByteBufAllocator(preferDirect);
    }

    public static long getMaxDirectMemory() {
        return MAX_DIRECT_MEMORY_IN_BYTES;
    }
}

