/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.writer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import org.apache.spark.shuffle.handle.ShuffleHandleInfo;
import org.apache.spark.shuffle.handle.split.PartitionSplitInfo;
import org.apache.uniffle.common.PartitionSplitMode;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAttemptAssignment {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskAttemptAssignment.class);
    private Map<Integer, List<ShuffleServerInfo>> assignment;
    private ShuffleHandleInfo handle;
    private final long taskAttemptId;
    private final Map<Integer, Set<ShuffleServerInfo>> exclusiveServersForPartition = JavaUtils.newConcurrentMap();

    public TaskAttemptAssignment(long taskAttemptId, ShuffleHandleInfo shuffleHandleInfo) {
        this.update(shuffleHandleInfo);
        this.handle = shuffleHandleInfo;
        this.taskAttemptId = taskAttemptId;
    }

    public List<ShuffleServerInfo> retrieve(int partitionId) {
        return this.assignment.get(partitionId);
    }

    public void update(ShuffleHandleInfo handle) {
        if (handle == null) {
            throw new RssException("Errors on updating shuffle handle by the empty handleInfo.");
        }
        this.assignment = handle.getAvailablePartitionServersForWriter(this.exclusiveServersForPartition.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> new ArrayList((Collection)x.getValue()))));
        this.handle = handle;
    }

    private boolean hasBeenLoadBalanced(int partitionId) {
        PartitionSplitInfo splitInfo = this.handle.getPartitionSplitInfo(partitionId);
        return splitInfo.isSplit() && splitInfo.getMode() == PartitionSplitMode.LOAD_BALANCE;
    }

    public boolean updatePartitionSplitAssignment(int partitionId, List<ShuffleServerInfo> exclusiveServers) {
        if (this.hasBeenLoadBalanced(partitionId)) {
            Set servers = this.exclusiveServersForPartition.computeIfAbsent(partitionId, k -> new ConcurrentSkipListSet());
            servers.addAll(exclusiveServers);
            this.update(this.handle);
            return true;
        }
        return false;
    }

    public List<ShuffleServerInfo> list(int partitionId) {
        Map<Integer, List<ShuffleServerInfo>> servers = this.handle.getAllPartitionServersForReader();
        if (servers == null) {
            return Collections.emptyList();
        }
        return servers.get(partitionId);
    }
}

