/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;
import org.apache.uniffle.shaded.io.netty.buffer.Unpooled;
import org.apache.uniffle.storage.api.FileWriter;
import org.apache.uniffle.storage.common.FileBasedShuffleSegment;

public class LocalFileNioWriter
implements FileWriter {
    private FileOutputStream fileOutputStream;
    private long nextOffset;

    @VisibleForTesting
    public LocalFileNioWriter(File file) throws IOException {
        this(file, 8192);
    }

    public LocalFileNioWriter(File file, int bufferSize) throws IOException {
        this.fileOutputStream = new FileOutputStream(file, true);
        this.nextOffset = file.length();
    }

    @Override
    public void writeData(byte[] data) throws IOException {
        this.writeData(Unpooled.wrappedBuffer(data));
    }

    @Override
    public void writeData(ByteBuf buf) throws IOException {
        if (buf != null && buf.readableBytes() > 0) {
            int writtenSize = this.fileOutputStream.getChannel().write(buf.nioBuffer());
            if (writtenSize <= 0) {
                throw new IOException("Failed to write data to file");
            }
            this.nextOffset += (long)buf.readableBytes();
        }
    }

    @Override
    public void writeIndex(FileBasedShuffleSegment segment) throws IOException {
        throw new UnsupportedOperationException("LocalFileNioWriter does not support index");
    }

    @Override
    public long nextOffset() {
        return this.nextOffset;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fileOutputStream != null) {
            this.fileOutputStream.close();
        }
    }
}

