/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.io.prometheus.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.uniffle.shaded.io.prometheus.client.Collector;

public class CollectorRegistry {
    public static final CollectorRegistry defaultRegistry = new CollectorRegistry(true);
    private final Object namesCollectorsLock = new Object();
    private final Map<Collector, List<String>> collectorsToNames = new HashMap<Collector, List<String>>();
    private final Map<String, Collector> namesToCollectors = new HashMap<String, Collector>();
    private final boolean autoDescribe;

    public CollectorRegistry() {
        this(false);
    }

    public CollectorRegistry(boolean autoDescribe) {
        this.autoDescribe = autoDescribe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Collector m4) {
        List<String> names = this.collectorNames(m4);
        Object object = this.namesCollectorsLock;
        synchronized (object) {
            for (String name : names) {
                if (!this.namesToCollectors.containsKey(name)) continue;
                throw new IllegalArgumentException("Collector already registered that provides name: " + name);
            }
            for (String name : names) {
                this.namesToCollectors.put(name, m4);
            }
            this.collectorsToNames.put(m4, names);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Collector m4) {
        Object object = this.namesCollectorsLock;
        synchronized (object) {
            List<String> names = this.collectorsToNames.remove(m4);
            for (String name : names) {
                this.namesToCollectors.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.namesCollectorsLock;
        synchronized (object) {
            this.collectorsToNames.clear();
            this.namesToCollectors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Collector> collectors() {
        Object object = this.namesCollectorsLock;
        synchronized (object) {
            return new HashSet<Collector>(this.collectorsToNames.keySet());
        }
    }

    private List<String> collectorNames(Collector m4) {
        List<Collector.MetricFamilySamples> mfs = m4 instanceof Collector.Describable ? ((Collector.Describable)((Object)m4)).describe() : (this.autoDescribe ? m4.collect() : Collections.emptyList());
        ArrayList<String> names = new ArrayList<String>();
        block4: for (Collector.MetricFamilySamples family : mfs) {
            switch (family.type) {
                case SUMMARY: {
                    names.add(family.name + "_count");
                    names.add(family.name + "_sum");
                    names.add(family.name);
                    continue block4;
                }
                case HISTOGRAM: {
                    names.add(family.name + "_count");
                    names.add(family.name + "_sum");
                    names.add(family.name + "_bucket");
                    names.add(family.name);
                    continue block4;
                }
            }
            names.add(family.name);
        }
        return names;
    }

    public Enumeration<Collector.MetricFamilySamples> metricFamilySamples() {
        return new MetricFamilySamplesEnumeration();
    }

    public Enumeration<Collector.MetricFamilySamples> filteredMetricFamilySamples(Set<String> includedNames) {
        return new MetricFamilySamplesEnumeration(includedNames);
    }

    public Double getSampleValue(String name) {
        return this.getSampleValue(name, new String[0], new String[0]);
    }

    public Double getSampleValue(String name, String[] labelNames, String[] labelValues) {
        for (Collector.MetricFamilySamples metricFamilySamples : Collections.list(this.metricFamilySamples())) {
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                if (!sample.name.equals(name) || !Arrays.equals(sample.labelNames.toArray(), labelNames) || !Arrays.equals(sample.labelValues.toArray(), labelValues)) continue;
                return sample.value;
            }
        }
        return null;
    }

    class MetricFamilySamplesEnumeration
    implements Enumeration<Collector.MetricFamilySamples> {
        private final Iterator<Collector> collectorIter;
        private Iterator<Collector.MetricFamilySamples> metricFamilySamples;
        private Collector.MetricFamilySamples next;
        private Set<String> includedNames;

        MetricFamilySamplesEnumeration(Set<String> includedNames) {
            this.includedNames = includedNames;
            this.collectorIter = this.includedCollectorIterator(includedNames);
            this.findNextElement();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterator<Collector> includedCollectorIterator(Set<String> includedNames) {
            if (includedNames.isEmpty()) {
                return CollectorRegistry.this.collectors().iterator();
            }
            HashSet collectors = new HashSet();
            Object object = CollectorRegistry.this.namesCollectorsLock;
            synchronized (object) {
                for (Map.Entry entry : CollectorRegistry.this.namesToCollectors.entrySet()) {
                    if (!includedNames.contains(entry.getKey())) continue;
                    collectors.add(entry.getValue());
                }
            }
            return collectors.iterator();
        }

        MetricFamilySamplesEnumeration() {
            this(Collections.emptySet());
        }

        private void findNextElement() {
            this.next = null;
            while (this.metricFamilySamples != null && this.metricFamilySamples.hasNext()) {
                this.next = this.filter(this.metricFamilySamples.next());
                if (this.next == null) continue;
                return;
            }
            if (this.next == null) {
                while (this.collectorIter.hasNext()) {
                    this.metricFamilySamples = this.collectorIter.next().collect().iterator();
                    while (this.metricFamilySamples.hasNext()) {
                        this.next = this.filter(this.metricFamilySamples.next());
                        if (this.next == null) continue;
                        return;
                    }
                }
            }
        }

        private Collector.MetricFamilySamples filter(Collector.MetricFamilySamples next) {
            if (this.includedNames.isEmpty()) {
                return next;
            }
            Iterator<Collector.MetricFamilySamples.Sample> it = next.samples.iterator();
            while (it.hasNext()) {
                if (this.includedNames.contains(it.next().name)) continue;
                it.remove();
            }
            if (next.samples.size() == 0) {
                return null;
            }
            return next;
        }

        @Override
        public Collector.MetricFamilySamples nextElement() {
            Collector.MetricFamilySamples current = this.next;
            if (current == null) {
                throw new NoSuchElementException();
            }
            this.findNextElement();
            return current;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }
    }
}

