/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.web.resource;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.uniffle.common.web.resource.BaseMetricResource;
import org.apache.uniffle.shaded.io.prometheus.client.Collector;
import org.apache.uniffle.shaded.org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.uniffle.shaded.org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.uniffle.shaded.org.apache.hbase.thirdparty.javax.ws.rs.PathParam;
import org.apache.uniffle.shaded.org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.uniffle.shaded.org.apache.hbase.thirdparty.javax.ws.rs.QueryParam;
import org.apache.uniffle.shaded.org.apache.hbase.thirdparty.javax.ws.rs.core.Context;

@Path(value="/metrics")
@Produces(value={"application/json"})
public class MetricResource
extends BaseMetricResource {
    @Context
    protected ServletContext servletContext;

    @GET
    @Path(value="/")
    public MetricsJsonObj metrics(@QueryParam(value="name[]") Set<String> names) {
        return this.metrics(null, names);
    }

    @GET
    @Path(value="/{type}")
    public MetricsJsonObj metrics(@PathParam(value="type") String type, @QueryParam(value="name[]") Set<String> names) {
        Enumeration<Collector.MetricFamilySamples> mfs = this.getCollectorRegistry(this.servletContext, type).filteredMetricFamilySamples(names);
        LinkedList<Collector.MetricFamilySamples.Sample> metrics = new LinkedList<Collector.MetricFamilySamples.Sample>();
        while (mfs.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamilySamples = mfs.nextElement();
            metrics.addAll(metricFamilySamples.samples);
        }
        return new MetricsJsonObj(metrics, System.currentTimeMillis());
    }

    private static class MetricsJsonObj {
        private final List<Collector.MetricFamilySamples.Sample> metrics;
        private final long timeStamp;

        MetricsJsonObj(List<Collector.MetricFamilySamples.Sample> metrics, long timeStamp) {
            this.metrics = metrics;
            this.timeStamp = timeStamp;
        }

        public List<Collector.MetricFamilySamples.Sample> getMetrics() {
            return this.metrics;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }
    }
}

