/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty;

import java.util.List;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.MessageWithHeader;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;
import org.apache.uniffle.shaded.io.netty.channel.ChannelHandler;
import org.apache.uniffle.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.uniffle.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class MessageEncoder
extends MessageToMessageEncoder<Message> {
    private static final Logger logger = LoggerFactory.getLogger(MessageEncoder.class);
    public static final MessageEncoder INSTANCE = new MessageEncoder();

    private MessageEncoder() {
    }

    @Override
    public void encode(ChannelHandlerContext ctx, Message in, List<Object> out) throws Exception {
        Object body = null;
        int bodyLength = 0;
        if (in.body() != null) {
            try {
                bodyLength = in.body().size();
                body = in.body().convertToNetty();
            }
            catch (Exception e) {
                in.body().release();
                if (!(in instanceof RpcResponse)) {
                    throw e;
                }
                RpcResponse resp = (RpcResponse)in;
                String error = e.getMessage() != null ? e.getMessage() : "null";
                logger.error(String.format("Error processing %s for client %s", in, ctx.channel().remoteAddress()), (Throwable)e);
                this.encode(ctx, resp.createFailureResponse(error), out);
                return;
            }
        }
        Message.Type msgType = in.type();
        int headerLength = 4 + msgType.encodedLength() + 4 + in.encodedLength();
        ByteBuf header = ctx.alloc().heapBuffer(headerLength);
        header.writeInt(in.encodedLength());
        msgType.encode(header);
        header.writeInt(bodyLength);
        in.encode(header);
        if (header.writableBytes() != 0) {
            throw new RssException("header's writable bytes should be 0");
        }
        if (body != null) {
            out.add(new MessageWithHeader(in.body(), header, body, bodyLength));
        } else {
            out.add(header);
        }
    }
}

