/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.uniffle.common.config.ConfigOption;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.util.UnitConverter;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;

public class ConfigUtils {
    public static final Function<Long, Boolean> POSITIVE_LONG_VALIDATOR = value -> value > 0L;
    public static final Function<Long, Boolean> NON_NEGATIVE_LONG_VALIDATOR = value -> value >= 0L;
    public static final Function<Integer, Boolean> SERVER_PORT_VALIDATOR = value -> value == 0 || value >= 1024 && value <= 65535;
    public static final Function<Long, Boolean> POSITIVE_INTEGER_VALIDATOR = value -> value > 0L && value <= Integer.MAX_VALUE;
    public static final Function<Integer, Boolean> POSITIVE_INTEGER_VALIDATOR_2 = value -> value > 0;
    public static final Function<Double, Boolean> PERCENTAGE_DOUBLE_VALIDATOR = value -> Double.compare(value, 100.0) <= 0 && Double.compare(value, 0.0) >= 0;

    private ConfigUtils() {
    }

    public static <T> T convertValue(Object rawValue, Class<?> clazz) {
        if (Integer.class.equals(clazz)) {
            return (T)ConfigUtils.convertToInt(rawValue);
        }
        if (Long.class.equals(clazz)) {
            return (T)ConfigUtils.convertToLong(rawValue);
        }
        if (Boolean.class.equals(clazz)) {
            return (T)ConfigUtils.convertToBoolean(rawValue);
        }
        if (Float.class.equals(clazz)) {
            return (T)ConfigUtils.convertToFloat(rawValue);
        }
        if (Double.class.equals(clazz)) {
            return (T)ConfigUtils.convertToDouble(rawValue);
        }
        if (String.class.equals(clazz)) {
            return (T)ConfigUtils.convertToString(rawValue);
        }
        if (clazz.isEnum()) {
            return (T)ConfigUtils.convertToEnum(rawValue, clazz);
        }
        throw new IllegalArgumentException("Unsupported type: " + clazz);
    }

    public static <E extends Enum<?>> E convertToEnum(Object o, Class<E> clazz) {
        if (o.getClass().equals(clazz)) {
            return (E)((Enum)o);
        }
        return (E)Arrays.stream(clazz.getEnumConstants()).filter(e -> e.toString().toUpperCase(Locale.ROOT).equals(o.toString().toUpperCase(Locale.ROOT))).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Could not parse value for enum %s. Expected one of: [%s]", clazz, Arrays.toString(clazz.getEnumConstants()))));
    }

    static String convertToString(Object o) {
        if (o.getClass() == String.class) {
            return (String)o;
        }
        return o.toString();
    }

    static Integer convertToInt(Object o) {
        if (o.getClass() == Integer.class) {
            return (Integer)o;
        }
        if (o.getClass() == Long.class) {
            long value = (Long)o;
            if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                return (int)value;
            }
            throw new IllegalArgumentException(String.format("Configuration value %s overflows/underflows the integer type.", value));
        }
        return Integer.parseInt(o.toString());
    }

    static Long convertToLong(Object o) {
        if (o.getClass() == Long.class) {
            return (Long)o;
        }
        if (o.getClass() == Integer.class) {
            return ((Integer)o).longValue();
        }
        if (UnitConverter.isByteString(o.toString())) {
            return UnitConverter.byteStringAsBytes(o.toString());
        }
        return Long.parseLong(o.toString());
    }

    static Long convertToSizeInBytes(Object o) {
        if (o.getClass() == Long.class) {
            return (Long)o;
        }
        if (o.getClass() == Integer.class) {
            return ((Integer)o).longValue();
        }
        return UnitConverter.byteStringAsBytes(o.toString());
    }

    static Boolean convertToBoolean(Object o) {
        if (o.getClass() == Boolean.class) {
            return (Boolean)o;
        }
        switch (o.toString().toUpperCase()) {
            case "TRUE": {
                return true;
            }
            case "FALSE": {
                return false;
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized option for boolean: %s. Expected either true or false(case insensitive)", o));
    }

    static Float convertToFloat(Object o) {
        if (o.getClass() == Float.class) {
            return (Float)o;
        }
        if (o.getClass() == Double.class) {
            double value = (Double)o;
            if (value == 0.0 || value >= (double)1.4E-45f && value <= 3.4028234663852886E38 || value >= -3.4028234663852886E38 && value <= (double)-1.4E-45f) {
                return Float.valueOf((float)value);
            }
            throw new IllegalArgumentException(String.format("Configuration value %s overflows/underflows the float type.", value));
        }
        return Float.valueOf(Float.parseFloat(o.toString()));
    }

    static Double convertToDouble(Object o) {
        if (o.getClass() == Double.class) {
            return (Double)o;
        }
        if (o.getClass() == Float.class) {
            return ((Float)o).doubleValue();
        }
        return Double.parseDouble(o.toString());
    }

    public static double[] convertBytesStringToDoubleArray(Object o) {
        if (o == null) {
            return new double[0];
        }
        return Arrays.stream(o.toString().split(",")).map(UnitConverter::byteStringAsBytes).mapToDouble(l -> l.longValue()).toArray();
    }

    public static List<ConfigOption<Object>> getAllConfigOptions(Class<? extends RssBaseConf> confClass) {
        ArrayList<ConfigOption<Object>> configOptionList = Lists.newArrayList();
        try {
            Field[] fields;
            for (Field field : fields = confClass.getFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !Modifier.isFinal(modifiers) || !field.getType().isAssignableFrom(ConfigOption.class)) continue;
                configOptionList.add((ConfigOption)field.get(null));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Exception when loading configuration option", e);
        }
        return configOptionList;
    }
}

