/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.factory;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.uniffle.client.api.CoordinatorClient;
import org.apache.uniffle.client.impl.grpc.CoordinatorGrpcClient;
import org.apache.uniffle.client.impl.grpc.CoordinatorGrpcRetryableClient;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinatorClientFactory.class);

    private CoordinatorClientFactory() {
    }

    public static CoordinatorClientFactory getInstance() {
        return LazyHolder.INSTANCE;
    }

    @VisibleForTesting
    public synchronized CoordinatorClient createCoordinatorClient(ClientType clientType, String host, int port) {
        if (clientType.equals((Object)ClientType.GRPC) || clientType.equals((Object)ClientType.GRPC_NETTY)) {
            return new CoordinatorGrpcClient(host, port);
        }
        throw new UnsupportedOperationException("Unsupported client type " + (Object)((Object)clientType));
    }

    @VisibleForTesting
    public synchronized List<CoordinatorClient> createCoordinatorClient(ClientType clientType, String coordinators) {
        LOG.info("Start to create coordinator clients from {}", (Object)coordinators);
        String[] coordinatorList = coordinators.trim().split(",");
        if (coordinatorList.length == 0) {
            String msg = "Invalid " + coordinators;
            LOG.error(msg);
            throw new RssException(msg);
        }
        LinkedList<CoordinatorClient> coordinatorClients = Lists.newLinkedList();
        for (String coordinator : coordinatorList) {
            Object[] ipPort = coordinator.trim().split(":");
            if (ipPort.length != 2) {
                String msg = "Invalid coordinator format " + Arrays.toString(ipPort);
                LOG.error(msg);
                throw new RssException(msg);
            }
            String host = ipPort[0];
            int port = Integer.parseInt((String)ipPort[1]);
            CoordinatorClient coordinatorClient = this.createCoordinatorClient(clientType, host, port);
            coordinatorClients.add(coordinatorClient);
            LOG.info("Add coordinator client {}", (Object)coordinatorClient.getDesc());
        }
        LOG.info("Finish create coordinator clients {}", (Object)coordinatorClients.stream().map(CoordinatorClient::getDesc).collect(Collectors.joining(", ")));
        return coordinatorClients;
    }

    public synchronized CoordinatorGrpcRetryableClient createCoordinatorClient(ClientType clientType, String coordinators, long retryIntervalMs, int retryTimes, int heartBeatThreadNum) {
        List<CoordinatorClient> coordinatorClients = this.createCoordinatorClient(clientType, coordinators);
        return new CoordinatorGrpcRetryableClient(coordinatorClients, retryIntervalMs, retryTimes, heartBeatThreadNum);
    }

    private static class LazyHolder {
        static final CoordinatorClientFactory INSTANCE = new CoordinatorClientFactory();

        private LazyHolder() {
        }
    }
}

