/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.writer;

import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.common.ShuffleBlockInfo;

public class AddBlockEvent {
    private String taskId;
    private int stageAttemptNumber;
    private List<ShuffleBlockInfo> shuffleDataInfoList;
    private List<Runnable> processedCallbackChain;

    public AddBlockEvent(String taskId, List<ShuffleBlockInfo> shuffleDataInfoList) {
        this(taskId, 0, shuffleDataInfoList);
    }

    public AddBlockEvent(String taskId, int stageAttemptNumber, List<ShuffleBlockInfo> shuffleDataInfoList) {
        this.taskId = taskId;
        this.stageAttemptNumber = stageAttemptNumber;
        this.shuffleDataInfoList = shuffleDataInfoList;
        this.processedCallbackChain = new ArrayList<Runnable>();
    }

    public void addCallback(Runnable callback) {
        this.processedCallbackChain.add(callback);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int getStageAttemptNumber() {
        return this.stageAttemptNumber;
    }

    public List<ShuffleBlockInfo> getShuffleDataInfoList() {
        return this.shuffleDataInfoList;
    }

    public List<Runnable> getProcessedCallbackChain() {
        return this.processedCallbackChain;
    }

    public String toString() {
        return "AddBlockEvent: TaskId[" + this.taskId + "], " + this.shuffleDataInfoList;
    }
}

