/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.util.Map;
import java.util.Set;
import org.apache.spark.shuffle.RssStageInfo;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssStageResubmitManager {
    private static final Logger LOG = LoggerFactory.getLogger(RssStageResubmitManager.class);
    private Set<String> serverIdBlackList = Sets.newConcurrentHashSet();
    private Map<Integer, RssStageInfo> serverAssignedInfos = JavaUtils.newConcurrentMap();

    public Set<String> getServerIdBlackList() {
        return this.serverIdBlackList;
    }

    public void resetServerIdBlackList(Set<String> failuresShuffleServerIds) {
        this.serverIdBlackList = failuresShuffleServerIds;
    }

    public void recordFailuresShuffleServer(String shuffleServerId) {
        this.serverIdBlackList.add(shuffleServerId);
    }

    public RssStageInfo recordAndGetServerAssignedInfo(int shuffleId, String stageIdAndAttempt) {
        return this.serverAssignedInfos.computeIfAbsent(shuffleId, id -> new RssStageInfo(stageIdAndAttempt, false));
    }

    public void recordAndGetServerAssignedInfo(int shuffleId, String stageIdAndAttempt, boolean isRetried) {
        this.serverAssignedInfos.computeIfAbsent(shuffleId, id -> new RssStageInfo(stageIdAndAttempt, false)).setReassigned(isRetried);
    }
}

