/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.util.Set;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.ConfigBuilder;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.TypedConfigBuilder;
import org.apache.uniffle.client.util.RssClientConfig;
import org.apache.uniffle.common.config.ConfigOption;
import org.apache.uniffle.common.config.ConfigOptions;
import org.apache.uniffle.common.config.ConfigUtils;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.shaded.com.google.common.collect.ImmutableSet;
import scala.Function1;
import scala.Tuple2;
import scala.runtime.AbstractFunction1;

public class RssSparkConfig {
    public static final ConfigOption<Boolean> RSS_RESUBMIT_STAGE_ENABLED = ConfigOptions.key("rss.stageRetry.enabled").booleanType().defaultValue(false).withDeprecatedKeys("rss.resubmit.stage").withDescription("Whether to enable the resubmit stage for fetch/write failure");
    public static final ConfigOption<Boolean> RSS_RESUBMIT_STAGE_WITH_FETCH_FAILURE_ENABLED = ConfigOptions.key("rss.stageRetry.fetchFailureEnabled").booleanType().defaultValue(false).withFallbackKeys(RSS_RESUBMIT_STAGE_ENABLED.key(), "rss.resubmit.stage").withDescription("If set to true, the stage retry mechanism will be enabled when a fetch failure occurs.");
    public static final ConfigOption<Boolean> RSS_RESUBMIT_STAGE_WITH_WRITE_FAILURE_ENABLED = ConfigOptions.key("rss.stageRetry.writeFailureEnabled").booleanType().defaultValue(false).withFallbackKeys(RSS_RESUBMIT_STAGE_ENABLED.key(), "rss.resubmit.stage").withDescription("If set to true, the stage retry mechanism will be enabled when a write failure occurs.");
    public static final ConfigOption<Boolean> RSS_BLOCK_ID_SELF_MANAGEMENT_ENABLED = ConfigOptions.key("rss.blockId.selfManagementEnabled").booleanType().defaultValue(false).withDescription("Whether to enable the blockId self management in spark driver side. Default value is false.");
    public static final ConfigOption<Long> RSS_CLIENT_SEND_SIZE_LIMITATION = ConfigOptions.key("rss.client.send.size.limit").longType().defaultValue(0x1000000L).withDescription("The max data size sent to shuffle server");
    public static final ConfigOption<Integer> RSS_MEMORY_SPILL_TIMEOUT = ConfigOptions.key("rss.client.memory.spill.timeout.sec").intType().defaultValue(1).withDescription("The timeout of spilling data to remote shuffle server, which will be triggered by Spark TaskMemoryManager. Unit is sec, default value is 1");
    public static final ConfigOption<Boolean> RSS_ROW_BASED = ConfigOptions.key("rss.row.based").booleanType().defaultValue(true).withDescription("indicates row based shuffle, set false when use in columnar shuffle");
    public static final ConfigOption<Boolean> RSS_MEMORY_SPILL_ENABLED = ConfigOptions.key("rss.client.memory.spill.enabled").booleanType().defaultValue(false).withDescription("The memory spill switch triggered by Spark TaskMemoryManager, default value is false.");
    public static final ConfigOption<Double> RSS_MEMORY_SPILL_RATIO = ConfigOptions.key("rss.client.memory.spill.ratio").doubleType().defaultValue(1.0).withDescription("The buffer size to spill when spill triggered by config spark.rss.writer.buffer.spill.size");
    public static final ConfigOption<Integer> RSS_PARTITION_REASSIGN_MAX_REASSIGNMENT_SERVER_NUM = ConfigOptions.key("rss.client.reassign.maxReassignServerNum").intType().defaultValue(10).withDescription("The max reassign server num for one partition when using partition reassign mechanism.");
    public static final ConfigOption<Integer> RSS_PARTITION_REASSIGN_BLOCK_RETRY_MAX_TIMES = ConfigOptions.key("rss.client.reassign.blockRetryMaxTimes").intType().defaultValue(1).withDescription("The block retry max times when partition reassign is enabled.");
    public static final ConfigOption<Boolean> RSS_CLIENT_MAP_SIDE_COMBINE_ENABLED = ConfigOptions.key("rss.client.mapSideCombine.enabled").booleanType().defaultValue(false).withDescription("Whether to enable map side combine of shuffle writer.");
    public static final String SPARK_RSS_CONFIG_PREFIX = "spark.";
    public static final ConfigEntry<Integer> RSS_PARTITION_NUM_PER_RANGE = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.partitionNum.per.range")).createWithDefault((Object)1);
    public static final ConfigEntry<String> RSS_WRITER_BUFFER_SIZE = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.writer.buffer.size").doc("Buffer size for single partition data")).createWithDefault((Object)"3m");
    public static final ConfigEntry<String> RSS_WRITER_SERIALIZER_BUFFER_SIZE = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.writer.serializer.buffer.size")).createWithDefault((Object)"3k");
    public static final ConfigEntry<String> RSS_WRITER_BUFFER_SEGMENT_SIZE = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.writer.buffer.segment.size")).createWithDefault((Object)"3k");
    public static final ConfigEntry<String> RSS_WRITER_BUFFER_SPILL_SIZE = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.writer.buffer.spill.size").doc("Buffer size for total partition data")).createWithDefault((Object)"128m");
    public static final ConfigEntry<String> RSS_WRITER_PRE_ALLOCATED_BUFFER_SIZE = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.writer.pre.allocated.buffer.size")).createWithDefault((Object)"16m");
    public static final ConfigEntry<Integer> RSS_WRITER_REQUIRE_MEMORY_RETRY_MAX = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.writer.require.memory.retryMax")).createWithDefault((Object)1200);
    public static final ConfigEntry<Long> RSS_WRITER_REQUIRE_MEMORY_INTERVAL = RssSparkConfig.createLongBuilder(new ConfigBuilder("spark.rss.writer.require.memory.interval")).createWithDefault((Object)1000L);
    public static final ConfigEntry<Long> RSS_CLIENT_SEND_CHECK_TIMEOUT_MS = RssSparkConfig.createLongBuilder(new ConfigBuilder("spark.rss.client.send.check.timeout.ms")).createWithDefault((Object)600000L);
    public static final ConfigEntry<Long> RSS_CLIENT_SEND_CHECK_INTERVAL_MS = RssSparkConfig.createLongBuilder(new ConfigBuilder("spark.rss.client.send.check.interval.ms")).createWithDefault((Object)500L);
    public static final ConfigEntry<Boolean> RSS_TEST_FLAG = RssSparkConfig.createBooleanBuilder(new ConfigBuilder("spark.rss.test")).createWithDefault((Object)false);
    public static final ConfigEntry<Boolean> RSS_TEST_MODE_ENABLE = RssSparkConfig.createBooleanBuilder(new ConfigBuilder("spark.rss.test.mode.enable").doc("Whether enable test mode for the Spark Client")).createWithDefault((Object)false);
    public static final ConfigEntry<String> RSS_REMOTE_STORAGE_PATH = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.remote.storage.path")).createWithDefault((Object)"");
    public static final ConfigEntry<Integer> RSS_INDEX_READ_LIMIT = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.index.read.limit")).createWithDefault((Object)500);
    public static final ConfigEntry<String> RSS_CLIENT_TYPE = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.client.type")).createWithDefault((Object)"GRPC");
    public static final ConfigEntry<String> RSS_STORAGE_TYPE = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.storage.type").doc("Supports MEMORY_LOCALFILE, MEMORY_HDFS, MEMORY_LOCALFILE_HDFS")).createWithDefault((Object)"");
    public static final ConfigEntry<Integer> RSS_CLIENT_RETRY_MAX = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.retry.max")).createWithDefault((Object)50);
    public static final ConfigEntry<Long> RSS_CLIENT_RETRY_INTERVAL_MAX = RssSparkConfig.createLongBuilder(new ConfigBuilder("spark.rss.client.retry.interval.max")).createWithDefault((Object)10000L);
    public static final ConfigEntry<Integer> RSS_CLIENT_HEARTBEAT_THREAD_NUM = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.heartBeat.threadNum")).createWithDefault((Object)4);
    public static final ConfigEntry<Integer> RSS_CLIENT_UNREGISTER_THREAD_POOL_SIZE = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.unregister.thread.pool.size")).createWithDefault((Object)10);
    public static final ConfigEntry<Integer> RSS_CLIENT_UNREGISTER_TIMEOUT_SEC = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.unregister.timeout.sec").doc("Unregister requests are executed concurrently and all requests together have to complete within this timeout.")).createWithDefault((Object)10);
    public static final ConfigEntry<Integer> RSS_CLIENT_UNREGISTER_REQUEST_TIMEOUT_SEC = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.unregister.request.timeout.sec").doc("Unregister requests are executed concurrently and individual requests have to complete within this timeout.")).createWithDefault((Object)10);
    public static final ConfigEntry<String> RSS_CLIENT_READ_BUFFER_SIZE = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.client.read.buffer.size").doc("The max data size read from storage")).createWithDefault((Object)"14m");
    public static final ConfigEntry<Long> RSS_HEARTBEAT_INTERVAL = RssSparkConfig.createLongBuilder(new ConfigBuilder("spark.rss.heartbeat.interval")).createWithDefault((Object)10000L);
    public static final ConfigEntry<Long> RSS_HEARTBEAT_TIMEOUT = RssSparkConfig.createLongBuilder(new ConfigBuilder("spark.rss.heartbeat.timeout")).createWithDefault((Object)5000L);
    public static final ConfigEntry<Integer> RSS_CLIENT_SEND_THREAD_POOL_SIZE = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.send.threadPool.size").doc("The thread size for send shuffle data to shuffle server")).createWithDefault((Object)10);
    public static final ConfigEntry<Integer> RSS_CLIENT_SEND_THREAD_POOL_KEEPALIVE = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.send.threadPool.keepalive")).createWithDefault((Object)60);
    public static final ConfigEntry<Integer> RSS_DATA_REPLICA = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.data.replica").doc("The max server number that each block can be send by client in quorum protocol")).createWithDefault((Object)1);
    public static final ConfigEntry<Integer> RSS_DATA_REPLICA_WRITE = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.data.replica.write").doc("The min server number that each block should be send by client successfully")).createWithDefault((Object)1);
    public static final ConfigEntry<Integer> RSS_DATA_REPLICA_READ = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.data.replica.read").doc("The min server number that metadata should be fetched by client successfully")).createWithDefault((Object)1);
    public static final ConfigEntry<Boolean> RSS_DATA_REPLICA_SKIP_ENABLED = RssSparkConfig.createBooleanBuilder(new ConfigBuilder("spark.rss.data.replica.skip.enabled")).createWithDefault((Object)true);
    public static final ConfigEntry<Integer> RSS_DATA_TRANSFER_POOL_SIZE = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.data.transfer.pool.size")).createWithDefault((Object)RssClientConfig.RSS_DATA_TRANSFER_POOL_SIZE_DEFAULT_VALUE);
    public static final ConfigEntry<Integer> RSS_DATA_COMMIT_POOL_SIZE = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.data.commit.pool.size").doc("The thread size for sending commit to shuffle servers")).createWithDefault((Object)-1);
    public static final ConfigEntry<Boolean> RSS_OZONE_DFS_NAMENODE_ODFS_ENABLE = RssSparkConfig.createBooleanBuilder(new ConfigBuilder("spark.rss.ozone.dfs.namenode.odfs.enable")).createWithDefault((Object)false);
    public static final ConfigEntry<String> RSS_OZONE_FS_HDFS_IMPL = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.ozone.fs.hdfs.impl")).createWithDefault((Object)"org.apache.hadoop.odfs.HdfsOdfsFilesystem");
    public static final ConfigEntry<String> RSS_OZONE_FS_ABSTRACT_FILE_SYSTEM_HDFS_IMPL = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.ozone.fs.AbstractFileSystem.hdfs.impl")).createWithDefault((Object)"org.apache.hadoop.odfs.HdfsOdfs");
    public static final ConfigEntry<Integer> RSS_CLIENT_BITMAP_SPLIT_NUM = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.bitmap.splitNum")).createWithDefault((Object)1);
    public static final ConfigEntry<String> RSS_ACCESS_ID = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.access.id")).createWithDefault((Object)"");
    public static final ConfigEntry<Integer> RSS_ACCESS_TIMEOUT_MS = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.access.timeout.ms")).createWithDefault((Object)10000);
    public static final ConfigEntry<Boolean> RSS_ENABLED = RssSparkConfig.createBooleanBuilder(new ConfigBuilder("spark.rss.enabled")).createWithDefault((Object)false);
    public static final ConfigEntry<Boolean> RSS_DYNAMIC_CLIENT_CONF_ENABLED = RssSparkConfig.createBooleanBuilder(new ConfigBuilder("spark.rss.dynamicClientConf.enabled")).createWithDefault((Object)true);
    public static final ConfigEntry<String> RSS_CLIENT_ASSIGNMENT_TAGS = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.client.assignment.tags").doc("The comma-separated list of tags for deciding assignment shuffle servers. Notice that the SHUFFLE_SERVER_VERSION will always as the assignment tag whether this conf is set or not")).createWithDefault((Object)"");
    public static final ConfigEntry<Boolean> RSS_CLIENT_OFF_HEAP_MEMORY_ENABLE = RssSparkConfig.createBooleanBuilder(new ConfigBuilder("spark." + RssClientConf.OFF_HEAP_MEMORY_ENABLE.key()).doc(RssClientConf.OFF_HEAP_MEMORY_ENABLE.description())).createWithDefault((Object)RssClientConf.OFF_HEAP_MEMORY_ENABLE.defaultValue());
    public static final ConfigEntry<Integer> RSS_CLIENT_ASSIGNMENT_SHUFFLE_SERVER_NUMBER = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.assignment.shuffle.nodes.max")).createWithDefault((Object)-1);
    public static final ConfigEntry<Long> RSS_CLIENT_ASSIGNMENT_RETRY_INTERVAL = RssSparkConfig.createLongBuilder(new ConfigBuilder("spark.rss.client.assignment.retry.interval")).createWithDefault((Object)65000L);
    public static final ConfigEntry<Integer> RSS_CLIENT_ASSIGNMENT_RETRY_TIMES = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.assignment.retry.times")).createWithDefault((Object)3);
    public static final ConfigEntry<Long> RSS_CLIENT_ACCESS_RETRY_INTERVAL_MS = RssSparkConfig.createLongBuilder(new ConfigBuilder("spark.rss.client.access.retry.interval.ms").doc("Interval between retries fallback to SortShuffleManager")).createWithDefault((Object)20000L);
    public static final ConfigEntry<Integer> RSS_CLIENT_ACCESS_RETRY_TIMES = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.client.access.retry.times").doc("Number of retries fallback to SortShuffleManager")).createWithDefault((Object)0);
    public static final ConfigEntry<String> RSS_COORDINATOR_QUORUM = RssSparkConfig.createStringBuilder(new ConfigBuilder("spark.rss.coordinator.quorum").doc("Coordinator quorum")).createWithDefault((Object)"");
    public static final ConfigEntry<Double> RSS_ESTIMATE_TASK_CONCURRENCY_DYNAMIC_FACTOR = RssSparkConfig.createDoubleBuilder(new ConfigBuilder("spark.rss.estimate.task.concurrency.dynamic.factor").doc("Between 0 and 1, used to estimate task concurrency, how likely is this part of the resource between spark.dynamicAllocation.minExecutors and spark.dynamicAllocation.maxExecutors to be allocated")).createWithDefault((Object)1.0);
    public static final ConfigEntry<Boolean> RSS_ESTIMATE_SERVER_ASSIGNMENT_ENABLED = RssSparkConfig.createBooleanBuilder(new ConfigBuilder("spark.rss.estimate.server.assignment.enabled").doc("Whether to estimate the number of ShuffleServers to be allocated based on the number of concurrent tasks.")).createWithDefault((Object)false);
    public static final ConfigEntry<Integer> RSS_ESTIMATE_TASK_CONCURRENCY_PER_SERVER = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.estimate.task.concurrency.per.server").doc("How many tasks concurrency to allocate a ShuffleServer, you need to enable spark.rss.estimate.server.assignment.enabled")).createWithDefault((Object)80);
    public static final ConfigEntry<Integer> RSS_SHUFFLE_MANAGER_GRPC_PORT = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark." + RssClientConf.SHUFFLE_MANAGER_GRPC_PORT.key()).internal().doc(RssClientConf.SHUFFLE_MANAGER_GRPC_PORT.description())).createWithDefault((Object)-1);
    public static final ConfigEntry<Integer> RSS_MAX_PARTITIONS = RssSparkConfig.createIntegerBuilder(new ConfigBuilder("spark.rss.blockId.maxPartitions").doc("Sets the maximum number of partitions to be supported by block ids. This determines the bits reserved in block ids for the sequence number, the partition id and the task attempt id.")).createWithDefault((Object)0x100000);
    public static final String SPARK_SHUFFLE_COMPRESS_KEY = "spark.shuffle.compress";
    public static final boolean SPARK_SHUFFLE_COMPRESS_DEFAULT = true;
    public static final Set<String> RSS_MANDATORY_CLUSTER_CONF = ImmutableSet.of(RSS_STORAGE_TYPE.key(), RSS_REMOTE_STORAGE_PATH.key());
    public static final boolean RSS_USE_RSS_SHUFFLE_MANAGER_DEFAULT_VALUE = false;

    public static TypedConfigBuilder<Integer> createIntegerBuilder(ConfigBuilder builder) {
        AbstractFunction1<String, Integer> f = new AbstractFunction1<String, Integer>(){

            public Integer apply(String in) {
                return (Integer)ConfigUtils.convertValue(in, Integer.class);
            }
        };
        return new TypedConfigBuilder(builder, (Function1)f);
    }

    public static TypedConfigBuilder<Long> createLongBuilder(ConfigBuilder builder) {
        AbstractFunction1<String, Long> f = new AbstractFunction1<String, Long>(){

            public Long apply(String in) {
                return (Long)ConfigUtils.convertValue(in, Long.class);
            }
        };
        return new TypedConfigBuilder(builder, (Function1)f);
    }

    public static TypedConfigBuilder<Boolean> createBooleanBuilder(ConfigBuilder builder) {
        AbstractFunction1<String, Boolean> f = new AbstractFunction1<String, Boolean>(){

            public Boolean apply(String in) {
                return (Boolean)ConfigUtils.convertValue(in, Boolean.class);
            }
        };
        return new TypedConfigBuilder(builder, (Function1)f);
    }

    public static TypedConfigBuilder<Double> createDoubleBuilder(ConfigBuilder builder) {
        AbstractFunction1<String, Double> f = new AbstractFunction1<String, Double>(){

            public Double apply(String in) {
                return (Double)ConfigUtils.convertValue(in, Double.class);
            }
        };
        return new TypedConfigBuilder(builder, (Function1)f);
    }

    public static TypedConfigBuilder<String> createStringBuilder(ConfigBuilder builder) {
        return builder.stringConf();
    }

    public static RssConf toRssConf(SparkConf sparkConf) {
        RssConf rssConf = new RssConf();
        for (Tuple2 tuple : sparkConf.getAll()) {
            String key = (String)tuple._1;
            if (!key.startsWith(SPARK_RSS_CONFIG_PREFIX)) continue;
            key = key.substring(SPARK_RSS_CONFIG_PREFIX.length());
            rssConf.setString(key, (String)tuple._2);
        }
        return rssConf;
    }
}

