/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import java.util.List;

public class OutputUtils {
    public static String listToSegment(List<Integer> numbers) {
        return OutputUtils.listToSegment(numbers, 1L, Long.MAX_VALUE);
    }

    public static String listToSegment(List<Integer> numbers, long threshold) {
        return OutputUtils.listToSegment(numbers, threshold, Long.MAX_VALUE);
    }

    public static String listToSegment(List<Integer> numbers, long threshold, long limit) {
        int start;
        if (numbers == null || numbers.isEmpty()) {
            return "[]";
        }
        if (threshold < 1L || (long)numbers.size() <= threshold) {
            return numbers.toString();
        }
        StringBuilder result = new StringBuilder();
        int end = start = numbers.get(0).intValue();
        long rangeCount = 0L;
        for (int i = 1; i < numbers.size(); ++i) {
            if (numbers.get(i) == numbers.get(i - 1) + 1) {
                end = numbers.get(i);
                continue;
            }
            if (rangeCount < limit) {
                OutputUtils.appendRange(result, start, end);
            }
            ++rangeCount;
            end = start = numbers.get(i).intValue();
        }
        if (++rangeCount < limit) {
            OutputUtils.appendRange(result, start, end);
        } else {
            result.append("...").append(rangeCount - limit).append(" more ranges...");
        }
        return result.toString();
    }

    private static void appendRange(StringBuilder result, int start, int end) {
        if (result.length() > 0) {
            result.append(", ");
        }
        if (start == end) {
            result.append(start);
        } else {
            result.append("[").append(start).append("~").append(end).append("]");
        }
    }
}

