/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import org.apache.uniffle.common.util.NettyUtils;
import org.apache.uniffle.shaded.io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.uniffle.shaded.io.grpc.netty.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.uniffle.shaded.io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;

public class GrpcNettyUtils {
    private static volatile PooledByteBufAllocator allocator;

    public static PooledByteBufAllocator createPooledByteBufAllocator(boolean preferDirect, int numCores, int pageSize, int maxOrder, int smallCacheSize) {
        return GrpcNettyUtils.createPooledByteBufAllocator(preferDirect, true, numCores, pageSize, maxOrder, smallCacheSize, 0);
    }

    private static PooledByteBufAllocator createPooledByteBufAllocator(boolean preferDirect, boolean allowCache, int numCores, int pageSize, int maxOrder, int smallCacheSize, int normalCacheSize) {
        numCores = NettyUtils.defaultNumThreads(numCores);
        if (pageSize == 0) {
            pageSize = PooledByteBufAllocator.defaultPageSize();
        }
        if (maxOrder == 0) {
            maxOrder = PooledByteBufAllocator.defaultMaxOrder();
        }
        if (smallCacheSize == 0) {
            smallCacheSize = PooledByteBufAllocator.defaultSmallCacheSize();
        }
        if (normalCacheSize == 0) {
            normalCacheSize = PooledByteBufAllocator.defaultNormalCacheSize();
        }
        return new PooledByteBufAllocator(preferDirect && PlatformDependent.directBufferPreferred(), Math.min(PooledByteBufAllocator.defaultNumHeapArena(), numCores), Math.min(PooledByteBufAllocator.defaultNumDirectArena(), preferDirect ? numCores : 0), pageSize, maxOrder, allowCache && smallCacheSize != -1 ? smallCacheSize : 0, allowCache && normalCacheSize != -1 ? normalCacheSize : 0, allowCache && PooledByteBufAllocator.defaultUseCacheForAllThreads());
    }

    public static PooledByteBufAllocator createPooledByteBufAllocatorWithSmallCacheOnly(boolean preferDirect, int numCores, int pageSize, int maxOrder, int smallCacheSize) {
        return GrpcNettyUtils.createPooledByteBufAllocator(preferDirect, true, numCores, pageSize, maxOrder, smallCacheSize, -1);
    }

    public static synchronized ByteBufAllocator getSharedPooledByteBufAllocator(int pageSize, int maxOrder, int smallCacheSize) {
        if (allocator == null) {
            allocator = GrpcNettyUtils.createPooledByteBufAllocator(true, 0, pageSize, maxOrder, smallCacheSize);
        }
        return allocator;
    }
}

