/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.UnsafeInput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.serializer.DeserializationStream;
import org.apache.uniffle.common.serializer.SerInputStream;
import org.apache.uniffle.common.serializer.SerOutputStream;
import org.apache.uniffle.common.serializer.SerializationStream;
import org.apache.uniffle.common.serializer.SerializerInstance;
import org.apache.uniffle.common.serializer.kryo.KryoDeserializationStream;
import org.apache.uniffle.common.serializer.kryo.KryoSerializationStream;
import org.apache.uniffle.common.serializer.kryo.PoolWrapper;
import org.apache.uniffle.shaded.org.apache.commons.lang3.ClassUtils;
import org.apache.uniffle.shaded.org.apache.commons.lang3.StringUtils;

public class KryoSerializerInstance
extends SerializerInstance {
    private final PoolWrapper pool;
    private final boolean scalaRegistrationRequired;
    private final RssConf rssConf;

    public KryoSerializerInstance(RssConf rssConf) {
        this.pool = new PoolWrapper(rssConf);
        this.scalaRegistrationRequired = rssConf.getBoolean(RssBaseConf.RSS_KRYO_SCALA_REGISTRATION_REQUIRED);
        this.rssConf = rssConf;
    }

    public Kryo borrowKryo() {
        Kryo kryo;
        block3: {
            kryo = this.pool.borrow();
            kryo.reset();
            try {
                Class<?> cls = ClassUtils.getClass("com.twitter.chill.AllScalaRegistrar");
                Object obj = cls.newInstance();
                Method method = cls.getDeclaredMethod("apply", Kryo.class);
                for (String className : StringUtils.split(this.rssConf.get(RssBaseConf.RSS_KRYO_REGISTRATION_CLASSES), ",")) {
                    kryo.register(ClassUtils.getClass(Thread.currentThread().getContextClassLoader(), className));
                }
                kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
                method.invoke(obj, kryo);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                if (!this.scalaRegistrationRequired) break block3;
                throw new RssException(e);
            }
        }
        return kryo;
    }

    public void releaseKryo(Kryo kryo) {
        this.pool.release(kryo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void serialize(T t2, DataOutputStream out) throws IOException {
        UnsafeOutput output = new UnsafeOutput((OutputStream)out);
        Kryo kryo = this.borrowKryo();
        try {
            kryo.writeClassAndObject((Output)output, t2);
            output.flush();
        }
        finally {
            this.releaseKryo(kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(DataInputBuffer buffer, Class vClass) throws IOException {
        UnsafeInput input = new UnsafeInput((InputStream)buffer);
        Kryo kryo = this.borrowKryo();
        try {
            Object object = kryo.readClassAndObject((Input)input);
            return (T)object;
        }
        finally {
            this.releaseKryo(kryo);
        }
    }

    @Override
    public <K, V> SerializationStream serializeStream(SerOutputStream output, boolean raw, boolean shared) {
        return new KryoSerializationStream(this, output);
    }

    @Override
    public <K, V> DeserializationStream deserializeStream(SerInputStream input, Class<K> keyClass, Class<V> valueClass, boolean raw, boolean shared) {
        return new KryoDeserializationStream<K, V>(this, input, keyClass, valueClass);
    }
}

