/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.uniffle.common.serializer.SerInputStream;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;

public class FileSerInputStream
extends SerInputStream {
    private final long start;
    private final long end;
    private FileInputStream input;
    private FileChannel fileChannel;
    private ByteBuffer bb = null;
    private byte[] bs = null;
    private byte[] b1;
    private long pos;

    public FileSerInputStream(File file, long start, long end) throws IOException {
        if (start < 0L) {
            throw new IOException("Negative position for channel!");
        }
        this.input = new FileInputStream(file);
        this.fileChannel = this.input.getChannel();
        if (this.fileChannel == null) {
            throw new IOException("channel is null!");
        }
        this.start = start;
        this.end = end;
        this.pos = start;
        this.fileChannel.position(start);
    }

    @Override
    public int available() {
        return (int)(this.end - this.pos);
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @Override
    public void transferTo(ByteBuf to, int len) throws IOException {
        byte[] bytes = new byte[len];
        while (len > 0) {
            int c = this.read(bytes, 0, bytes.length);
            len -= c;
        }
        to.writeBytes(bytes);
    }

    private int read(ByteBuffer bb) throws IOException {
        return this.fileChannel.read(bb);
    }

    @Override
    public synchronized int read() throws IOException {
        int n;
        if (this.b1 == null) {
            this.b1 = new byte[1];
        }
        if ((n = this.read(this.b1)) == 1) {
            return this.b1[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] bs, int off, int len) throws IOException {
        if (off < 0 || off > bs.length || len < 0 || off + len > bs.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        ByteBuffer bb = this.bs == bs ? this.bb : ByteBuffer.wrap(bs);
        bb.limit(Math.min(off + len, bb.capacity()));
        bb.position(off);
        this.bb = bb;
        this.bs = bs;
        int ret = this.read(bb);
        if (ret >= 0) {
            this.pos += (long)ret;
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
    }
}

