/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.uniffle.common.serializer.SerOutputStream;
import org.apache.uniffle.common.serializer.WrappedByteArrayOutputStream;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;
import org.apache.uniffle.shaded.io.netty.buffer.Unpooled;

public class DynBufferSerOutputStream
extends SerOutputStream {
    private WrappedByteArrayOutputStream buffer;

    public DynBufferSerOutputStream() {
        this.buffer = new WrappedByteArrayOutputStream();
    }

    public DynBufferSerOutputStream(int capacity) {
        this.buffer = new WrappedByteArrayOutputStream(capacity);
    }

    @Override
    public void write(ByteBuf from) throws IOException {
        byte[] bytes = new byte[from.readableBytes()];
        from.readBytes(bytes);
        this.buffer.write(bytes);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public ByteBuf toByteBuf() {
        return Unpooled.wrappedBuffer(ByteBuffer.wrap(this.buffer.toByteArray()));
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

