/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.logicalclocks.hsfs.spark.FeatureStore;
import com.logicalclocks.hsfs.spark.HopsworksConnection;
import com.logicalclocks.hsfs.spark.StreamFeatureGroup;
import com.logicalclocks.hsfs.spark.engine.SparkEngine;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainClass.class);

    private static Map<String, Object> readJobConf(String path) throws Exception {
        Configuration conf = new Configuration();
        Path filepath = new Path(path);
        FileSystem fileSystem = FileSystem.get((URI)filepath.toUri(), (Configuration)conf);
        FSDataInputStream jobConfigInStream = fileSystem.open(filepath);
        Map jobConfig = (Map)new ObjectMapper().readValue((InputStream)jobConfigInStream, HashMap.class);
        jobConfigInStream.close();
        return jobConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption(Option.builder("op").argName("op").required(true).hasArg().build());
        options.addOption(Option.builder("path").argName("path").required(true).hasArg().build());
        options.addOption(Option.builder("initialCheckPointString").argName("initialCheckPointString").required(false).hasArg().build());
        options.addOption(Option.builder("start_time").argName("start_time").required(false).hasArg().build());
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = parser.parse(options, args);
        String op = commandLine.getOptionValue("op");
        String path = commandLine.getOptionValue("path");
        String initialCheckPointString = commandLine.getOptionValue("initialCheckPointString");
        Map<String, Object> jobConf = MainClass.readJobConf(path);
        HopsworksConnection connection = HopsworksConnection.builder().build();
        FeatureStore fs = connection.getFeatureStore((String)jobConf.get("feature_store"));
        StreamFeatureGroup streamFeatureGroup = fs.getStreamFeatureGroup((String)jobConf.get("name"), Integer.valueOf(Integer.parseInt((String)jobConf.get("version"))));
        HashMap<String, String> writeOptions = (HashMap<String, String>)jobConf.get("write_options");
        if (initialCheckPointString != null) {
            if (writeOptions == null) {
                writeOptions = new HashMap<String, String>();
            }
            writeOptions.put("initialCheckPointString", initialCheckPointString);
        }
        LOGGER.info("Hsfs utils write options: {}", (Object)writeOptions);
        boolean success = false;
        try {
            if (op.equals("offline_fg_materialization") || op.equals("offline_fg_backfill")) {
                SparkEngine.getInstance().streamToHudiTable(streamFeatureGroup, writeOptions);
            }
            success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            LOGGER.info("Closing spark session...");
            try {
                SparkEngine.getInstance().closeSparkSession();
            }
            catch (Exception e) {
                LOGGER.error("Error closing spark session", (Throwable)e);
            }
            if (!success) {
                System.exit(1);
            }
        }
        System.exit(0);
    }
}

