/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hdfs.remote.client;

import io.hops.hdfs.remote.client.HdfsRemoteFSInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.remote.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.remote.shaded.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.remote.shaded.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.remote.shaded.org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.remote.shaded.org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.remote.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.remote.shaded.org.apache.hadoop.util.Progressable;

public class HdfsRemoteFileSystem
extends FileSystem {
    private static final String HDFS_URI_SCHEME = "hdfs";
    DistributedFileSystem dfs;

    public void initialize(URI uri, org.apache.hadoop.conf.Configuration conf) throws IOException {
        super.initialize(uri, conf);
        Configuration hdfsConf = new Configuration();
        for (Map.Entry entry : conf) {
            hdfsConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        String userName = System.getenv("REMOTE_HADOOP_USER_NAME");
        if (userName == null) {
            userName = System.getProperty("REMOTE_HADOOP_USER_NAME");
        }
        if (userName != null) {
            System.setProperty("REMOTE_HADOOP_USER_NAME", userName);
        }
        UserGroupInformation.setConfiguration((Configuration)hdfsConf);
        this.dfs = new DistributedFileSystem();
        this.dfs.initialize(uri, hdfsConf);
    }

    public org.apache.hadoop.fs.FileStatus getFileStatus(Path f) throws IOException {
        FileStatus fileSta = this.dfs.getFileStatus(this.toShadedPath(f));
        return this.toFileStatus(fileSta);
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.dfs.mkdirs(this.toShadedPath(f), this.toShadedPermission(permission));
    }

    public Path getWorkingDirectory() {
        return this.toPath(this.dfs.getWorkingDirectory());
    }

    public void setWorkingDirectory(Path new_dir) {
        this.dfs.setWorkingDirectory(this.toShadedPath(new_dir));
    }

    public org.apache.hadoop.fs.FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        FileStatus[] status = this.dfs.listStatus(this.toShadedPath(f));
        org.apache.hadoop.fs.FileStatus[] result = new org.apache.hadoop.fs.FileStatus[status.length];
        for (int i = 0; i < status.length; ++i) {
            result[i] = this.toFileStatus(status[i]);
        }
        return result;
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.dfs.delete(this.toShadedPath(f), recursive);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.dfs.rename(this.toShadedPath(src), this.toShadedPath(dst));
    }

    public org.apache.hadoop.fs.FSDataOutputStream append(Path f, int bufferSize, org.apache.hadoop.util.Progressable progress) throws IOException {
        FSDataOutputStream out = this.dfs.append(this.toShadedPath(f), bufferSize, this.toShadedProgressable(progress));
        return new org.apache.hadoop.fs.FSDataOutputStream((OutputStream)out, null);
    }

    public org.apache.hadoop.fs.FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, org.apache.hadoop.util.Progressable progress) throws IOException {
        FSDataOutputStream out = this.dfs.create(this.toShadedPath(f), this.toShadedPermission(permission), overwrite, bufferSize, replication, blockSize, this.toShadedProgressable(progress));
        return new org.apache.hadoop.fs.FSDataOutputStream((OutputStream)out, null);
    }

    public org.apache.hadoop.fs.FSDataInputStream open(Path f, int bufferSize) throws IOException {
        FSDataInputStream in = this.dfs.open(this.toShadedPath(f), bufferSize);
        return new org.apache.hadoop.fs.FSDataInputStream((InputStream)new HdfsRemoteFSInputStream(in));
    }

    public URI getUri() {
        return this.dfs.getUri();
    }

    public String getScheme() {
        return HDFS_URI_SCHEME;
    }

    public void close() throws IOException {
        if (this.dfs != null) {
            this.dfs.close();
        }
        super.close();
    }

    private org.apache.hadoop.fs.FileStatus toFileStatus(FileStatus fileSta) throws IOException {
        FsPermission permission = new FsPermission(fileSta.getPermission().toShort());
        Path symLink = fileSta.isSymlink() ? this.toPath(fileSta.getSymlink()) : null;
        Path path = this.toPath(fileSta.getPath());
        return new org.apache.hadoop.fs.FileStatus(fileSta.getLen(), fileSta.isDirectory(), (int)fileSta.getReplication(), fileSta.getBlockSize(), fileSta.getModificationTime(), fileSta.getAccessTime(), permission, fileSta.getOwner(), fileSta.getGroup(), symLink, path);
    }

    private Path toPath(org.apache.hadoop.remote.shaded.org.apache.hadoop.fs.Path p) {
        return p == null ? null : new Path(p.toUri());
    }

    private org.apache.hadoop.remote.shaded.org.apache.hadoop.fs.Path toShadedPath(Path p) {
        return p == null ? null : new org.apache.hadoop.remote.shaded.org.apache.hadoop.fs.Path(p.toUri());
    }

    private org.apache.hadoop.remote.shaded.org.apache.hadoop.fs.permission.FsPermission toShadedPermission(FsPermission p) {
        return p == null ? null : new org.apache.hadoop.remote.shaded.org.apache.hadoop.fs.permission.FsPermission(p.toShort());
    }

    private Progressable toShadedProgressable(final org.apache.hadoop.util.Progressable progress) {
        return progress == null ? null : new Progressable(){

            public void progress() {
                progress.progress();
            }
        };
    }
}

