/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.payload;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.hops.hudi.org.apache.spark.sql.avro.HoodieAvroDeserializer;
import io.hops.hudi.org.apache.spark.sql.avro.HoodieAvroSerializer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Base64;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SafeProjection$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.hudi.command.payload.ExpressionPayload$Serializer$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

public final class ExpressionPayload$
implements scala.Serializable {
    public static ExpressionPayload$ MODULE$;
    private final String PAYLOAD_DELETE_CONDITION;
    private final String PAYLOAD_UPDATE_CONDITION_AND_ASSIGNMENTS;
    private final String PAYLOAD_INSERT_CONDITION_AND_ASSIGNMENTS;
    private final String PAYLOAD_RECORD_AVRO_SCHEMA;
    private final String PAYLOAD_ORIGINAL_AVRO_PAYLOAD;
    private final String PAYLOAD_EXPECTED_COMBINED_SCHEMA;
    private final String PAYLOAD_SHOULD_VALIDATE_COMBINED_SCHEMA;
    private final ThreadLocal<Cache<Tuple2<String, Schema>, Seq<Tuple2<package.Projection, package.Projection>>>> projectionsCache;
    private final ThreadLocal<Cache<Schema, HoodieAvroDeserializer>> avroDeserializerCache;
    private final ThreadLocal<Cache<Schema, HoodieAvroSerializer>> avroSerializerCache;
    private final Cache<String, Object> schemaCache;
    private final Cache<Tuple2<Schema, Schema>, Schema> mergedSchemaCache;

    static {
        new ExpressionPayload$();
    }

    public String PAYLOAD_DELETE_CONDITION() {
        return this.PAYLOAD_DELETE_CONDITION;
    }

    public String PAYLOAD_UPDATE_CONDITION_AND_ASSIGNMENTS() {
        return this.PAYLOAD_UPDATE_CONDITION_AND_ASSIGNMENTS;
    }

    public String PAYLOAD_INSERT_CONDITION_AND_ASSIGNMENTS() {
        return this.PAYLOAD_INSERT_CONDITION_AND_ASSIGNMENTS;
    }

    public String PAYLOAD_RECORD_AVRO_SCHEMA() {
        return this.PAYLOAD_RECORD_AVRO_SCHEMA;
    }

    public String PAYLOAD_ORIGINAL_AVRO_PAYLOAD() {
        return this.PAYLOAD_ORIGINAL_AVRO_PAYLOAD;
    }

    public String PAYLOAD_EXPECTED_COMBINED_SCHEMA() {
        return this.PAYLOAD_EXPECTED_COMBINED_SCHEMA;
    }

    public String PAYLOAD_SHOULD_VALIDATE_COMBINED_SCHEMA() {
        return this.PAYLOAD_SHOULD_VALIDATE_COMBINED_SCHEMA;
    }

    private ThreadLocal<Cache<Tuple2<String, Schema>, Seq<Tuple2<package.Projection, package.Projection>>>> projectionsCache() {
        return this.projectionsCache;
    }

    private ThreadLocal<Cache<Schema, HoodieAvroDeserializer>> avroDeserializerCache() {
        return this.avroDeserializerCache;
    }

    private ThreadLocal<Cache<Schema, HoodieAvroSerializer>> avroSerializerCache() {
        return this.avroSerializerCache;
    }

    private Cache<String, Object> schemaCache() {
        return this.schemaCache;
    }

    public StructType getExpectedCombinedSchema(Properties props) {
        ValidationUtils.checkArgument(props.containsKey(this.PAYLOAD_EXPECTED_COMBINED_SCHEMA()), new StringBuilder(40).append("Missing ").append(this.PAYLOAD_EXPECTED_COMBINED_SCHEMA()).append(" property in the provided config").toString());
        return (StructType)this.getCachedSchema(props.getProperty(this.PAYLOAD_EXPECTED_COMBINED_SCHEMA()), (Function1 & Serializable & scala.Serializable)base64EncodedStructType -> (StructType)ExpressionPayload$Serializer$.MODULE$.toObject(Base64.getDecoder().decode((String)base64EncodedStructType)));
    }

    private <T> T getCachedSchema(String key, Function1<String, T> ctor) {
        return (T)this.schemaCache().get(key, new Function<String, T>(ctor){
            private final Function1 ctor$1;

            public <V> Function<V, T> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super T, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public T apply(String key) {
                return (T)this.ctor$1.apply((Object)key);
            }
            {
                this.ctor$1 = ctor$1;
            }
        });
    }

    private Cache<Tuple2<Schema, Schema>, Schema> mergedSchemaCache() {
        return this.mergedSchemaCache;
    }

    private Schema parseSchema(String schemaStr) {
        return (Schema)this.getCachedSchema(schemaStr, (Function1 & Serializable & scala.Serializable)x$5 -> new Schema.Parser().parse(x$5));
    }

    public Schema org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$getRecordSchema(Properties props) {
        ValidationUtils.checkArgument(props.containsKey(this.PAYLOAD_RECORD_AVRO_SCHEMA()), new StringBuilder(17).append("Missing ").append(this.PAYLOAD_RECORD_AVRO_SCHEMA()).append(" property").toString());
        return this.parseSchema(props.getProperty(this.PAYLOAD_RECORD_AVRO_SCHEMA()));
    }

    public Schema org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$getWriterSchema(Properties props, boolean shouldConsiderPartialUpdate) {
        if (shouldConsiderPartialUpdate) {
            String partialSchema = ConfigUtils.getStringWithAltKeys(props, HoodieWriteConfig.WRITE_PARTIAL_UPDATE_SCHEMA, true);
            if (!StringUtils.isNullOrEmpty(partialSchema)) {
                return this.parseSchema(partialSchema);
            }
            return this.getWriterSchema(props);
        }
        return this.getWriterSchema(props);
    }

    private Schema getWriterSchema(Properties props) {
        ValidationUtils.checkArgument(props.containsKey(HoodieWriteConfig.WRITE_SCHEMA_OVERRIDE.key()), new StringBuilder(17).append("Missing ").append(HoodieWriteConfig.WRITE_SCHEMA_OVERRIDE.key()).append(" property").toString());
        return this.parseSchema(props.getProperty(HoodieWriteConfig.WRITE_SCHEMA_OVERRIDE.key()));
    }

    public HoodieAvroDeserializer org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$getAvroDeserializerFor(Schema schema) {
        return this.avroDeserializerCache().get().get(schema, new Function<Schema, HoodieAvroDeserializer>(schema){
            private final Schema schema$1;

            public <V> Function<V, HoodieAvroDeserializer> compose(Function<? super V, ? extends Schema> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Schema, V> andThen(Function<? super HoodieAvroDeserializer, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public HoodieAvroDeserializer apply(Schema t) {
                return SparkAdapterSupport$.MODULE$.sparkAdapter().createAvroDeserializer(this.schema$1, (DataType)AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(this.schema$1));
            }
            {
                this.schema$1 = schema$1;
            }
        });
    }

    public HoodieAvroSerializer org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$getAvroSerializerFor(Schema schema) {
        return this.avroSerializerCache().get().get(schema, new Function<Schema, HoodieAvroSerializer>(schema){
            private final Schema schema$2;

            public <V> Function<V, HoodieAvroSerializer> compose(Function<? super V, ? extends Schema> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Schema, V> andThen(Function<? super HoodieAvroSerializer, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public HoodieAvroSerializer apply(Schema t) {
                return SparkAdapterSupport$.MODULE$.sparkAdapter().createAvroSerializer((DataType)AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(this.schema$2), this.schema$2, AvroSchemaUtils.isNullable(this.schema$2));
            }
            {
                this.schema$2 = schema$2;
            }
        });
    }

    public Seq<Tuple2<package.Projection, package.Projection>> org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$getEvaluator(String serializedConditionAssignments, Schema inputSchema) {
        return this.projectionsCache().get().get((Tuple2<String, Schema>)new Tuple2((Object)serializedConditionAssignments, (Object)inputSchema), new Function<Tuple2<String, Schema>, Seq<Tuple2<package.Projection, package.Projection>>>(){

            public <V> Function<V, Seq<Tuple2<package.Projection, package.Projection>>> compose(Function<? super V, ? extends Tuple2<String, Schema>> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Tuple2<String, Schema>, V> andThen(Function<? super Seq<Tuple2<package.Projection, package.Projection>>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Seq<Tuple2<package.Projection, package.Projection>> apply(Tuple2<String, Schema> key) {
                Tuple2<String, Schema> tuple2 = key;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String encodedConditionalAssignments = (String)tuple2._1();
                String encodedConditionalAssignments2 = encodedConditionalAssignments;
                byte[] serializedBytes = Base64.getDecoder().decode(encodedConditionalAssignments2);
                Map conditionAssignments = (Map)ExpressionPayload$Serializer$.MODULE$.toObject(serializedBytes);
                return (Seq)conditionAssignments.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Expression condition = (Expression)tuple2._1();
                        Seq assignments = (Seq)tuple2._2();
                        package.Projection conditionEvaluator = SafeProjection$.MODULE$.create((Seq)new .colon.colon((Object)condition, (List)Nil$.MODULE$));
                        package.Projection assignmentEvaluator = SafeProjection$.MODULE$.create(assignments);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)conditionEvaluator), (Object)assignmentEvaluator);
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(scala.Tuple2 )}, serializedLambda);
            }
        });
    }

    public Schema org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$getMergedSchema(Schema source, Schema target) {
        return this.mergedSchemaCache().get((Tuple2<Schema, Schema>)new Tuple2((Object)source, (Object)target), new Function<Tuple2<Schema, Schema>, Schema>(){

            public <V> Function<V, Schema> compose(Function<? super V, ? extends Tuple2<Schema, Schema>> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Tuple2<Schema, Schema>, V> andThen(Function<? super Schema, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Schema apply(Tuple2<Schema, Schema> t) {
                Schema rightSchema = HoodieAvroUtils.removeMetadataFields((Schema)t._2());
                return ExpressionPayload$.MODULE$.org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$mergeSchema((Schema)t._1(), rightSchema);
            }
        });
    }

    private void validateCompatibleSchemas(Schema joinedSchema, StructType expectedStructType, Properties props) {
        ValidationUtils.checkState(expectedStructType.fields().length == joinedSchema.getFields().size(), new StringBuilder(89).append("Expected schema diverges from the merged one: ").append("expected has ").append(expectedStructType.fields().length).append(" fields, while merged one has ").append(joinedSchema.getFields().size()).toString());
        boolean shouldValidate = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.PAYLOAD_SHOULD_VALIDATE_COMBINED_SCHEMA(), "false"))).toBoolean();
        if (shouldValidate) {
            Schema expectedSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)expectedStructType, joinedSchema.getName(), joinedSchema.getNamespace());
            ((IterableLike)((IterableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(expectedSchema.getFields()).asScala()).zip((GenIterable)JavaConverters$.MODULE$.asScalaBufferConverter(joinedSchema.getFields()).asScala(), Buffer$.MODULE$.canBuildFrom())).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ExpressionPayload$.$anonfun$validateCompatibleSchemas$1(x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Schema org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$mergeSchema(Schema a, Schema b) {
        Buffer mergedFields = ((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(a.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> new Schema.Field(new StringBuilder(7).append("source_").append(field.name()).toString(), field.schema(), field.doc(), field.defaultVal(), field.order()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(b.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> new Schema.Field(new StringBuilder(7).append("target_").append(field.name()).toString(), field.schema(), field.doc(), field.defaultVal(), field.order()), Buffer$.MODULE$.canBuildFrom()));
        return Schema.createRecord((String)a.getName(), (String)a.getDoc(), (String)a.getNamespace(), (boolean)a.isError(), (java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(mergedFields).asJava()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$validateCompatibleSchemas$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            if (tuple22 != null) {
                Schema.Field expectedField = (Schema.Field)tuple22._1();
                Schema.Field targetField = (Schema.Field)tuple22._2();
                Schema expectedFieldSchema = AvroSchemaUtils.resolveNullableSchema(expectedField.schema());
                Schema targetFieldSchema = AvroSchemaUtils.resolveNullableSchema(targetField.schema());
                boolean equal = Objects.equals(expectedFieldSchema, targetFieldSchema);
                ValidationUtils.checkState(equal, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(172).append("\n                 |Expected schema diverges from the target one in #").append(idx).append(" field:\n                 |Expected data-type: ").append(expectedFieldSchema).append("\n                 |Received data-type: ").append(targetFieldSchema).append("\n                 |").toString())).stripMargin());
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private ExpressionPayload$() {
        MODULE$ = this;
        this.PAYLOAD_DELETE_CONDITION = "hoodie.payload.delete.condition";
        this.PAYLOAD_UPDATE_CONDITION_AND_ASSIGNMENTS = "hoodie.payload.update.condition.assignments";
        this.PAYLOAD_INSERT_CONDITION_AND_ASSIGNMENTS = "hoodie.payload.insert.condition.assignments";
        this.PAYLOAD_RECORD_AVRO_SCHEMA = "hoodie.payload.record.schema";
        this.PAYLOAD_ORIGINAL_AVRO_PAYLOAD = "hoodie.payload.original.avro.payload";
        this.PAYLOAD_EXPECTED_COMBINED_SCHEMA = "hoodie.payload.combined.schema";
        this.PAYLOAD_SHOULD_VALIDATE_COMBINED_SCHEMA = "hoodie.payload.combined.schema.validate";
        this.projectionsCache = ThreadLocal.withInitial(new Supplier<Cache<Tuple2<String, Schema>, Seq<Tuple2<package.Projection, package.Projection>>>>(){

            public Cache<Tuple2<String, Schema>, Seq<Tuple2<package.Projection, package.Projection>>> get() {
                return Caffeine.newBuilder().maximumSize(1024L).build();
            }
        });
        this.avroDeserializerCache = ThreadLocal.withInitial(new Supplier<Cache<Schema, HoodieAvroDeserializer>>(){

            public Cache<Schema, HoodieAvroDeserializer> get() {
                return Caffeine.newBuilder().maximumSize(16L).build();
            }
        });
        this.avroSerializerCache = ThreadLocal.withInitial(new Supplier<Cache<Schema, HoodieAvroSerializer>>(){

            public Cache<Schema, HoodieAvroSerializer> get() {
                return Caffeine.newBuilder().maximumSize(16L).build();
            }
        });
        this.schemaCache = Caffeine.newBuilder().maximumSize(16L).build();
        this.mergedSchemaCache = Caffeine.newBuilder().maximumSize(16L).build();
    }
}

