/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.analysis;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.optimizer.ReplaceExpressions$;
import org.apache.spark.sql.catalyst.plans.logical.AnalysisHelper$;
import org.apache.spark.sql.catalyst.plans.logical.CallArgument;
import org.apache.spark.sql.catalyst.plans.logical.CallCommand;
import org.apache.spark.sql.catalyst.plans.logical.CompactionPath;
import org.apache.spark.sql.catalyst.plans.logical.CompactionShowOnPath;
import org.apache.spark.sql.catalyst.plans.logical.CompactionShowOnTable;
import org.apache.spark.sql.catalyst.plans.logical.CompactionTable;
import org.apache.spark.sql.catalyst.plans.logical.DeleteFromTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.NamedArgument;
import org.apache.spark.sql.catalyst.plans.logical.UpdateTable;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$MatchCreateIndex$;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$MatchDropIndex$;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$MatchMergeIntoTable$;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$MatchRefreshIndex$;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$MatchShowIndexes$;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$ResolvesToHudiTable$;
import org.apache.spark.sql.hudi.analysis.ResolveImplementations$;
import org.apache.spark.sql.hudi.command.CallProcedureHoodieCommand;
import org.apache.spark.sql.hudi.command.CompactionHoodiePathCommand;
import org.apache.spark.sql.hudi.command.CompactionHoodieTableCommand;
import org.apache.spark.sql.hudi.command.CompactionShowHoodiePathCommand;
import org.apache.spark.sql.hudi.command.CompactionShowHoodieTableCommand;
import org.apache.spark.sql.hudi.command.CreateIndexCommand;
import org.apache.spark.sql.hudi.command.DeleteHoodieTableCommand;
import org.apache.spark.sql.hudi.command.DropIndexCommand;
import org.apache.spark.sql.hudi.command.MergeIntoHoodieTableCommand;
import org.apache.spark.sql.hudi.command.RefreshIndexCommand;
import org.apache.spark.sql.hudi.command.ShowIndexesCommand;
import org.apache.spark.sql.hudi.command.UpdateHoodieTableCommand;
import org.apache.spark.sql.hudi.command.UpdateHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.procedures.HoodieProcedures$;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001\u0002\r\u001a\u0001\u001aB\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0005\")q\t\u0001C\u0001\u0011\")A\n\u0001C!\u001b\")\u0001\u000b\u0001C\u0005#\")1\u000f\u0001C\u0005i\"9a\u0010AA\u0001\n\u0003y\b\"CA\u0002\u0001E\u0005I\u0011AA\u0003\u0011%\tY\u0002AA\u0001\n\u0003\ni\u0002C\u0005\u0002.\u0001\t\t\u0011\"\u0001\u00020!I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003\u000b\u0002\u0011\u0011!C!\u0003\u000fB\u0011\"!\u0016\u0001\u0003\u0003%\t!a\u0016\t\u0013\u0005\u0005\u0004!!A\u0005B\u0005\r\u0004\"CA3\u0001\u0005\u0005I\u0011IA4\u0011%\tI\u0007AA\u0001\n\u0003\nYgB\u0005\u0002pe\t\t\u0011#\u0001\u0002r\u0019A\u0001$GA\u0001\u0012\u0003\t\u0019\b\u0003\u0004H%\u0011\u0005\u0011\u0011\u0011\u0005\n\u0003K\u0012\u0012\u0011!C#\u0003OB\u0001\u0002\u0014\n\u0002\u0002\u0013\u0005\u00151\u0011\u0005\n\u0003\u000f\u0013\u0012\u0011!CA\u0003\u0013C\u0011\"!%\u0013\u0003\u0003%I!a%\u0003-I+7o\u001c7wK&k\u0007\u000f\\3nK:$\u0018\r^5p]NT!AG\u000e\u0002\u0011\u0005t\u0017\r\\=tSNT!\u0001H\u000f\u0002\t!,H-\u001b\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0005\u0001\u001d:T\bE\u0002)[=j\u0011!\u000b\u0006\u0003U-\nQA];mKNT!\u0001L\u000f\u0002\u0011\r\fG/\u00197zgRL!AL\u0015\u0003\tI+H.\u001a\t\u0003aUj\u0011!\r\u0006\u0003eM\nq\u0001\\8hS\u000e\fGN\u0003\u00025W\u0005)\u0001\u000f\\1og&\u0011a'\r\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004Qe>$Wo\u0019;\u0011\u0005ar\u0014BA :\u00051\u0019VM]5bY&T\u0018M\u00197f\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\u0005\u0011\u0005CA\"E\u001b\u0005i\u0012BA#\u001e\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u00035\u0019\b/\u0019:l'\u0016\u001c8/[8oA\u00051A(\u001b8jiz\"\"!S&\u0011\u0005)\u0003Q\"A\r\t\u000b\u0001\u001b\u0001\u0019\u0001\"\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005=r\u0005\"B(\u0005\u0001\u0004y\u0013\u0001\u00029mC:\fQ\u0002\\8bIB\u0013xnY3ekJ,GC\u0001*^!\rA4+V\u0005\u0003)f\u0012aa\u00149uS>t\u0007C\u0001,\\\u001b\u00059&B\u0001-Z\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u00035n\tqaY8n[\u0006tG-\u0003\u0002]/\nI\u0001K]8dK\u0012,(/\u001a\u0005\u0006=\u0016\u0001\raX\u0001\u0005]\u0006lW\rE\u0002aQ.t!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u0011,\u0013A\u0002\u001fs_>$h(C\u0001;\u0013\t9\u0017(A\u0004qC\u000e\\\u0017mZ3\n\u0005%T'aA*fc*\u0011q-\u000f\t\u0003YBt!!\u001c8\u0011\u0005\tL\u0014BA8:\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=L\u0014A\u00052vS2$\u0007K]8dK\u0012,(/Z!sON$\"!\u001e=\u0011\u0005Y3\u0018BA<X\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\")\u0011P\u0002a\u0001u\u0006)Q\r\u001f9sgB\u0019\u0001\r[>\u0011\u0005Ab\u0018BA?2\u00051\u0019\u0015\r\u001c7Be\u001e,X.\u001a8u\u0003\u0011\u0019w\u000e]=\u0015\u0007%\u000b\t\u0001C\u0004A\u000fA\u0005\t\u0019\u0001\"\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0001\u0016\u0004\u0005\u0006%1FAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U\u0011(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0007\u0002\u0010\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\t1\fgn\u001a\u0006\u0003\u0003S\tAA[1wC&\u0019\u0011/a\t\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0002c\u0001\u001d\u00024%\u0019\u0011QG\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m\u0012\u0011\t\t\u0004q\u0005u\u0012bAA s\t\u0019\u0011I\\=\t\u0013\u0005\r3\"!AA\u0002\u0005E\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002JA1\u00111JA)\u0003wi!!!\u0014\u000b\u0007\u0005=\u0013(\u0001\u0006d_2dWm\u0019;j_:LA!a\u0015\u0002N\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI&a\u0018\u0011\u0007a\nY&C\u0002\u0002^e\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002D5\t\t\u00111\u0001\u0002<\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00022\u0005AAo\\*ue&tw\r\u0006\u0002\u0002 \u00051Q-];bYN$B!!\u0017\u0002n!I\u00111\t\t\u0002\u0002\u0003\u0007\u00111H\u0001\u0017%\u0016\u001cx\u000e\u001c<f\u00136\u0004H.Z7f]R\fG/[8ogB\u0011!JE\n\u0005%\u0005UT\b\u0005\u0004\u0002x\u0005u$)S\u0007\u0003\u0003sR1!a\u001f:\u0003\u001d\u0011XO\u001c;j[\u0016LA!a \u0002z\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0005EDcA%\u0002\u0006\")\u0001)\u0006a\u0001\u0005\u00069QO\\1qa2LH\u0003BAF\u0003\u001b\u00032\u0001O*C\u0011!\tyIFA\u0001\u0002\u0004I\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\n\u0005\u0003\u0002\"\u0005]\u0015\u0002BAM\u0003G\u0011aa\u00142kK\u000e$\b")
public class ResolveImplementations
extends Rule<LogicalPlan>
implements Product,
scala.Serializable {
    private final SparkSession sparkSession;

    public static Option<SparkSession> unapply(ResolveImplementations resolveImplementations) {
        return ResolveImplementations$.MODULE$.unapply(resolveImplementations);
    }

    public static <A> Function1<SparkSession, A> andThen(Function1<ResolveImplementations, A> function1) {
        return ResolveImplementations$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, ResolveImplementations> compose(Function1<A, SparkSession> function1) {
        return ResolveImplementations$.MODULE$.compose(function1);
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return (LogicalPlan)AnalysisHelper$.MODULE$.allowInvokingTransformsInAnalyzer((Function0 & Serializable & scala.Serializable)() -> {
            Option<Tuple2<LogicalPlan, String>> option;
            Option<Tuple2<LogicalPlan, Seq<Attribute>>> option2;
            Option<Tuple3<LogicalPlan, String, Object>> option3;
            DeleteFromTable deleteFromTable;
            LogicalPlan plan;
            Option<CatalogTable> option4;
            UpdateTable updateTable;
            LogicalPlan plan2;
            Option<CatalogTable> option5;
            LogicalPlan target;
            Option<CatalogTable> option6;
            LogicalPlan logicalPlan = plan;
            Option<Tuple3<LogicalPlan, LogicalPlan, Expression>> option7 = HoodieAnalysis$MatchMergeIntoTable$.MODULE$.unapply(logicalPlan);
            if (!option7.isEmpty() && !(option6 = HoodieAnalysis$ResolvesToHudiTable$.MODULE$.unapply(target = (LogicalPlan)((Tuple3)option7.get())._1())).isEmpty() && logicalPlan.resolved()) {
                return new MergeIntoHoodieTableCommand((MergeIntoTable)ReplaceExpressions$.MODULE$.apply(logicalPlan));
            }
            if (logicalPlan instanceof UpdateTable && !(option5 = HoodieAnalysis$ResolvesToHudiTable$.MODULE$.unapply(plan2 = (updateTable = (UpdateTable)logicalPlan).table())).isEmpty() && updateTable.resolved()) {
                LogicalPlan inputPlan = UpdateHoodieTableCommand$.MODULE$.inputPlan(this.sparkSession(), updateTable);
                return new UpdateHoodieTableCommand(updateTable, inputPlan);
            }
            if (logicalPlan instanceof DeleteFromTable && !(option4 = HoodieAnalysis$ResolvesToHudiTable$.MODULE$.unapply(plan = (deleteFromTable = (DeleteFromTable)logicalPlan).table())).isEmpty() && deleteFromTable.resolved()) {
                return new DeleteHoodieTableCommand(deleteFromTable);
            }
            if (logicalPlan instanceof CompactionTable) {
                CompactionTable compactionTable = (CompactionTable)logicalPlan;
                LogicalPlan plan3 = compactionTable.table();
                Enumeration.Value operation = compactionTable.operation();
                Option<Object> options = compactionTable.instantTimestamp();
                Option<CatalogTable> option8 = HoodieAnalysis$ResolvesToHudiTable$.MODULE$.unapply(plan3);
                if (!option8.isEmpty()) {
                    CatalogTable table = (CatalogTable)option8.get();
                    if (compactionTable.resolved()) {
                        return new CompactionHoodieTableCommand(table, operation, options);
                    }
                }
            }
            if (logicalPlan instanceof CompactionPath) {
                CompactionPath compactionPath = (CompactionPath)logicalPlan;
                String path = compactionPath.path();
                Enumeration.Value operation = compactionPath.operation();
                Option<Object> options = compactionPath.instantTimestamp();
                if (compactionPath.resolved()) {
                    return new CompactionHoodiePathCommand(path, operation, options);
                }
            }
            if (logicalPlan instanceof CompactionShowOnTable) {
                CompactionShowOnTable compactionShowOnTable = (CompactionShowOnTable)logicalPlan;
                LogicalPlan plan4 = compactionShowOnTable.table();
                int limit = compactionShowOnTable.limit();
                Option<CatalogTable> option9 = HoodieAnalysis$ResolvesToHudiTable$.MODULE$.unapply(plan4);
                if (!option9.isEmpty()) {
                    CatalogTable table = (CatalogTable)option9.get();
                    if (compactionShowOnTable.resolved()) {
                        return new CompactionShowHoodieTableCommand(table, limit);
                    }
                }
            }
            if (logicalPlan instanceof CompactionShowOnPath) {
                CompactionShowOnPath compactionShowOnPath = (CompactionShowOnPath)logicalPlan;
                String path = compactionShowOnPath.path();
                int limit = compactionShowOnPath.limit();
                if (compactionShowOnPath.resolved()) {
                    return new CompactionShowHoodiePathCommand(path, limit);
                }
            }
            if (logicalPlan instanceof CallCommand) {
                CallCommand callCommand = (CallCommand)logicalPlan;
                Option<Procedure> procedure = this.loadProcedure(callCommand.name());
                ProcedureArgs input = this.buildProcedureArgs(callCommand.args());
                if (procedure.nonEmpty()) {
                    return new CallProcedureHoodieCommand((Procedure)procedure.get(), input);
                }
                return callCommand;
            }
            Option<Tuple6<LogicalPlan, String, String, Object, Seq<Tuple2<Seq<String>, Map<String, String>>>, Map<String, String>>> option10 = HoodieAnalysis$MatchCreateIndex$.MODULE$.unapply(logicalPlan);
            if (!option10.isEmpty()) {
                LogicalPlan plan5 = (LogicalPlan)((Tuple6)option10.get())._1();
                String indexName = (String)((Tuple6)option10.get())._2();
                String indexType = (String)((Tuple6)option10.get())._3();
                boolean ignoreIfExists = BoxesRunTime.unboxToBoolean((Object)((Tuple6)option10.get())._4());
                Seq columns = (Seq)((Tuple6)option10.get())._5();
                Map options = (Map)((Tuple6)option10.get())._6();
                Option<CatalogTable> option11 = HoodieAnalysis$ResolvesToHudiTable$.MODULE$.unapply(plan5);
                if (!option11.isEmpty()) {
                    CatalogTable table = (CatalogTable)option11.get();
                    if (logicalPlan.resolved()) {
                        return new CreateIndexCommand(table, indexName, indexType, ignoreIfExists, (Seq<Tuple2<Seq<String>, Map<String, String>>>)columns, (Map<String, String>)options);
                    }
                }
            }
            if (!(option3 = HoodieAnalysis$MatchDropIndex$.MODULE$.unapply(logicalPlan)).isEmpty()) {
                LogicalPlan plan6 = (LogicalPlan)((Tuple3)option3.get())._1();
                String indexName = (String)((Tuple3)option3.get())._2();
                boolean ignoreIfNotExists = BoxesRunTime.unboxToBoolean((Object)((Tuple3)option3.get())._3());
                Option<CatalogTable> option12 = HoodieAnalysis$ResolvesToHudiTable$.MODULE$.unapply(plan6);
                if (!option12.isEmpty()) {
                    CatalogTable table = (CatalogTable)option12.get();
                    if (logicalPlan.resolved()) {
                        return new DropIndexCommand(table, indexName, ignoreIfNotExists);
                    }
                }
            }
            if (!(option2 = HoodieAnalysis$MatchShowIndexes$.MODULE$.unapply(logicalPlan)).isEmpty()) {
                LogicalPlan plan7 = (LogicalPlan)((Tuple2)option2.get())._1();
                Seq output = (Seq)((Tuple2)option2.get())._2();
                Option<CatalogTable> option13 = HoodieAnalysis$ResolvesToHudiTable$.MODULE$.unapply(plan7);
                if (!option13.isEmpty()) {
                    CatalogTable table = (CatalogTable)option13.get();
                    if (logicalPlan.resolved()) {
                        return new ShowIndexesCommand(table, (Seq<Attribute>)output);
                    }
                }
            }
            if (!(option = HoodieAnalysis$MatchRefreshIndex$.MODULE$.unapply(logicalPlan)).isEmpty()) {
                LogicalPlan plan8 = (LogicalPlan)((Tuple2)option.get())._1();
                String indexName = (String)((Tuple2)option.get())._2();
                Option<CatalogTable> option14 = HoodieAnalysis$ResolvesToHudiTable$.MODULE$.unapply(plan8);
                if (!option14.isEmpty()) {
                    CatalogTable table = (CatalogTable)option14.get();
                    if (logicalPlan.resolved()) {
                        return new RefreshIndexCommand(table, indexName);
                    }
                }
            }
            return plan;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Procedure> loadProcedure(Seq<String> name) {
        None$ none$;
        if (name.nonEmpty()) {
            ProcedureBuilder builder = HoodieProcedures$.MODULE$.newBuilder((String)name.last());
            if (builder == null) throw new AnalysisException(new StringBuilder(25).append("procedure: ").append(name.last()).append(" is not exists").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
            none$ = Option$.MODULE$.apply((Object)builder.build());
            return none$;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private ProcedureArgs buildProcedureArgs(Seq<CallArgument> exprs) {
        Object[] values2 = new Object[exprs.size()];
        BooleanRef isNamedArgs = BooleanRef.create((boolean)false);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        exprs.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            CallArgument callArgument = (CallArgument)exprs.apply(index);
            if (callArgument instanceof NamedArgument) {
                NamedArgument namedArgument = (NamedArgument)callArgument;
                map.put(namedArgument.name(), BoxesRunTime.boxToInteger((int)index));
                values$1[index] = namedArgument.expr().eval(namedArgument.expr().eval$default$1());
                isNamedArgs$1.elem = true;
                return;
            }
            map.put(Integer.toString(index), BoxesRunTime.boxToInteger((int)index));
            Expression qual$1 = ((CallArgument)exprs.apply(index)).expr();
            InternalRow x$1 = qual$1.eval$default$1();
            values$1[index] = qual$1.eval(x$1);
            isNamedArgs$1.elem = false;
        });
        return new ProcedureArgs(isNamedArgs.elem, map, (InternalRow)new GenericInternalRow(values2));
    }

    public ResolveImplementations copy(SparkSession sparkSession) {
        return new ResolveImplementations(sparkSession);
    }

    public SparkSession copy$default$1() {
        return this.sparkSession();
    }

    public String productPrefix() {
        return "ResolveImplementations";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sparkSession();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ResolveImplementations;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ResolveImplementations)) return false;
        boolean bl = true;
        if (!bl) return false;
        ResolveImplementations resolveImplementations = (ResolveImplementations)((Object)x$1);
        SparkSession sparkSession = this.sparkSession();
        SparkSession sparkSession2 = resolveImplementations.sparkSession();
        if (sparkSession == null) {
            if (sparkSession2 != null) {
                return false;
            }
        } else if (!sparkSession.equals(sparkSession2)) return false;
        if (!resolveImplementations.canEqual((Object)this)) return false;
        return true;
    }

    public ResolveImplementations(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Product.$init$((Product)this);
    }
}

