/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.Spark35ParquetReader$;
import org.apache.spark.sql.execution.datasources.parquet.Spark3ParquetSchemaEvolutionUtils;
import org.apache.spark.sql.execution.datasources.parquet.SparkParquetReader;
import org.apache.spark.sql.execution.datasources.parquet.SparkParquetReaderBase;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001\u0002\r\u001a\u0001!B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\t\u0001B\u0001B\u0003%Q\u0007\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003/\u0011!\u0011\u0005A!A!\u0002\u0013q\u0003\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011\u0011\u0003!\u0011!Q\u0001\n9B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005]!A!\n\u0001B\u0001B\u0003%a\u0006\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003/\u0011!a\u0005A!A!\u0002\u0013q\u0003\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u00119\u0003!\u0011!Q\u0001\n9B\u0001b\u0014\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t!\u0002\u0011\t\u0011)A\u0005#\")A\u000b\u0001C\u0001+\")q\r\u0001C)Q\u001e9\u0011\u0011M\r\t\u0002\u0005\rdA\u0002\r\u001a\u0011\u0003\t)\u0007\u0003\u0004U)\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003w\"B\u0011AA?\u0011%\t)\u000bFA\u0001\n\u0013\t9K\u0001\u000bTa\u0006\u00148nM\u001bQCJ\fX/\u001a;SK\u0006$WM\u001d\u0006\u00035m\tq\u0001]1scV,GO\u0003\u0002\u001d;\u0005YA-\u0019;bg>,(oY3t\u0015\tqr$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001%I\u0001\u0004gFd'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u000b\t\u0003U-j\u0011!G\u0005\u0003Ye\u0011ac\u00159be.\u0004\u0016M]9vKR\u0014V-\u00193fe\n\u000b7/Z\u0001\u0017K:\f'\r\\3WK\u000e$xN]5{K\u0012\u0014V-\u00193feB\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t9!i\\8mK\u0006t\u0017\u0001\u00073bi\u0016$\u0018.\\3SK\n\f7/Z'pI\u0016LeNU3bIB\u0011a'\u0010\b\u0003om\u0002\"\u0001\u000f\u0019\u000e\u0003eR!AO\u0014\u0002\rq\u0012xn\u001c;?\u0013\ta\u0004'\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f1\u0003UIg\u000e^\u001d7%\u0016\u0014\u0017m]3N_\u0012,\u0017J\u001c*fC\u0012\f1$\u001a8bE2,\u0007+\u0019:rk\u0016$h)\u001b7uKJ\u0004Vo\u001d5E_^t\u0017\u0001\u00049vg\"$un\u001e8ECR,\u0017!\u00059vg\"$un\u001e8US6,7\u000f^1na\u0006y\u0001/^:i\t><h\u000eR3dS6\fG.A\rqkNDGi\\<o\u0013:4\u0015\u000e\u001c;feRC'/Z:i_2$\u0007CA\u0018H\u0013\tA\u0005GA\u0002J]R\fq\u0003];tQ\u0012{wO\\*ue&tw\r\u0015:fI&\u001c\u0017\r^3\u0002\u001f%\u001c8)Y:f'\u0016t7/\u001b;jm\u0016\f1\u0003^5nKN$\u0018-\u001c9D_:4XM]:j_:\f\u0011$\u001a8bE2,wJ\u001a4IK\u0006\u00048i\u001c7v[:4Vm\u0019;pe\u0006A1-\u00199bG&$\u00180\u0001\bsKR,(O\\5oO\n\u000bGo\u00195\u0002%\u0015t\u0017M\u00197f%\u0016\u001cwN\u001d3GS2$XM]\u0001\u000bi&lWMW8oK&#\u0007cA\u0018Sk%\u00111\u000b\r\u0002\u0007\u001fB$\u0018n\u001c8\u0002\rqJg.\u001b;?)E1v\u000bW-[7rkfl\u00181bE\u000e$WM\u001a\t\u0003U\u0001AQ!L\tA\u00029BQ\u0001N\tA\u0002UBQ\u0001Q\tA\u0002UBQ!Q\tA\u00029BQAQ\tA\u00029BQaQ\tA\u00029BQ\u0001R\tA\u00029BQ!R\tA\u0002\u0019CQ!S\tA\u00029BQAS\tA\u00029BQaS\tA\u00029BQ\u0001T\tA\u00029BQ!T\tA\u0002\u0019CQAT\tA\u00029BQaT\tA\u00029BQ\u0001U\tA\u0002E\u000ba\u0001Z8SK\u0006$GcC5y}\u00065\u0011\u0011CA\u001c\u0003\u001b\u00022A[8s\u001d\tYWN\u0004\u00029Y&\t\u0011'\u0003\u0002oa\u00059\u0001/Y2lC\u001e,\u0017B\u00019r\u0005!IE/\u001a:bi>\u0014(B\u000181!\t\u0019h/D\u0001u\u0015\t)x$\u0001\u0005dCR\fG._:u\u0013\t9HOA\u0006J]R,'O\\1m%><\b\"B=\u0013\u0001\u0004Q\u0018\u0001\u00024jY\u0016\u0004\"a\u001f?\u000e\u0003mI!!`\u000e\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016Daa \nA\u0002\u0005\u0005\u0011A\u0004:fcVL'/\u001a3TG\",W.\u0019\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA\u0010\u0002\u000bQL\b/Z:\n\t\u0005-\u0011Q\u0001\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\b%\u0001\u0007\u0011\u0011A\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"9\u00111\u0003\nA\u0002\u0005U\u0011!E5oi\u0016\u0014h.\u00197TG\",W.Y(qiB1\u0011qCA\u0013\u0003Oi!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0005kRLGN\u0003\u0003\u0002 \u0005\u0005\u0012AB2p[6|gNC\u0002\u0002$\r\nA\u0001[;eS&\u00191+!\u0007\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u000511o\u00195f[\u0006TA!!\r\u0002\"\u0005A\u0011N\u001c;fe:\fG.\u0003\u0003\u00026\u0005-\"AD%oi\u0016\u0014h.\u00197TG\",W.\u0019\u0005\b\u0003s\u0011\u0002\u0019AA\u001e\u0003\u001d1\u0017\u000e\u001c;feN\u0004RA[A\u001f\u0003\u0003J1!a\u0010r\u0005\r\u0019V-\u001d\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011qI\u0010\u0002\u000fM|WO]2fg&!\u00111JA#\u0005\u00191\u0015\u000e\u001c;fe\"9\u0011q\n\nA\u0002\u0005E\u0013AC:iCJ,GmQ8oMB!\u00111KA/\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013\u0001B2p]\u001aT1!a\u0017$\u0003\u0019A\u0017\rZ8pa&!\u0011qLA+\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006!2\u000b]1sWN*\u0004+\u0019:rk\u0016$(+Z1eKJ\u0004\"A\u000b\u000b\u0014\u000fQ\t9'!\u001c\u0002tA\u0019q&!\u001b\n\u0007\u0005-\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0004U\u0005=\u0014bAA93\tI2\u000b]1sWB\u000b'/];fiJ+\u0017\rZ3s\u0005VLG\u000eZ3s!\ry\u0013QO\u0005\u0004\u0003o\u0002$\u0001D*fe&\fG.\u001b>bE2,GCAA2\u0003\u0015\u0011W/\u001b7e))\ty(!\"\u0002\n\u0006]\u0015\u0011\u0015\t\u0004U\u0005\u0005\u0015bAAB3\t\u00112\u000b]1sWB\u000b'/];fiJ+\u0017\rZ3s\u0011\u0019\t9I\u0006a\u0001]\u0005Qa/Z2u_JL'0\u001a3\t\u000f\u0005-e\u00031\u0001\u0002\u000e\u000691/\u001d7D_:4\u0007\u0003BAH\u0003'k!!!%\u000b\u0007\u0005Er$\u0003\u0003\u0002\u0016\u0006E%aB*R\u0019\u000e{gN\u001a\u0005\b\u000333\u0002\u0019AAN\u0003\u001dy\u0007\u000f^5p]N\u0004RANAOkUJ1!a(@\u0005\ri\u0015\r\u001d\u0005\b\u0003G3\u0002\u0019AA)\u0003)A\u0017\rZ8pa\u000e{gNZ\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002*B!\u00111VA[\u001b\t\tiK\u0003\u0003\u00020\u0006E\u0016\u0001\u00027b]\u001eT!!a-\u0002\t)\fg/Y\u0005\u0005\u0003o\u000biK\u0001\u0004PE*,7\r\u001e")
public class Spark35ParquetReader
extends SparkParquetReaderBase {
    private final boolean enableVectorizedReader;
    private final String datetimeRebaseModeInRead;
    private final String int96RebaseModeInRead;
    private final boolean enableParquetFilterPushDown;
    private final boolean pushDownDate;
    private final boolean pushDownTimestamp;
    private final boolean pushDownDecimal;
    private final int pushDownInFilterThreshold;
    private final boolean pushDownStringPredicate;
    private final boolean isCaseSensitive;
    private final boolean timestampConversion;
    private final boolean enableOffHeapColumnVector;
    private final int capacity;
    private final boolean returningBatch;
    private final boolean enableRecordFilter;
    private final Option<String> timeZoneId;

    public static SparkParquetReader build(boolean bl, SQLConf sQLConf, scala.collection.immutable.Map<String, String> map, Configuration configuration) {
        return Spark35ParquetReader$.MODULE$.build(bl, sQLConf, map, configuration);
    }

    @Override
    public Iterator<InternalRow> doRead(PartitionedFile file, StructType requiredSchema, StructType partitionSchema, org.apache.hudi.common.util.Option<InternalSchema> internalSchemaOpt, Seq<Filter> filters, Configuration sharedConf) {
        Iterator iterator2;
        ParquetRecordReader parquetRecordReader;
        None$ none$;
        Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
        Path filePath = file.toPath();
        FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        Spark3ParquetSchemaEvolutionUtils schemaEvolutionUtils = new Spark3ParquetSchemaEvolutionUtils(sharedConf, filePath, requiredSchema, partitionSchema, internalSchemaOpt);
        ParquetMetadata fileFooter = this.enableVectorizedReader ? ParquetFooterReader.readFooter((Configuration)sharedConf, (PartitionedFile)file, (boolean)false) : ParquetFooterReader.readFooter((Configuration)sharedConf, (PartitionedFile)file, (boolean)true);
        FileMetaData footerFileMetaData = fileFooter.getFileMetaData();
        Map map = footerFileMetaData.getKeyValueMetaData();
        RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1 & Serializable & scala.Serializable)x$1 -> (String)map.get(x$1), this.datetimeRebaseModeInRead);
        Map map2 = footerFileMetaData.getKeyValueMetaData();
        RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1 & Serializable & scala.Serializable)x$1 -> (String)map2.get(x$1), this.int96RebaseModeInRead);
        if (this.enableParquetFilterPushDown) {
            MessageType parquetSchema = footerFileMetaData.getSchema();
            ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, this.pushDownDate, this.pushDownTimestamp, this.pushDownDecimal, this.pushDownStringPredicate, this.pushDownInFilterThreshold, this.isCaseSensitive, datetimeRebaseSpec);
            none$ = ((TraversableOnce)((TraversableLike)filters.map((Function1 & Serializable & scala.Serializable)filter -> schemaEvolutionUtils.rebuildFilterFromParquet((Filter)filter), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter(x$1)), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
        } else {
            none$ = None$.MODULE$;
        }
        None$ pushed = none$;
        None$ convertTz = this.timestampConversion && !Spark35ParquetReader.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
        TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
        TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(schemaEvolutionUtils.getHadoopConfClone(footerFileMetaData, this.enableVectorizedReader), attemptId);
        if (pushed.isDefined()) {
            ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
        }
        Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        if (this.enableVectorizedReader) {
            RecordReaderIterator recordReaderIterator;
            VectorizedParquetRecordReader vectorizedReader = schemaEvolutionUtils.buildVectorizedReader((ZoneId)convertTz.orNull(Predef$.MODULE$.$conforms()), datetimeRebaseSpec.mode().toString(), datetimeRebaseSpec.timeZone(), int96RebaseSpec.mode().toString(), int96RebaseSpec.timeZone(), this.enableOffHeapColumnVector && taskContext.isDefined(), this.capacity);
            RecordReaderIterator iter = new RecordReaderIterator((RecordReader)vectorizedReader);
            try {
                vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext, Option$.MODULE$.apply((Object)fileFooter));
                vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                if (this.returningBatch) {
                    vectorizedReader.enableReturningBatches();
                }
                recordReaderIterator = iter;
            }
            catch (Throwable e) {
                iter.close();
                throw e;
            }
            return recordReaderIterator;
        }
        ParquetReadSupport readSupport = new ParquetReadSupport((Option)convertTz, false, datetimeRebaseSpec, int96RebaseSpec);
        if (pushed.isDefined() && this.enableRecordFilter) {
            FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
            parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
        } else {
            parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
        }
        ParquetRecordReader reader = parquetRecordReader;
        RecordReader readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded(reader, requiredSchema);
        RecordReaderIterator iter = new RecordReaderIterator(readerWithRowIndexes);
        try {
            readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
            Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((GenTraversableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema), Seq$.MODULE$.canBuildFrom());
            UnsafeProjection unsafeProjection = schemaEvolutionUtils.generateUnsafeProjection((Seq<AttributeReference>)fullSchema, this.timeZoneId);
            if (partitionSchema.length() == 0) {
                iterator2 = iter.map((Function1)unsafeProjection);
            } else {
                JoinedRow joinedRow = new JoinedRow();
                iterator2 = iter.map((Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
            }
        }
        catch (Throwable e) {
            iter.close();
            throw e;
        }
        return iterator2;
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public Spark35ParquetReader(boolean enableVectorizedReader, String datetimeRebaseModeInRead, String int96RebaseModeInRead, boolean enableParquetFilterPushDown, boolean pushDownDate, boolean pushDownTimestamp, boolean pushDownDecimal, int pushDownInFilterThreshold, boolean pushDownStringPredicate, boolean isCaseSensitive, boolean timestampConversion, boolean enableOffHeapColumnVector, int capacity, boolean returningBatch, boolean enableRecordFilter, Option<String> timeZoneId) {
        this.enableVectorizedReader = enableVectorizedReader;
        this.datetimeRebaseModeInRead = datetimeRebaseModeInRead;
        this.int96RebaseModeInRead = int96RebaseModeInRead;
        this.enableParquetFilterPushDown = enableParquetFilterPushDown;
        this.pushDownDate = pushDownDate;
        this.pushDownTimestamp = pushDownTimestamp;
        this.pushDownDecimal = pushDownDecimal;
        this.pushDownInFilterThreshold = pushDownInFilterThreshold;
        this.pushDownStringPredicate = pushDownStringPredicate;
        this.isCaseSensitive = isCaseSensitive;
        this.timestampConversion = timestampConversion;
        this.enableOffHeapColumnVector = enableOffHeapColumnVector;
        this.capacity = capacity;
        this.returningBatch = returningBatch;
        this.enableRecordFilter = enableRecordFilter;
        this.timeZoneId = timeZoneId;
        super(enableVectorizedReader, enableParquetFilterPushDown, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownInFilterThreshold, isCaseSensitive, timestampConversion, enableOffHeapColumnVector, capacity, returningBatch, enableRecordFilter, timeZoneId);
    }
}

