/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.StorageSchemes;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.AppendMarkerHandler;
import org.apache.hudi.table.marker.DirectWriteMarkers;
import org.apache.hudi.table.marker.DirectWriteMarkersV1;
import org.apache.hudi.table.marker.TimelineServerBasedWriteMarkers;
import org.apache.hudi.table.marker.TimelineServerBasedWriteMarkersV1;
import org.apache.hudi.table.marker.WriteMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteMarkersFactory {
    private static final Logger LOG = LoggerFactory.getLogger(WriteMarkersFactory.class);

    public static WriteMarkers get(MarkerType markerType, HoodieTable table, String instantTime) {
        LOG.debug("Instantiated MarkerFiles with marker type: " + markerType.toString());
        switch (markerType) {
            case DIRECT: {
                return WriteMarkersFactory.getDirectWriteMarkers(table, instantTime);
            }
            case TIMELINE_SERVER_BASED: {
                if (!table.getConfig().isEmbeddedTimelineServerEnabled()) {
                    LOG.warn("Timeline-server-based markers are configured as the marker type but embedded timeline server is not enabled.  Falling back to direct markers.");
                    return WriteMarkersFactory.getDirectWriteMarkers(table, instantTime);
                }
                String basePath = table.getMetaClient().getBasePath().toString();
                if (StorageSchemes.HDFS.getScheme().equals(HadoopFSUtils.getFs(basePath, table.getContext().getStorageConf(), true).getScheme())) {
                    LOG.warn("Timeline-server-based markers are not supported for HDFS: base path " + basePath + ".  Falling back to direct markers.");
                    return WriteMarkersFactory.getDirectWriteMarkers(table, instantTime);
                }
                return table.getMetaClient().getTableConfig().getTableVersion().greaterThanOrEquals(HoodieTableVersion.EIGHT) ? new TimelineServerBasedWriteMarkers(table, instantTime) : new TimelineServerBasedWriteMarkersV1(table, instantTime);
            }
        }
        throw new HoodieException("The marker type \"" + markerType.name() + "\" is not supported.");
    }

    public static AppendMarkerHandler getAppendMarkerHandler(MarkerType markerType, HoodieTable table, String instantTime) {
        ValidationUtils.checkArgument(table.getMetaClient().getTableConfig().getTableVersion().lesserThan(HoodieTableVersion.EIGHT), "Expects table version 6 and below for getting the AppendMarkerHandler");
        return (AppendMarkerHandler)((Object)WriteMarkersFactory.get(markerType, table, instantTime));
    }

    private static DirectWriteMarkers getDirectWriteMarkers(HoodieTable table, String instantTime) {
        return table.getMetaClient().getTableConfig().getTableVersion().greaterThanOrEquals(HoodieTableVersion.EIGHT) ? new DirectWriteMarkers(table, instantTime) : new DirectWriteMarkersV1(table, instantTime);
    }
}

