/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieDeletePartitionPendingTableServiceException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseSparkCommitActionExecutor;
import org.apache.hudi.table.action.commit.ConsistentBucketBulkInsertDataInternalWriterHelper;
import org.apache.hudi.table.action.commit.SparkDeletePartitionCommitActionExecutor;
import org.apache.hudi.table.action.ttl.strategy.HoodiePartitionTTLStrategyFactory;
import org.apache.hudi.table.action.ttl.strategy.PartitionTTLStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkPartitionTTLActionExecutor<T>
extends BaseSparkCommitActionExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ConsistentBucketBulkInsertDataInternalWriterHelper.class);

    public SparkPartitionTTLActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime) {
        super(context, config, table, instantTime, WriteOperationType.DELETE_PARTITION);
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> execute() {
        HoodieWriteMetadata<HoodieData<WriteStatus>> emptyResult = new HoodieWriteMetadata<HoodieData<WriteStatus>>();
        emptyResult.setPartitionToReplaceFileIds(Collections.emptyMap());
        emptyResult.setWriteStatuses(this.context.emptyHoodieData());
        try {
            PartitionTTLStrategy strategy = HoodiePartitionTTLStrategyFactory.createStrategy(this.table, this.config.getProps(), this.instantTime);
            List<String> expiredPartitions = strategy.getExpiredPartitionPaths();
            if (expiredPartitions.isEmpty()) {
                return emptyResult;
            }
            LOG.info("Partition ttl find the following expired partitions to delete:  " + String.join((CharSequence)",", expiredPartitions));
            HoodieWriteConfig autoCommitConfig = HoodieWriteConfig.newBuilder().withProperties(this.config.getProps()).withAutoCommit(true).build();
            return new SparkDeletePartitionCommitActionExecutor(this.context, autoCommitConfig, this.table, this.instantTime, expiredPartitions).execute();
        }
        catch (HoodieDeletePartitionPendingTableServiceException deletePartitionPendingTableServiceException) {
            LOG.info("Partition is under table service, do nothing, call delete partition next time.");
            return emptyResult;
        }
        catch (IOException e) {
            throw new HoodieIOException("Error executing hoodie partition ttl: ", e);
        }
    }
}

