/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.Collections;
import java.util.List;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.action.commit.BucketInfo;
import org.apache.hudi.table.action.commit.BucketType;
import org.apache.hudi.table.action.commit.SmallFile;
import org.apache.hudi.table.action.commit.UpsertPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkInsertOverwritePartitioner
extends UpsertPartitioner {
    private static final Logger LOG = LoggerFactory.getLogger(SparkInsertOverwritePartitioner.class);

    public SparkInsertOverwritePartitioner(WorkloadProfile profile, HoodieEngineContext context, HoodieTable table, HoodieWriteConfig config, WriteOperationType operationType) {
        super(profile, context, table, config, operationType);
    }

    @Override
    public BucketInfo getBucketInfo(int bucketNumber) {
        BucketInfo bucketInfo = super.getBucketInfo(bucketNumber);
        switch (bucketInfo.bucketType) {
            case INSERT: {
                return bucketInfo;
            }
            case UPDATE: {
                return new BucketInfo(BucketType.INSERT, FSUtils.createNewFileIdPfx(), bucketInfo.partitionPath);
            }
        }
        throw new AssertionError();
    }

    @Override
    protected List<SmallFile> getSmallFiles(String partitionPath) {
        return Collections.emptyList();
    }
}

