/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.m3;

import io.hops.hudi.com.codahale.metrics.MetricRegistry;
import io.hops.hudi.com.uber.m3.tally.RootScopeBuilder;
import io.hops.hudi.com.uber.m3.tally.Scope;
import io.hops.hudi.com.uber.m3.tally.m3.M3Reporter;
import io.hops.hudi.com.uber.m3.util.Duration;
import io.hops.hudi.com.uber.m3.util.ImmutableMap;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.m3.M3ScopeReporterAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class M3MetricsReporter
extends MetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(M3MetricsReporter.class);
    private final HoodieMetricsConfig metricsConfig;
    private final MetricRegistry registry;
    private final ImmutableMap<String, String> tags;

    public M3MetricsReporter(HoodieMetricsConfig metricsConfig, MetricRegistry registry) {
        this.metricsConfig = metricsConfig;
        this.registry = registry;
        ImmutableMap.Builder<String, String> tagBuilder = new ImmutableMap.Builder<String, String>();
        tagBuilder.putAll(M3MetricsReporter.parseOptionalTags(metricsConfig.getM3Tags()));
        tagBuilder.put("service", metricsConfig.getM3Service());
        tagBuilder.put("env", metricsConfig.getM3Env());
        this.tags = tagBuilder.build();
        LOG.info(String.format("Building M3 Reporter with M3 tags mapping: %s", this.tags));
    }

    private static Map parseOptionalTags(String tagValueString) {
        HashMap parsedTags = new HashMap();
        if (!tagValueString.isEmpty()) {
            Arrays.stream(tagValueString.split(",")).forEach(tagValuePair -> {
                String[] parsedTagValuePair = (String[])Arrays.stream(tagValuePair.split("=")).map(tagOrValue -> tagOrValue.trim()).filter(tagOrValue -> !tagOrValue.isEmpty()).toArray(String[]::new);
                if (parsedTagValuePair.length != 2) {
                    throw new RuntimeException(String.format("M3 Reporter tags cannot be initialized with tags [%s] due to not being in format `tag=value, . . .`.", tagValuePair));
                }
                parsedTags.put(parsedTagValuePair[0], parsedTagValuePair[1]);
            });
        }
        return parsedTags;
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report() {
        M3MetricsReporter m3MetricsReporter = this;
        synchronized (m3MetricsReporter) {
            try (Scope scope = new RootScopeBuilder().reporter(new M3Reporter.Builder(new InetSocketAddress(this.metricsConfig.getM3ServerHost(), this.metricsConfig.getM3ServerPort())).includeHost(true).commonTags(this.tags).build()).reportEvery(Duration.ofSeconds(2.147483647E9)).tagged(this.tags);){
                M3ScopeReporterAdaptor scopeReporter = new M3ScopeReporterAdaptor(this.registry, scope);
                scopeReporter.start(Integer.MAX_VALUE, TimeUnit.SECONDS);
                scopeReporter.report();
                scopeReporter.stop();
            }
            catch (Exception e) {
                LOG.error(String.format("Error reporting metrics to M3: %s", e));
            }
        }
    }

    @Override
    public void stop() {
    }
}

