/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import io.hops.hudi.com.codahale.metrics.MetricFilter;
import io.hops.hudi.com.codahale.metrics.MetricRegistry;
import io.hops.hudi.com.codahale.metrics.Slf4jReporter;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jMetricsReporter
extends MetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(Slf4jMetricsReporter.class);
    private final Slf4jReporter reporter;

    public Slf4jMetricsReporter(MetricRegistry registry) {
        this.reporter = Slf4jReporter.forRegistry(registry).outputTo(LOG).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build();
    }

    @Override
    public void start() {
        if (this.reporter != null) {
            this.reporter.start(30L, TimeUnit.SECONDS);
        } else {
            LOG.error("Cannot start as the reporter is null.");
        }
    }

    @Override
    public void report() {
        if (this.reporter != null) {
            this.reporter.report();
        } else {
            LOG.error("Cannot report metrics as the reporter is null.");
        }
    }

    @Override
    public void stop() {
        if (this.reporter != null) {
            this.reporter.stop();
        } else {
            LOG.error("Cannot stop as the reporter is null.");
        }
    }
}

