/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import io.hops.hudi.com.codahale.metrics.Counter;
import io.hops.hudi.com.codahale.metrics.Timer;
import java.util.Set;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.storage.HoodieStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMetrics.class);
    public static final String TOTAL_PARTITIONS_WRITTEN_STR = "totalPartitionsWritten";
    public static final String TOTAL_FILES_INSERT_STR = "totalFilesInsert";
    public static final String TOTAL_FILES_UPDATE_STR = "totalFilesUpdate";
    public static final String TOTAL_RECORDS_WRITTEN_STR = "totalRecordsWritten";
    public static final String TOTAL_UPDATE_RECORDS_WRITTEN_STR = "totalUpdateRecordsWritten";
    public static final String TOTAL_INSERT_RECORDS_WRITTEN_STR = "totalInsertRecordsWritten";
    public static final String TOTAL_BYTES_WRITTEN_STR = "totalBytesWritten";
    public static final String TOTAL_SCAN_TIME_STR = "totalScanTime";
    public static final String TOTAL_CREATE_TIME_STR = "totalCreateTime";
    public static final String TOTAL_UPSERT_TIME_STR = "totalUpsertTime";
    public static final String TOTAL_COMPACTED_RECORDS_UPDATED_STR = "totalCompactedRecordsUpdated";
    public static final String TOTAL_LOG_FILES_COMPACTED_STR = "totalLogFilesCompacted";
    public static final String TOTAL_LOG_FILES_SIZE_STR = "totalLogFilesSize";
    public static final String TOTAL_RECORDS_DELETED = "totalRecordsDeleted";
    public static final String TOTAL_CORRUPTED_LOG_BLOCKS_STR = "totalCorruptedLogBlocks";
    public static final String TOTAL_ROLLBACK_LOG_BLOCKS_STR = "totalRollbackLogBlocks";
    public static final String DURATION_STR = "duration";
    public static final String DELETE_FILES_NUM_STR = "numFilesDeleted";
    public static final String DELETE_INSTANTS_NUM_STR = "numInstantsArchived";
    public static final String FINALIZED_FILES_NUM_STR = "numFilesFinalized";
    public static final String CONFLICT_RESOLUTION_STR = "conflict_resolution";
    public static final String COMMIT_LATENCY_IN_MS_STR = "commitLatencyInMs";
    public static final String COMMIT_FRESHNESS_IN_MS_STR = "commitFreshnessInMs";
    public static final String COMMIT_TIME_STR = "commitTime";
    public static final String EARLIEST_PENDING_CLUSTERING_INSTANT_STR = "earliestInflightClusteringInstant";
    public static final String EARLIEST_PENDING_COMPACTION_INSTANT_STR = "earliestInflightCompactionInstant";
    public static final String EARLIEST_PENDING_CLEAN_INSTANT_STR = "earliestInflightCleanInstant";
    public static final String EARLIEST_PENDING_ROLLBACK_INSTANT_STR = "earliestInflightRollbackInstant";
    public static final String LATEST_COMPLETED_CLUSTERING_INSTANT_STR = "latestCompletedClusteringInstant";
    public static final String LATEST_COMPLETED_COMPACTION_INSTANT_STR = "latestCompletedCompactionInstant";
    public static final String LATEST_COMPLETED_CLEAN_INSTANT_STR = "latestCompletedCleanInstant";
    public static final String LATEST_COMPLETED_ROLLBACK_INSTANT_STR = "latestCompletedRollbackInstant";
    public static final String PENDING_CLUSTERING_INSTANT_COUNT_STR = "pendingClusteringInstantCount";
    public static final String PENDING_COMPACTION_INSTANT_COUNT_STR = "pendingCompactionInstantCount";
    public static final String PENDING_CLEAN_INSTANT_COUNT_STR = "pendingCleanInstantCount";
    public static final String PENDING_ROLLBACK_INSTANT_COUNT_STR = "pendingRollbackInstantCount";
    public static final String SUCCESS_EXTENSION = ".success";
    public static final String FAILURE_EXTENSION = ".failure";
    public static final String TIMER_METRIC = "timer";
    public static final String COUNTER_METRIC = "counter";
    public static final String ARCHIVE_ACTION = "archive";
    public static final String FINALIZE_ACTION = "finalize";
    public static final String INDEX_ACTION = "index";
    public static final String SOURCE_READ_AND_INDEX_ACTION = "source_read_and_index";
    public static final String COUNTER_METRIC_EXTENSION = ".counter";
    public static final String SUCCESS_COUNTER = "success.counter";
    public static final String FAILURE_COUNTER = "failure.counter";
    private Metrics metrics;
    public String rollbackTimerName = null;
    public String cleanTimerName = null;
    public String archiveTimerName = null;
    public String commitTimerName = null;
    public String logCompactionTimerName = null;
    public String deltaCommitTimerName = null;
    public String clusterCommitTimerName = null;
    public String finalizeTimerName = null;
    public String compactionTimerName = null;
    public String indexTimerName = null;
    public String sourceReadAndIndexTimerName = null;
    private String conflictResolutionTimerName = null;
    private String conflictResolutionSuccessCounterName = null;
    private String conflictResolutionFailureCounterName = null;
    private String compactionRequestedCounterName = null;
    private String compactionCompletedCounterName = null;
    private final HoodieWriteConfig config;
    private final String tableName;
    private Timer rollbackTimer = null;
    private Timer cleanTimer = null;
    private Timer archiveTimer = null;
    private Timer commitTimer = null;
    private Timer deltaCommitTimer = null;
    private Timer finalizeTimer = null;
    private Timer compactionTimer = null;
    private Timer logCompactionTimer = null;
    private Timer clusteringTimer = null;
    private Timer indexTimer = null;
    private Timer sourceReadAndIndexTimer = null;
    private Timer conflictResolutionTimer = null;
    private Counter conflictResolutionSuccessCounter = null;
    private Counter conflictResolutionFailureCounter = null;
    private Counter compactionRequestedCounter = null;
    private Counter compactionCompletedCounter = null;

    public HoodieMetrics(HoodieWriteConfig config, HoodieStorage storage) {
        this.config = config;
        this.tableName = config.getTableName();
        if (config.isMetricsOn()) {
            this.metrics = Metrics.getInstance(config.getMetricsConfig(), storage);
            this.rollbackTimerName = this.getMetricsName("rollback", TIMER_METRIC);
            this.cleanTimerName = this.getMetricsName("clean", TIMER_METRIC);
            this.archiveTimerName = this.getMetricsName(ARCHIVE_ACTION, TIMER_METRIC);
            this.commitTimerName = this.getMetricsName("commit", TIMER_METRIC);
            this.deltaCommitTimerName = this.getMetricsName("deltacommit", TIMER_METRIC);
            this.clusterCommitTimerName = this.getMetricsName("clustering", TIMER_METRIC);
            this.finalizeTimerName = this.getMetricsName(FINALIZE_ACTION, TIMER_METRIC);
            this.compactionTimerName = this.getMetricsName("compaction", TIMER_METRIC);
            this.logCompactionTimerName = this.getMetricsName("logcompaction", TIMER_METRIC);
            this.indexTimerName = this.getMetricsName(INDEX_ACTION, TIMER_METRIC);
            this.sourceReadAndIndexTimerName = this.getMetricsName(SOURCE_READ_AND_INDEX_ACTION, TIMER_METRIC);
            this.conflictResolutionTimerName = this.getMetricsName(CONFLICT_RESOLUTION_STR, TIMER_METRIC);
            this.conflictResolutionSuccessCounterName = this.getMetricsName(CONFLICT_RESOLUTION_STR, SUCCESS_COUNTER);
            this.conflictResolutionFailureCounterName = this.getMetricsName(CONFLICT_RESOLUTION_STR, FAILURE_COUNTER);
            this.compactionRequestedCounterName = this.getMetricsName("compaction", HoodieTimeline.REQUESTED_COMPACTION_SUFFIX + COUNTER_METRIC_EXTENSION);
            this.compactionCompletedCounterName = this.getMetricsName("compaction", HoodieTimeline.COMPLETED_COMPACTION_SUFFIX + COUNTER_METRIC_EXTENSION);
        }
    }

    private Timer createTimer(String name) {
        return this.config.isMetricsOn() ? this.metrics.getRegistry().timer(name) : null;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public Timer.Context getRollbackCtx() {
        if (this.config.isMetricsOn() && this.rollbackTimer == null) {
            this.rollbackTimer = this.createTimer(this.rollbackTimerName);
        }
        return this.rollbackTimer == null ? null : this.rollbackTimer.time();
    }

    public Timer.Context getCompactionCtx() {
        if (this.config.isMetricsOn() && this.compactionTimer == null) {
            this.compactionTimer = this.createTimer(this.commitTimerName);
        }
        return this.compactionTimer == null ? null : this.compactionTimer.time();
    }

    public Timer.Context getLogCompactionCtx() {
        if (this.config.isMetricsOn() && this.logCompactionTimer == null) {
            this.logCompactionTimer = this.createTimer(this.commitTimerName);
        }
        return this.logCompactionTimer == null ? null : this.logCompactionTimer.time();
    }

    public Timer.Context getClusteringCtx() {
        if (this.config.isMetricsOn() && this.clusteringTimer == null) {
            this.clusteringTimer = this.createTimer(this.clusterCommitTimerName);
        }
        return this.clusteringTimer == null ? null : this.clusteringTimer.time();
    }

    public Timer.Context getCleanCtx() {
        if (this.config.isMetricsOn() && this.cleanTimer == null) {
            this.cleanTimer = this.createTimer(this.cleanTimerName);
        }
        return this.cleanTimer == null ? null : this.cleanTimer.time();
    }

    public Timer.Context getArchiveCtx() {
        if (this.config.isMetricsOn() && this.archiveTimer == null) {
            this.archiveTimer = this.createTimer(this.archiveTimerName);
        }
        return this.archiveTimer == null ? null : this.archiveTimer.time();
    }

    public Timer.Context getCommitCtx() {
        if (this.config.isMetricsOn() && this.commitTimer == null) {
            this.commitTimer = this.createTimer(this.commitTimerName);
        }
        return this.commitTimer == null ? null : this.commitTimer.time();
    }

    public Timer.Context getFinalizeCtx() {
        if (this.config.isMetricsOn() && this.finalizeTimer == null) {
            this.finalizeTimer = this.createTimer(this.finalizeTimerName);
        }
        return this.finalizeTimer == null ? null : this.finalizeTimer.time();
    }

    public Timer.Context getDeltaCommitCtx() {
        if (this.config.isMetricsOn() && this.deltaCommitTimer == null) {
            this.deltaCommitTimer = this.createTimer(this.deltaCommitTimerName);
        }
        return this.deltaCommitTimer == null ? null : this.deltaCommitTimer.time();
    }

    public Timer.Context getIndexCtx() {
        if (this.config.isMetricsOn() && this.indexTimer == null) {
            this.indexTimer = this.createTimer(this.indexTimerName);
        }
        return this.indexTimer == null ? null : this.indexTimer.time();
    }

    public Timer.Context getSourceReadAndIndexTimerCtx() {
        if (this.config.isMetricsOn() && this.sourceReadAndIndexTimer == null) {
            this.sourceReadAndIndexTimer = this.createTimer(this.sourceReadAndIndexTimerName);
        }
        return this.sourceReadAndIndexTimer == null ? null : this.sourceReadAndIndexTimer.time();
    }

    public Timer.Context getConflictResolutionCtx() {
        if (this.config.isLockingMetricsEnabled() && this.conflictResolutionTimer == null) {
            this.conflictResolutionTimer = this.createTimer(this.conflictResolutionTimerName);
        }
        return this.conflictResolutionTimer == null ? null : this.conflictResolutionTimer.time();
    }

    public void updateMetricsForEmptyData(String actionType) {
        if (!this.config.isMetricsOn() || !this.config.getMetricsReporterType().equals((Object)MetricsReporterType.PROMETHEUS_PUSHGATEWAY)) {
            return;
        }
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_PARTITIONS_WRITTEN_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_FILES_INSERT_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_FILES_UPDATE_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_RECORDS_WRITTEN_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_UPDATE_RECORDS_WRITTEN_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_INSERT_RECORDS_WRITTEN_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_RECORDS_DELETED), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_BYTES_WRITTEN_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_SCAN_TIME_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_CREATE_TIME_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_UPSERT_TIME_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_COMPACTED_RECORDS_UPDATED_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_LOG_FILES_COMPACTED_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_LOG_FILES_SIZE_STR), 0L);
    }

    public void updateCommitMetrics(long commitEpochTimeInMs, long durationInMs, HoodieCommitMetadata metadata, String actionType) {
        this.updateCommitTimingMetrics(commitEpochTimeInMs, durationInMs, metadata, actionType);
        if (this.config.isMetricsOn()) {
            long totalPartitionsWritten = metadata.fetchTotalPartitionsWritten();
            long totalFilesInsert = metadata.fetchTotalFilesInsert();
            long totalFilesUpdate = metadata.fetchTotalFilesUpdated();
            long totalRecordsWritten = metadata.fetchTotalRecordsWritten();
            long totalUpdateRecordsWritten = metadata.fetchTotalUpdateRecordsWritten();
            long totalInsertRecordsWritten = metadata.fetchTotalInsertRecordsWritten();
            long totalRecordsDeleted = metadata.getTotalRecordsDeleted();
            long totalBytesWritten = metadata.fetchTotalBytesWritten();
            long totalTimeTakenByScanner = metadata.getTotalScanTime();
            long totalTimeTakenForInsert = metadata.getTotalCreateTime();
            long totalTimeTakenForUpsert = metadata.getTotalUpsertTime();
            long totalCompactedRecordsUpdated = metadata.getTotalCompactedRecordsUpdated();
            long totalLogFilesCompacted = metadata.getTotalLogFilesCompacted();
            long totalLogFilesSize = metadata.getTotalLogFilesSize();
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_PARTITIONS_WRITTEN_STR), totalPartitionsWritten);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_FILES_INSERT_STR), totalFilesInsert);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_FILES_UPDATE_STR), totalFilesUpdate);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_RECORDS_WRITTEN_STR), totalRecordsWritten);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_UPDATE_RECORDS_WRITTEN_STR), totalUpdateRecordsWritten);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_INSERT_RECORDS_WRITTEN_STR), totalInsertRecordsWritten);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_BYTES_WRITTEN_STR), totalBytesWritten);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_SCAN_TIME_STR), totalTimeTakenByScanner);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_CREATE_TIME_STR), totalTimeTakenForInsert);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_UPSERT_TIME_STR), totalTimeTakenForUpsert);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_COMPACTED_RECORDS_UPDATED_STR), totalCompactedRecordsUpdated);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_LOG_FILES_COMPACTED_STR), totalLogFilesCompacted);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_LOG_FILES_SIZE_STR), totalLogFilesSize);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_RECORDS_DELETED), totalRecordsDeleted);
            if (this.config.isCompactionLogBlockMetricsOn()) {
                long totalCorruptedLogBlocks = metadata.getTotalCorruptLogBlocks();
                long totalRollbackLogBlocks = metadata.getTotalRollbackLogBlocks();
                this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_CORRUPTED_LOG_BLOCKS_STR), totalCorruptedLogBlocks);
                this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_ROLLBACK_LOG_BLOCKS_STR), totalRollbackLogBlocks);
            }
        }
    }

    private void updateCommitTimingMetrics(long commitEpochTimeInMs, long durationInMs, HoodieCommitMetadata metadata, String actionType) {
        if (this.config.isMetricsOn()) {
            Pair<Option<Long>, Option<Long>> eventTimePairMinMax = metadata.getMinAndMaxEventTime();
            if (eventTimePairMinMax.getLeft().isPresent()) {
                long commitLatencyInMs = commitEpochTimeInMs + durationInMs - eventTimePairMinMax.getLeft().get();
                this.metrics.registerGauge(this.getMetricsName(actionType, COMMIT_LATENCY_IN_MS_STR), commitLatencyInMs);
            }
            if (eventTimePairMinMax.getRight().isPresent()) {
                long commitFreshnessInMs = commitEpochTimeInMs + durationInMs - eventTimePairMinMax.getRight().get();
                this.metrics.registerGauge(this.getMetricsName(actionType, COMMIT_FRESHNESS_IN_MS_STR), commitFreshnessInMs);
            }
            this.metrics.registerGauge(this.getMetricsName(actionType, COMMIT_TIME_STR), commitEpochTimeInMs);
            this.metrics.registerGauge(this.getMetricsName(actionType, DURATION_STR), durationInMs);
        }
    }

    public void updateRollbackMetrics(long durationInMs, long numFilesDeleted) {
        if (this.config.isMetricsOn()) {
            LOG.info(String.format("Sending rollback metrics (%s=%d, %s=%d)", DURATION_STR, durationInMs, DELETE_FILES_NUM_STR, numFilesDeleted));
            this.metrics.registerGauge(this.getMetricsName("rollback", DURATION_STR), durationInMs);
            this.metrics.registerGauge(this.getMetricsName("rollback", DELETE_FILES_NUM_STR), numFilesDeleted);
        }
    }

    public void updateCleanMetrics(long durationInMs, int numFilesDeleted) {
        if (this.config.isMetricsOn()) {
            LOG.info(String.format("Sending clean metrics (%s=%d, %s=%d)", DURATION_STR, durationInMs, DELETE_FILES_NUM_STR, numFilesDeleted));
            this.metrics.registerGauge(this.getMetricsName("clean", DURATION_STR), durationInMs);
            this.metrics.registerGauge(this.getMetricsName("clean", DELETE_FILES_NUM_STR), numFilesDeleted);
        }
    }

    public void updateArchiveMetrics(long durationInMs, int numInstantsArchived) {
        if (this.config.isMetricsOn()) {
            LOG.info(String.format("Sending archive metrics (%s=%d, %s=%d)", DURATION_STR, durationInMs, DELETE_INSTANTS_NUM_STR, numInstantsArchived));
            this.metrics.registerGauge(this.getMetricsName(ARCHIVE_ACTION, DURATION_STR), durationInMs);
            this.metrics.registerGauge(this.getMetricsName(ARCHIVE_ACTION, DELETE_INSTANTS_NUM_STR), numInstantsArchived);
        }
    }

    public void updateFinalizeWriteMetrics(long durationInMs, long numFilesFinalized) {
        if (this.config.isMetricsOn()) {
            LOG.info(String.format("Sending finalize write metrics (%s=%d, %s=%d)", DURATION_STR, durationInMs, FINALIZED_FILES_NUM_STR, numFilesFinalized));
            this.metrics.registerGauge(this.getMetricsName(FINALIZE_ACTION, DURATION_STR), durationInMs);
            this.metrics.registerGauge(this.getMetricsName(FINALIZE_ACTION, FINALIZED_FILES_NUM_STR), numFilesFinalized);
        }
    }

    public void updateIndexMetrics(String action, long durationInMs) {
        if (this.config.isMetricsOn()) {
            LOG.info(String.format("Sending index metrics (%s.%s, %d)", action, DURATION_STR, durationInMs));
            this.metrics.registerGauge(this.getMetricsName(INDEX_ACTION, String.format("%s.%s", action, DURATION_STR)), durationInMs);
        }
    }

    public void updateSourceReadAndIndexMetrics(String action, long durationInMs) {
        if (this.config.isMetricsOn()) {
            LOG.info(String.format("Sending %s metrics (%s.duration, %d)", SOURCE_READ_AND_INDEX_ACTION, action, durationInMs));
            this.metrics.registerGauge(this.getMetricsName(SOURCE_READ_AND_INDEX_ACTION, String.format("%s.duration", action)), durationInMs);
        }
    }

    @VisibleForTesting
    public String getMetricsName(String action, String metric) {
        if (this.config == null) {
            return null;
        }
        if (StringUtils.isNullOrEmpty(this.config.getMetricReporterMetricsNamePrefix())) {
            return String.format("%s.%s", action, metric);
        }
        return String.format("%s.%s.%s", this.config.getMetricReporterMetricsNamePrefix(), action, metric);
    }

    public void updateClusteringFileCreationMetrics(long durationInMs) {
        this.reportMetrics("clustering", "fileCreationTime", durationInMs);
    }

    public void updateTableServiceInstantMetrics(HoodieActiveTimeline activeTimeline) {
        this.updateEarliestPendingInstant(activeTimeline, EARLIEST_PENDING_CLUSTERING_INSTANT_STR, "clustering");
        this.updateEarliestPendingInstant(activeTimeline, EARLIEST_PENDING_COMPACTION_INSTANT_STR, "compaction");
        this.updateEarliestPendingInstant(activeTimeline, EARLIEST_PENDING_CLEAN_INSTANT_STR, "clean");
        this.updateEarliestPendingInstant(activeTimeline, EARLIEST_PENDING_ROLLBACK_INSTANT_STR, "rollback");
        this.updateLatestCompletedInstant(activeTimeline, LATEST_COMPLETED_CLUSTERING_INSTANT_STR, "replacecommit");
        this.updateLatestCompletedInstant(activeTimeline, LATEST_COMPLETED_COMPACTION_INSTANT_STR, "commit");
        this.updateLatestCompletedInstant(activeTimeline, LATEST_COMPLETED_CLEAN_INSTANT_STR, "clean");
        this.updateLatestCompletedInstant(activeTimeline, LATEST_COMPLETED_ROLLBACK_INSTANT_STR, "rollback");
        this.updatePendingInstantCount(activeTimeline, PENDING_CLUSTERING_INSTANT_COUNT_STR, "clustering");
        this.updatePendingInstantCount(activeTimeline, PENDING_COMPACTION_INSTANT_COUNT_STR, "compaction");
        this.updatePendingInstantCount(activeTimeline, PENDING_CLEAN_INSTANT_COUNT_STR, "clean");
        this.updatePendingInstantCount(activeTimeline, PENDING_ROLLBACK_INSTANT_COUNT_STR, "rollback");
    }

    private void updateEarliestPendingInstant(HoodieActiveTimeline activeTimeline, String metricName, String action) {
        Set<String> validActions = CollectionUtils.createSet(action);
        HoodieTimeline filteredInstants = activeTimeline.filterInflightsAndRequested().filter(instant -> validActions.contains(instant.getAction()));
        Option<HoodieInstant> hoodieInstantOption = filteredInstants.firstInstant();
        if (hoodieInstantOption.isPresent()) {
            this.updateMetric(action, metricName, Long.parseLong(hoodieInstantOption.get().requestedTime()));
        }
    }

    private void updateLatestCompletedInstant(HoodieActiveTimeline activeTimeline, String metricName, String action) {
        switch (metricName) {
            case "latestCompletedCompactionInstant": {
                action = "commit";
                break;
            }
            case "latestCompletedClusteringInstant": {
                action = "replacecommit";
                break;
            }
        }
        Set<String> validActions = CollectionUtils.createSet(action);
        HoodieTimeline filteredInstants = activeTimeline.filterCompletedInstants().filter(instant -> validActions.contains(instant.getAction()));
        Option<HoodieInstant> hoodieInstantOption = filteredInstants.lastInstant();
        if (hoodieInstantOption.isPresent()) {
            String requestedTime = hoodieInstantOption.get().requestedTime();
            if (requestedTime.length() > HoodieInstantTimeGenerator.MILLIS_INSTANT_TIMESTAMP_FORMAT_LENGTH) {
                requestedTime = requestedTime.substring(0, HoodieInstantTimeGenerator.MILLIS_INSTANT_TIMESTAMP_FORMAT_LENGTH);
            }
            this.updateMetric(action, metricName, Long.parseLong(requestedTime));
        }
    }

    private void updatePendingInstantCount(HoodieActiveTimeline activeTimeline, String metricName, String action) {
        Set<String> validActions = CollectionUtils.createSet(action);
        HoodieTimeline filteredInstants = activeTimeline.filterInflightsAndRequested().filter(instant -> validActions.contains(instant.getAction()));
        this.updateMetric(action, metricName, filteredInstants.countInstants());
    }

    private void updateMetric(String action, String metricName, long metricValue) {
        if (this.config.isMetricsOn()) {
            LOG.info(String.format("Updating timeline instant related metrics (%s=%d)", metricName, metricValue));
            this.metrics.registerGauge(this.getMetricsName(action, metricName), metricValue);
        }
    }

    public void reportMetrics(String commitAction, String metricName, long value) {
        this.metrics.registerGauge(this.getMetricsName(commitAction, metricName), value);
    }

    public long getDurationInMs(long ctxDuration) {
        return ctxDuration / 1000000L;
    }

    public void emitConflictResolutionSuccessful() {
        if (this.config.isLockingMetricsEnabled()) {
            LOG.info("Sending conflict resolution success metric");
            this.conflictResolutionSuccessCounter = this.getCounter(this.conflictResolutionSuccessCounter, this.conflictResolutionSuccessCounterName);
            this.conflictResolutionSuccessCounter.inc();
        }
    }

    public void emitConflictResolutionFailed() {
        if (this.config.isLockingMetricsEnabled()) {
            LOG.info("Sending conflict resolution failure metric");
            this.conflictResolutionFailureCounter = this.getCounter(this.conflictResolutionFailureCounter, this.conflictResolutionFailureCounterName);
            this.conflictResolutionFailureCounter.inc();
        }
    }

    public void emitCompactionRequested() {
        if (this.config.isMetricsOn()) {
            this.compactionRequestedCounter = this.getCounter(this.compactionRequestedCounter, this.compactionRequestedCounterName);
            this.compactionRequestedCounter.inc();
        }
    }

    public void emitCompactionCompleted() {
        if (this.config.isMetricsOn()) {
            this.compactionCompletedCounter = this.getCounter(this.compactionCompletedCounter, this.compactionCompletedCounterName);
            this.compactionCompletedCounter.inc();
        }
    }

    public void emitMetadataEnablementMetrics(boolean isMetadataEnabled, boolean isMetadataColStatsEnabled, boolean isMetadataBloomFilterEnabled, boolean isMetadataRliEnabled) {
        if (this.config.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("metadata", "isEnabled"), isMetadataEnabled ? 1L : 0L);
            this.metrics.registerGauge(this.getMetricsName("metadata", "isColSatsEnabled"), isMetadataColStatsEnabled ? 1L : 0L);
            this.metrics.registerGauge(this.getMetricsName("metadata", "isBloomFilterEnabled"), isMetadataBloomFilterEnabled ? 1L : 0L);
            this.metrics.registerGauge(this.getMetricsName("metadata", "isRliEnabled"), isMetadataRliEnabled ? 1L : 0L);
        }
    }

    public void emitIndexTypeMetrics(int indexTypeOrdinal) {
        if (this.config.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName(INDEX_ACTION, "type"), indexTypeOrdinal);
        }
    }

    private Counter getCounter(Counter counter, String name) {
        if (counter == null) {
            return this.metrics.getRegistry().counter(name);
        }
        return counter;
    }
}

