/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.factory;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.AutoRecordGenWrapperAvroKeyGenerator;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.GlobalAvroDeleteKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieAvroKeyGeneratorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieAvroKeyGeneratorFactory.class);

    public static KeyGenerator createKeyGenerator(TypedProperties props) throws IOException {
        KeyGenerator keyGenerator = KeyGenUtils.createKeyGeneratorByClassName(props);
        return Objects.isNull(keyGenerator) ? HoodieAvroKeyGeneratorFactory.createAvroKeyGeneratorByType(props) : keyGenerator;
    }

    public static KeyGenerator createAvroKeyGeneratorByType(TypedProperties props) throws IOException {
        KeyGeneratorType keyGeneratorTypeEnum;
        String keyGeneratorType = props.getString(HoodieWriteConfig.KEYGENERATOR_TYPE.key(), null);
        if (StringUtils.isNullOrEmpty(keyGeneratorType)) {
            LOG.info("The value of {} is empty, using SIMPLE", (Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key());
            keyGeneratorType = KeyGeneratorType.SIMPLE.name();
        }
        try {
            keyGeneratorTypeEnum = KeyGeneratorType.valueOf(keyGeneratorType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new HoodieKeyGeneratorException("Unsupported keyGenerator Type " + keyGeneratorType);
        }
        BaseKeyGenerator keyGenerator = null;
        switch (keyGeneratorTypeEnum) {
            case SIMPLE: {
                keyGenerator = new SimpleAvroKeyGenerator(props);
                break;
            }
            case COMPLEX: {
                keyGenerator = new ComplexAvroKeyGenerator(props);
                break;
            }
            case TIMESTAMP: {
                keyGenerator = new TimestampBasedAvroKeyGenerator(props);
                break;
            }
            case CUSTOM: {
                keyGenerator = new CustomAvroKeyGenerator(props);
                break;
            }
            case NON_PARTITION: {
                keyGenerator = new NonpartitionedAvroKeyGenerator(props);
                break;
            }
            case GLOBAL_DELETE: {
                keyGenerator = new GlobalAvroDeleteKeyGenerator(props);
                break;
            }
            default: {
                throw new HoodieKeyGeneratorException("Unsupported keyGenerator Type " + keyGeneratorType);
            }
        }
        if (KeyGenUtils.isAutoGeneratedRecordKeysEnabled(props)) {
            return new AutoRecordGenWrapperAvroKeyGenerator(props, keyGenerator);
        }
        return keyGenerator;
    }
}

