/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.function.Supplier;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.keygen.PartitionPathFormatterBase;

public class StringPartitionPathFormatter
extends PartitionPathFormatterBase<String> {
    public StringPartitionPathFormatter(Supplier<PartitionPathFormatterBase.StringBuilder<String>> stringBuilderFactory, boolean useHiveStylePartitioning, boolean useEncoding) {
        super(stringBuilderFactory, useHiveStylePartitioning, useEncoding);
    }

    @Override
    protected String toString(Object o) {
        return o == null ? null : o.toString();
    }

    @Override
    protected String encode(String partitionPathPart) {
        return PartitionPathEncodeUtils.escapePathName(partitionPathPart);
    }

    @Override
    protected String handleEmpty(String partitionPathPart) {
        if (partitionPathPart == null) {
            return "__HIVE_DEFAULT_PARTITION__";
        }
        String keyPartStr = partitionPathPart;
        return keyPartStr.isEmpty() ? "__HIVE_DEFAULT_PARTITION__" : keyPartStr;
    }

    public static class JavaStringBuilder
    implements PartitionPathFormatterBase.StringBuilder<String> {
        private final StringBuilder sb = new StringBuilder();

        @Override
        public PartitionPathFormatterBase.StringBuilder<String> appendJava(String s) {
            this.sb.append(s);
            return this;
        }

        @Override
        public String build() {
            return this.sb.toString();
        }
    }
}

