/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import io.hops.hudi.com.beust.jcommander.JCommander;
import io.hops.hudi.com.codahale.metrics.Timer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieSyncTableStrategy;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.InvalidTableException;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HoodieHiveSyncClient;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.SchemaDifference;
import org.apache.hudi.hive.util.HiveSchemaUtil;
import org.apache.hudi.sync.common.HoodieSyncClient;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncTool;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.hudi.sync.common.model.PartitionEvent;
import org.apache.hudi.sync.common.util.SparkDataSourceTableUtils;
import org.apache.hudi.sync.common.util.TableUtils;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSyncTool
extends HoodieSyncTool
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSyncTool.class);
    public static final String SUFFIX_SNAPSHOT_TABLE = "_rt";
    public static final String SUFFIX_READ_OPTIMIZED_TABLE = "_ro";
    protected HiveSyncConfig config;
    private final String databaseName;
    private final String tableName;
    protected HoodieSyncClient syncClient;
    protected String snapshotTableName;
    protected Option<String> roTableName;
    private String hiveSyncTableStrategy;

    public HiveSyncTool(Properties props, Configuration hadoopConf) {
        this(props, hadoopConf, Option.empty());
    }

    public HiveSyncTool(Properties props, Configuration hadoopConf, Option<HoodieTableMetaClient> metaClientOption) {
        super(props, hadoopConf);
        Configuration hadoopConfForSync;
        String configuredMetastoreUris = props.getProperty(HiveSyncConfigHolder.METASTORE_URIS.key());
        if (StringUtils.nonEmpty(configuredMetastoreUris)) {
            hadoopConfForSync = new Configuration(hadoopConf);
            hadoopConfForSync.set(HiveConf.ConfVars.METASTOREURIS.varname, configuredMetastoreUris);
        } else {
            hadoopConfForSync = hadoopConf;
        }
        this.config = new HiveSyncConfig(props, hadoopConfForSync);
        this.databaseName = this.config.getStringOrDefault(HoodieSyncConfig.META_SYNC_DATABASE_NAME);
        this.tableName = this.config.getStringOrDefault(HoodieSyncConfig.META_SYNC_TABLE_NAME);
        HoodieTableMetaClient metaClient = metaClientOption.orElseGet(() -> HiveSyncTool.buildMetaClient(this.config));
        this.initSyncClient(this.config, metaClient);
        this.initTableNameVars(this.config);
    }

    protected void initSyncClient(HiveSyncConfig config, HoodieTableMetaClient metaClient) {
        try {
            this.syncClient = new HoodieHiveSyncClient(config, metaClient);
        }
        catch (RuntimeException e) {
            if (config.getBoolean(HiveSyncConfigHolder.HIVE_IGNORE_EXCEPTIONS).booleanValue()) {
                LOG.error("Got runtime exception when hive syncing, but continuing as ignoreExceptions config is set ", (Throwable)e);
            }
            throw new HoodieHiveSyncException("Got runtime exception when hive syncing", e);
        }
    }

    private void initTableNameVars(HiveSyncConfig config) {
        String tableName = config.getStringOrDefault(HoodieSyncConfig.META_SYNC_TABLE_NAME);
        if (this.syncClient != null) {
            switch (this.syncClient.getTableType()) {
                case COPY_ON_WRITE: {
                    this.snapshotTableName = tableName;
                    this.roTableName = Option.empty();
                    break;
                }
                case MERGE_ON_READ: {
                    this.hiveSyncTableStrategy = config.getStringOrDefault(HiveSyncConfigHolder.HIVE_SYNC_TABLE_STRATEGY).toUpperCase();
                    this.snapshotTableName = tableName + SUFFIX_SNAPSHOT_TABLE;
                    this.roTableName = config.getBoolean(HiveSyncConfigHolder.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE) != false ? Option.of(tableName) : Option.of(tableName + SUFFIX_READ_OPTIMIZED_TABLE);
                    break;
                }
                default: {
                    LOG.error("Unknown table type " + (Object)((Object)this.syncClient.getTableType()));
                    throw new InvalidTableException(this.syncClient.getBasePath());
                }
            }
        }
    }

    @Override
    public void syncHoodieTable() {
        try {
            if (this.syncClient != null) {
                LOG.info("Syncing target hoodie table with hive table(" + TableUtils.tableId(this.databaseName, this.tableName) + "). Hive metastore URL from HiveConf:" + this.config.getHiveConf().get(HiveConf.ConfVars.METASTOREURIS.varname) + "). Hive metastore URL from HiveSyncConfig:" + this.config.getString(HiveSyncConfigHolder.METASTORE_URIS) + ", basePath :" + this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH));
                this.doSync();
            }
        }
        catch (RuntimeException re) {
            throw new HoodieException("Got runtime exception when hive syncing " + this.tableName, re);
        }
        finally {
            this.close();
        }
    }

    protected void doSync() {
        block0 : switch (this.syncClient.getTableType()) {
            case COPY_ON_WRITE: {
                this.syncHoodieTable(this.snapshotTableName, false, false);
                break;
            }
            case MERGE_ON_READ: {
                switch (HoodieSyncTableStrategy.valueOf(this.hiveSyncTableStrategy)) {
                    case RO: {
                        this.syncHoodieTable(this.tableName, false, true);
                        break block0;
                    }
                    case RT: {
                        this.syncHoodieTable(this.tableName, true, false);
                        break block0;
                    }
                }
                this.syncHoodieTable(this.roTableName.get(), false, true);
                this.syncHoodieTable(this.snapshotTableName, true, false);
                if (!this.config.getBoolean(HoodieSyncConfig.META_SYNC_SNAPSHOT_WITH_TABLE_NAME).booleanValue()) break;
                this.syncHoodieTable(this.tableName, true, false);
                break;
            }
            default: {
                LOG.error("Unknown table type " + (Object)((Object)this.syncClient.getTableType()));
                throw new InvalidTableException(this.syncClient.getBasePath());
            }
        }
    }

    @Override
    public void close() {
        if (this.syncClient != null) {
            try {
                this.syncClient.close();
            }
            catch (Exception e) {
                throw new HoodieHiveSyncException("Fail to close sync client.", e);
            }
        }
        if (this.config != null) {
            this.config = null;
        }
    }

    protected void syncHoodieTable(String tableName, boolean useRealtimeInputFormat, boolean readAsOptimized) {
        LOG.info("Trying to sync hoodie table " + tableName + " with base path " + this.syncClient.getBasePath() + " of type " + (Object)((Object)this.syncClient.getTableType()));
        this.checkAndCreateDatabase();
        boolean tableExists = this.syncClient.tableExists(tableName);
        MessageType schema = this.syncClient.getStorageSchema(this.config.getBoolean(HiveSyncConfigHolder.HIVE_SYNC_OMIT_METADATA_FIELDS) == false);
        if (tableExists && !FSUtils.comparePathsWithoutScheme(this.syncClient.getBasePath(), this.syncClient.getTableLocation(tableName))) {
            LOG.info("basepath is updated for the table {}", (Object)tableName);
            this.recreateAndSyncHiveTable(tableName, useRealtimeInputFormat, readAsOptimized);
            return;
        }
        try {
            boolean meetSyncConditions;
            boolean propertiesChanged;
            boolean schemaChanged;
            if (tableExists) {
                schemaChanged = this.syncSchema(tableName, schema);
                propertiesChanged = this.syncProperties(tableName, useRealtimeInputFormat, readAsOptimized, schema);
            } else {
                this.syncFirstTime(tableName, useRealtimeInputFormat, readAsOptimized, schema);
                schemaChanged = true;
                propertiesChanged = true;
            }
            boolean partitionsChanged = this.validateAndSyncPartitions(tableName, tableExists);
            boolean bl = meetSyncConditions = schemaChanged || propertiesChanged || partitionsChanged;
            if (!this.config.getBoolean(HoodieSyncConfig.META_SYNC_CONDITIONAL_SYNC).booleanValue() || meetSyncConditions) {
                this.syncClient.updateLastCommitTimeSynced(tableName);
            }
            LOG.info("Sync complete for {}", (Object)tableName);
        }
        catch (HoodieHiveSyncException ex) {
            if (this.shouldRecreateAndSyncTable()) {
                LOG.warn("failed to sync the table {}, trying to recreate", (Object)tableName, (Object)ex);
                this.recreateAndSyncHiveTable(tableName, useRealtimeInputFormat, readAsOptimized);
            }
            throw new HoodieHiveSyncException("failed to sync the table " + tableName, ex);
        }
    }

    private void checkAndCreateDatabase() {
        if (this.config.getBoolean(HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE).booleanValue()) {
            try {
                if (!this.syncClient.databaseExists(this.databaseName)) {
                    this.syncClient.createDatabase(this.databaseName);
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to create database", (Throwable)e);
            }
        } else if (!this.syncClient.databaseExists(this.databaseName)) {
            LOG.error("Hive database does not exist " + this.databaseName);
            throw new HoodieHiveSyncException("hive database does not exist " + this.databaseName);
        }
    }

    private boolean validateAndSyncPartitions(String tableName, boolean tableExists) {
        boolean partitionsChanged;
        Option<String> lastCommitCompletionTimeSynced;
        boolean syncIncremental = this.config.getBoolean(HoodieSyncConfig.META_SYNC_INCREMENTAL);
        Option<String> lastCommitTimeSynced = tableExists && syncIncremental ? this.syncClient.getLastCommitTimeSynced(tableName) : Option.empty();
        Option<String> option = lastCommitCompletionTimeSynced = tableExists && syncIncremental ? this.syncClient.getLastCommitCompletionTimeSynced(tableName) : Option.empty();
        if (syncIncremental) {
            LOG.info(String.format("Last commit time synced was found to be %s, last commit completion time is found to be %s", lastCommitTimeSynced.orElse("null"), lastCommitCompletionTimeSynced.orElse("null")));
        } else {
            LOG.info("Executing a full partition sync operation since {} is set to false.", (Object)HoodieSyncConfig.META_SYNC_INCREMENTAL.key());
        }
        if (!lastCommitTimeSynced.isPresent() || this.syncClient.getActiveTimeline().isBeforeTimelineStarts((String)lastCommitTimeSynced.get())) {
            LOG.info("Sync all partitions given the last commit time synced is empty or before the start of the active timeline. Listing all partitions in " + this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH) + ", file system: " + this.config.getHadoopFileSystem());
            partitionsChanged = this.syncAllPartitions(tableName);
        } else {
            List<String> writtenPartitionsSince = this.syncClient.getWrittenPartitionsSince(lastCommitTimeSynced, lastCommitCompletionTimeSynced);
            LOG.info("Storage partitions scan complete. Found " + writtenPartitionsSince.size());
            Set<String> droppedPartitions = this.syncClient.getDroppedPartitionsSince(lastCommitTimeSynced, lastCommitCompletionTimeSynced);
            partitionsChanged = this.syncPartitions(tableName, writtenPartitionsSince, droppedPartitions);
        }
        return partitionsChanged;
    }

    protected boolean shouldRecreateAndSyncTable() {
        return this.config.getBooleanOrDefault(HiveSyncConfig.RECREATE_HIVE_TABLE_ON_ERROR);
    }

    private void recreateAndSyncHiveTable(String tableName, boolean useRealtimeInputFormat, boolean readAsOptimized) {
        LOG.info("recreating and syncing the table {}", (Object)tableName);
        Timer.Context timerContext = this.metrics.getRecreateAndSyncTimer();
        MessageType schema = this.syncClient.getStorageSchema(this.config.getBoolean(HiveSyncConfigHolder.HIVE_SYNC_OMIT_METADATA_FIELDS) == false);
        try {
            this.createOrReplaceTable(tableName, useRealtimeInputFormat, readAsOptimized, schema);
            this.syncAllPartitions(tableName);
            this.syncClient.updateLastCommitTimeSynced(tableName);
            if (Objects.nonNull(timerContext) && this.config.getMetricsConfig().isMetricsOn()) {
                long durationInNs = timerContext.stop();
                this.metrics.updateRecreateAndSyncDurationInMs(durationInNs);
            }
        }
        catch (HoodieHiveSyncException ex) {
            if (this.config.getMetricsConfig().isMetricsOn()) {
                this.metrics.incrementRecreateAndSyncFailureCounter();
            }
            throw new HoodieHiveSyncException("failed to recreate the table for " + tableName, ex);
        }
    }

    private void createOrReplaceTable(String tableName, boolean useRealtimeInputFormat, boolean readAsOptimized, MessageType schema) {
        HoodieFileFormat baseFileFormat = HoodieFileFormat.valueOf(this.config.getStringOrDefault(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT).toUpperCase());
        String inputFormatClassName = HoodieInputFormatUtils.getInputFormatClassName(baseFileFormat, useRealtimeInputFormat, this.config.getBooleanOrDefault(HiveSyncConfigHolder.HIVE_USE_PRE_APACHE_INPUT_FORMAT));
        String outputFormatClassName = HoodieInputFormatUtils.getOutputFormatClassName(baseFileFormat);
        String serDeFormatClassName = HoodieInputFormatUtils.getSerDeClassName(baseFileFormat);
        Map<String, String> serdeProperties = this.getSerdeProperties(readAsOptimized);
        Map<String, String> tableProperties = this.getTableProperties(schema);
        this.syncClient.createOrReplaceTable(tableName, schema, inputFormatClassName, outputFormatClassName, serDeFormatClassName, serdeProperties, tableProperties);
    }

    private Map<String, String> getTableProperties(MessageType schema) {
        Map<String, String> tableProperties = ConfigUtils.toMap(this.config.getString(HiveSyncConfigHolder.HIVE_TABLE_PROPERTIES));
        if (this.config.getBoolean(HiveSyncConfigHolder.HIVE_SYNC_AS_DATA_SOURCE_TABLE).booleanValue()) {
            Map<String, String> sparkTableProperties = SparkDataSourceTableUtils.getSparkTableProperties(this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS), this.config.getStringOrDefault(HoodieSyncConfig.META_SYNC_SPARK_VERSION), this.config.getIntOrDefault(HiveSyncConfigHolder.HIVE_SYNC_SCHEMA_STRING_LENGTH_THRESHOLD), schema);
            tableProperties.putAll(sparkTableProperties);
        }
        return tableProperties;
    }

    private Map<String, String> getSerdeProperties(boolean readAsOptimized) {
        Map<String, String> serdeProperties = ConfigUtils.toMap(this.config.getString(HiveSyncConfigHolder.HIVE_TABLE_SERDE_PROPERTIES));
        if (this.config.getBoolean(HiveSyncConfigHolder.HIVE_SYNC_AS_DATA_SOURCE_TABLE).booleanValue()) {
            Map<String, String> sparkSerdeProperties = SparkDataSourceTableUtils.getSparkSerdeProperties(readAsOptimized, this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH));
            serdeProperties.putAll(sparkSerdeProperties);
        }
        return serdeProperties;
    }

    private void syncFirstTime(String tableName, boolean useRealTimeInputFormat, boolean readAsOptimized, MessageType schema) {
        LOG.info("Sync table {} for the first time.", (Object)tableName);
        HoodieFileFormat baseFileFormat = HoodieFileFormat.valueOf(this.config.getStringOrDefault(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT).toUpperCase());
        String inputFormatClassName = HoodieInputFormatUtils.getInputFormatClassName(baseFileFormat, useRealTimeInputFormat, this.config.getBooleanOrDefault(HiveSyncConfigHolder.HIVE_USE_PRE_APACHE_INPUT_FORMAT));
        String outputFormatClassName = HoodieInputFormatUtils.getOutputFormatClassName(baseFileFormat);
        String serDeFormatClassName = HoodieInputFormatUtils.getSerDeClassName(baseFileFormat);
        Map<String, String> serdeProperties = this.getSerdeProperties(readAsOptimized);
        Map<String, String> tableProperties = this.getTableProperties(schema);
        this.syncClient.createTable(tableName, schema, inputFormatClassName, outputFormatClassName, serDeFormatClassName, serdeProperties, tableProperties);
    }

    private boolean syncSchema(String tableName, MessageType schema) {
        boolean schemaChanged = false;
        Map<String, String> tableSchema = this.syncClient.getMetastoreSchema(tableName);
        SchemaDifference schemaDiff = HiveSchemaUtil.getSchemaDifference(schema, tableSchema, this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS), this.config.getBooleanOrDefault(HiveSyncConfigHolder.HIVE_SUPPORT_TIMESTAMP_TYPE));
        if (schemaDiff.isEmpty()) {
            LOG.info("No Schema difference for {}.", (Object)tableName);
        } else {
            LOG.info("Schema difference found for {}. Updated schema: {}", (Object)tableName, (Object)schema);
            this.syncClient.updateTableSchema(tableName, schema, schemaDiff);
            schemaChanged = true;
        }
        if (this.config.getBoolean(HiveSyncConfigHolder.HIVE_SYNC_COMMENT).booleanValue()) {
            List<FieldSchema> fromMetastore = this.syncClient.getMetastoreFieldSchemas(tableName);
            List<FieldSchema> fromStorage = this.syncClient.getStorageFieldSchemas();
            boolean commentsChanged = this.syncClient.updateTableComments(tableName, fromMetastore, fromStorage);
            schemaChanged = schemaChanged || commentsChanged;
        }
        return schemaChanged;
    }

    private boolean syncProperties(String tableName, boolean useRealTimeInputFormat, boolean readAsOptimized, MessageType schema) {
        boolean propertiesChanged = false;
        Map<String, String> serdeProperties = this.getSerdeProperties(readAsOptimized);
        boolean serdePropertiesUpdated = this.syncClient.updateSerdeProperties(tableName, serdeProperties, useRealTimeInputFormat);
        propertiesChanged = propertiesChanged || serdePropertiesUpdated;
        Map<String, String> tableProperties = this.getTableProperties(schema);
        boolean tablePropertiesUpdated = this.syncClient.updateTableProperties(tableName, tableProperties);
        propertiesChanged = propertiesChanged || tablePropertiesUpdated;
        return propertiesChanged;
    }

    private List<Partition> getTablePartitions(String tableName, List<String> writtenPartitions) {
        if (!this.config.getBooleanOrDefault(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED)) {
            return this.syncClient.getAllPartitions(tableName);
        }
        return this.syncClient.getPartitionsFromList(tableName, writtenPartitions);
    }

    private boolean syncAllPartitions(String tableName) {
        try {
            if (this.config.shouldNotSyncPartitionMetadata().booleanValue() || this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).isEmpty()) {
                return false;
            }
            List<Partition> allPartitionsInMetastore = this.syncClient.getAllPartitions(tableName);
            List<String> allPartitionsOnStorage = this.syncClient.getAllPartitionPathsOnStorage();
            return this.syncPartitions(tableName, this.syncClient.getPartitionEvents(allPartitionsInMetastore, allPartitionsOnStorage));
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to sync partitions for table " + tableName, e);
        }
    }

    private boolean syncPartitions(String tableName, List<String> writtenPartitionsSince, Set<String> droppedPartitions) {
        try {
            if (this.config.shouldNotSyncPartitionMetadata().booleanValue() || writtenPartitionsSince.isEmpty() || this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).isEmpty()) {
                return false;
            }
            List<Partition> hivePartitions = this.getTablePartitions(tableName, writtenPartitionsSince);
            return this.syncPartitions(tableName, this.syncClient.getPartitionEvents(hivePartitions, writtenPartitionsSince, droppedPartitions));
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to sync partitions for table " + tableName, e);
        }
    }

    private boolean syncPartitions(String tableName, List<PartitionEvent> partitionEventList) {
        List<String> dropPartitions;
        List<String> updatePartitions;
        List<String> newPartitions = this.filterPartitions(partitionEventList, PartitionEvent.PartitionEventType.ADD);
        if (!newPartitions.isEmpty()) {
            LOG.info("New Partitions " + newPartitions);
            this.syncClient.addPartitionsToTable(tableName, newPartitions);
        }
        if (!(updatePartitions = this.filterPartitions(partitionEventList, PartitionEvent.PartitionEventType.UPDATE)).isEmpty()) {
            LOG.info("Changed Partitions " + updatePartitions);
            this.syncClient.updatePartitionsToTable(tableName, updatePartitions);
        }
        if (!(dropPartitions = this.filterPartitions(partitionEventList, PartitionEvent.PartitionEventType.DROP)).isEmpty()) {
            LOG.info("Drop Partitions " + dropPartitions);
            this.syncClient.dropPartitions(tableName, dropPartitions);
        }
        return !updatePartitions.isEmpty() || !newPartitions.isEmpty() || !dropPartitions.isEmpty();
    }

    private List<String> filterPartitions(List<PartitionEvent> events, PartitionEvent.PartitionEventType eventType) {
        return events.stream().filter(s -> s.eventType == eventType).map(s -> s.storagePartition).collect(Collectors.toList());
    }

    public static void main(String[] args2) {
        HiveSyncConfig.HiveSyncConfigParams params = new HiveSyncConfig.HiveSyncConfigParams();
        JCommander cmd = JCommander.newBuilder().addObject(params).build();
        cmd.parse(args2);
        if (params.isHelp()) {
            cmd.usage();
            System.exit(0);
        }
        new HiveSyncTool((Properties)params.toProps(), new Configuration()).syncHoodieTable();
    }
}

