/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.collection.FlatLists;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.table.BucketIndexBulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public abstract class RDDBucketIndexPartitioner<T>
extends BucketIndexBulkInsertPartitioner<JavaRDD<HoodieRecord<T>>> {
    public static final Logger LOG = LogManager.getLogger(RDDBucketIndexPartitioner.class);

    public RDDBucketIndexPartitioner(HoodieTable table, String sortString, boolean preserveHoodieMetadata) {
        super(table, sortString, preserveHoodieMetadata);
    }

    public JavaRDD<HoodieRecord<T>> doPartition(JavaRDD<HoodieRecord<T>> records, Partitioner partitioner) {
        if (this.isCustomSorted()) {
            return this.doPartitionAndCustomColumnSort(records, partitioner);
        }
        if (this.isRecordKeySorted()) {
            return this.doPartitionAndSortByRecordKey(records, partitioner);
        }
        return records.mapToPair((PairFunction & Serializable)record -> new Tuple2((Object)record.getKey(), record)).partitionBy(partitioner).map(Tuple2::_2);
    }

    private JavaRDD<HoodieRecord<T>> doPartitionAndCustomColumnSort(JavaRDD<HoodieRecord<T>> records, final Partitioner partitioner) {
        String[] sortColumns = this.sortColumnNames;
        SerializableSchema schema = new SerializableSchema(HoodieAvroUtils.addMetadataFields(new Schema.Parser().parse(this.table.getConfig().getSchema())));
        Comparator comparator = (Comparator & Serializable)(t1, t2) -> {
            FlatLists.ComparableList obj1 = FlatLists.ofComparableArray(t1.getColumnValues(schema.get(), sortColumns, this.consistentLogicalTimestampEnabled));
            FlatLists.ComparableList obj2 = FlatLists.ofComparableArray(t2.getColumnValues(schema.get(), sortColumns, this.consistentLogicalTimestampEnabled));
            return obj1.compareTo(obj2);
        };
        return records.mapToPair((PairFunction & Serializable)record -> new Tuple2(record, record)).repartitionAndSortWithinPartitions(new Partitioner(){

            public int numPartitions() {
                return partitioner.numPartitions();
            }

            public int getPartition(Object key) {
                return partitioner.getPartition((Object)((HoodieRecord)key).getKey());
            }
        }, comparator).map(Tuple2::_2);
    }

    private JavaRDD<HoodieRecord<T>> doPartitionAndSortByRecordKey(JavaRDD<HoodieRecord<T>> records, Partitioner partitioner) {
        if (this.table.getConfig().getBulkInsertSortMode() == BulkInsertSortMode.GLOBAL_SORT) {
            LOG.warn("Bucket index does not support global sort mode, the sort will only be done within each data partition");
        }
        Comparator comparator = (Comparator & Serializable)(t1, t2) -> t1.getRecordKey().compareTo(t2.getRecordKey());
        return records.mapToPair((PairFunction & Serializable)record -> new Tuple2((Object)record.getKey(), record)).repartitionAndSortWithinPartitions(partitioner, comparator).map(Tuple2::_2);
    }
}

