/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.util.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopConfigUtils.class);

    public static Configuration createHadoopConf(Properties props) {
        Configuration hadoopConf = new Configuration();
        props.stringPropertyNames().forEach(k -> hadoopConf.set(k, props.getProperty((String)k)));
        return hadoopConf;
    }

    public static Option<String> getRawValueWithAltKeys(Configuration conf, ConfigProperty<?> configProperty) {
        String value = conf.get(configProperty.key());
        if (value != null) {
            return Option.of(value);
        }
        for (String alternative : configProperty.getAlternatives()) {
            String altValue = conf.get(alternative);
            if (altValue == null) continue;
            LOG.warn(String.format("The configuration key '%s' has been deprecated and may be removed in the future. Please use the new key '%s' instead.", alternative, configProperty.key()));
            return Option.of(altValue);
        }
        return Option.empty();
    }

    public static boolean getBooleanWithAltKeys(Configuration conf, ConfigProperty<?> configProperty) {
        Option<String> rawValue = HadoopConfigUtils.getRawValueWithAltKeys(conf, configProperty);
        boolean defaultValue = configProperty.hasDefaultValue() && Boolean.parseBoolean(configProperty.defaultValue().toString());
        return rawValue.map(Boolean::parseBoolean).orElse(defaultValue);
    }
}

