/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.BooleanSupplier;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.MetadataConversionUtils;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.v1.CommitMetadataSerDeV1;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.HoodieInstantWriter;

public class CommitMetadataSerDeV2
implements CommitMetadataSerDe {
    private org.apache.hudi.common.model.HoodieCommitMetadata convertCommitMetadataToPojo(HoodieCommitMetadata hoodieCommitMetadata) {
        hoodieCommitMetadata.getPartitionToWriteStats().remove(null);
        return (org.apache.hudi.common.model.HoodieCommitMetadata)JsonUtils.getObjectMapper().convertValue((Object)hoodieCommitMetadata, org.apache.hudi.common.model.HoodieCommitMetadata.class);
    }

    @Override
    public <T> T deserialize(HoodieInstant instant, InputStream inputStream, BooleanSupplier isEmptyInstant, Class<T> clazz) throws IOException {
        try {
            if (instant.isLegacy()) {
                try {
                    return new CommitMetadataSerDeV1().deserialize(instant, inputStream, isEmptyInstant, clazz);
                }
                catch (Exception e) {
                    throw new IOException("unable to read legacy commit metadata for instant " + instant, e);
                }
            }
            if (HoodieReplaceCommitMetadata.class.isAssignableFrom(clazz)) {
                return (T)MetadataConversionUtils.convertReplaceCommitMetadataToPojo(TimelineMetadataUtils.deserializeAvroMetadata(inputStream, org.apache.hudi.avro.model.HoodieReplaceCommitMetadata.class));
            }
            if (org.apache.hudi.common.model.HoodieCommitMetadata.class.isAssignableFrom(clazz)) {
                return (T)this.convertCommitMetadataToPojo(TimelineMetadataUtils.deserializeAvroMetadata(inputStream, HoodieCommitMetadata.class));
            }
            if (!SpecificRecordBase.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class must extend SpecificRecordBase: " + clazz.getName());
            }
            Class<T> avroClass = clazz;
            return TimelineMetadataUtils.deserializeAvroMetadata(inputStream, avroClass);
        }
        catch (Exception e) {
            if (isEmptyInstant.getAsBoolean()) {
                try {
                    return clazz.newInstance();
                }
                catch (Exception ex) {
                    throw new IOException("unable to read commit metadata for instant " + instant, ex);
                }
            }
            throw new IOException("unable to read commit metadata for instant " + instant, e);
        }
    }

    @Override
    public <T> Option<HoodieInstantWriter> getInstantWriter(T metadata) {
        if (metadata instanceof org.apache.hudi.common.model.HoodieCommitMetadata) {
            return CommitMetadataSerDe.getInstantWriter(Option.of(MetadataConversionUtils.convertCommitMetadataToAvro((org.apache.hudi.common.model.HoodieCommitMetadata)metadata)));
        }
        return CommitMetadataSerDe.getInstantWriter(Option.of((SpecificRecordBase)metadata));
    }
}

