/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bootstrap.index.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hudi.avro.model.HoodieBootstrapFilePartitionInfo;
import org.apache.hudi.avro.model.HoodieBootstrapIndexInfo;
import org.apache.hudi.avro.model.HoodieBootstrapPartitionMetadata;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.bootstrap.index.hfile.HFileBootstrapIndex;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.hadoop.HoodieHFileUtils;
import org.apache.hudi.io.util.IOUtils;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseHFileBootstrapIndexReader
extends BootstrapIndex.IndexReader {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseHFileBootstrapIndexReader.class);
    private final String bootstrapBasePath;
    private final String indexByPartitionPath;
    private final String indexByFileIdPath;
    private transient HFile.Reader indexByPartitionReader;
    private transient HFile.Reader indexByFileIdReader;
    private transient HoodieBootstrapIndexInfo bootstrapIndexInfo;

    public HBaseHFileBootstrapIndexReader(HoodieTableMetaClient metaClient) {
        super(metaClient);
        StoragePath indexByPartitionPath = HFileBootstrapIndex.partitionIndexPath(metaClient);
        StoragePath indexByFilePath = HFileBootstrapIndex.fileIdIndexPath(metaClient);
        this.indexByPartitionPath = indexByPartitionPath.toString();
        this.indexByFileIdPath = indexByFilePath.toString();
        this.initIndexInfo();
        this.bootstrapBasePath = this.bootstrapIndexInfo.getBootstrapBasePath();
        LOG.info("Loaded HFileBasedBootstrapIndex with source base path :" + this.bootstrapBasePath);
    }

    private static String getUserKeyFromCellKey(String cellKey) {
        int hfileSuffixBeginIndex = cellKey.lastIndexOf("//LATEST_TIMESTAMP/Put/vlen");
        return cellKey.substring(0, hfileSuffixBeginIndex);
    }

    private static HFile.Reader createReader(String hFilePath, Configuration conf, FileSystem fileSystem2) {
        return HoodieHFileUtils.createHFileReader(fileSystem2, new HFilePathForReader(hFilePath), new CacheConfig(conf), conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIndexInfo() {
        HBaseHFileBootstrapIndexReader hBaseHFileBootstrapIndexReader = this;
        synchronized (hBaseHFileBootstrapIndexReader) {
            if (null == this.bootstrapIndexInfo) {
                try {
                    this.bootstrapIndexInfo = this.fetchBootstrapIndexInfo();
                }
                catch (IOException ioe) {
                    throw new HoodieException(ioe.getMessage(), ioe);
                }
            }
        }
    }

    private HoodieBootstrapIndexInfo fetchBootstrapIndexInfo() throws IOException {
        return TimelineMetadataUtils.deserializeAvroMetadataLegacy(this.partitionIndexReader().getHFileInfo().get(HFileBootstrapIndex.INDEX_INFO_KEY), HoodieBootstrapIndexInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HFile.Reader partitionIndexReader() {
        if (null == this.indexByPartitionReader) {
            HBaseHFileBootstrapIndexReader hBaseHFileBootstrapIndexReader = this;
            synchronized (hBaseHFileBootstrapIndexReader) {
                if (null == this.indexByPartitionReader) {
                    LOG.info("Opening partition index :" + this.indexByPartitionPath);
                    this.indexByPartitionReader = HBaseHFileBootstrapIndexReader.createReader(this.indexByPartitionPath, this.metaClient.getStorageConf().unwrapAs(Configuration.class), (FileSystem)this.metaClient.getStorage().getFileSystem());
                }
            }
        }
        return this.indexByPartitionReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HFile.Reader fileIdIndexReader() {
        if (null == this.indexByFileIdReader) {
            HBaseHFileBootstrapIndexReader hBaseHFileBootstrapIndexReader = this;
            synchronized (hBaseHFileBootstrapIndexReader) {
                if (null == this.indexByFileIdReader) {
                    LOG.info("Opening fileId index :" + this.indexByFileIdPath);
                    this.indexByFileIdReader = HBaseHFileBootstrapIndexReader.createReader(this.indexByFileIdPath, this.metaClient.getStorageConf().unwrapAs(Configuration.class), (FileSystem)this.metaClient.getStorage().getFileSystem());
                }
            }
        }
        return this.indexByFileIdReader;
    }

    @Override
    public List<String> getIndexedPartitionPaths() {
        try (HFileScanner scanner = this.partitionIndexReader().getScanner(true, false);){
            List<String> list = this.getAllKeys(scanner, HFileBootstrapIndex::getPartitionFromKey);
            return list;
        }
    }

    @Override
    public List<HoodieFileGroupId> getIndexedFileGroupIds() {
        try (HFileScanner scanner = this.fileIdIndexReader().getScanner(true, false);){
            List<HoodieFileGroupId> list = this.getAllKeys(scanner, HFileBootstrapIndex::getFileGroupFromKey);
            return list;
        }
    }

    private <T> List<T> getAllKeys(HFileScanner scanner, Function<String, T> converter) {
        ArrayList<T> keys2 = new ArrayList<T>();
        try {
            boolean available = scanner.seekTo();
            while (available) {
                keys2.add(converter.apply(HBaseHFileBootstrapIndexReader.getUserKeyFromCellKey(CellUtil.getCellKeyAsString(scanner.getCell()))));
                available = scanner.next();
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
        return keys2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BootstrapFileMapping> getSourceFileMappingForPartition(String partition) {
        try (HFileScanner scanner = this.partitionIndexReader().getScanner(true, false);){
            KeyValue keyValue = new KeyValue(StringUtils.getUTF8Bytes(HFileBootstrapIndex.getPartitionKey(partition)), new byte[0], new byte[0], Long.MAX_VALUE, KeyValue.Type.Put, new byte[0]);
            if (scanner.seekTo(keyValue) == 0) {
                ByteBuffer readValue = scanner.getValue();
                byte[] valBytes = IOUtils.toBytes(readValue);
                HoodieBootstrapPartitionMetadata metadata = TimelineMetadataUtils.deserializeAvroMetadataLegacy(valBytes, HoodieBootstrapPartitionMetadata.class);
                List<BootstrapFileMapping> list = metadata.getFileIdToBootstrapFile().entrySet().stream().map(e -> new BootstrapFileMapping(this.bootstrapBasePath, metadata.getBootstrapPartitionPath(), partition, (HoodieFileStatus)((Object)((Object)e.getValue())), (String)e.getKey())).collect(Collectors.toList());
                return list;
            }
            LOG.warn("No value found for partition key (" + partition + ")");
            ArrayList<BootstrapFileMapping> arrayList = new ArrayList<BootstrapFileMapping>();
            return arrayList;
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public String getBootstrapBasePath() {
        return this.bootstrapBasePath;
    }

    @Override
    public Map<HoodieFileGroupId, BootstrapFileMapping> getSourceFileMappingForFileIds(List<HoodieFileGroupId> ids) {
        HashMap<HoodieFileGroupId, BootstrapFileMapping> result = new HashMap<HoodieFileGroupId, BootstrapFileMapping>();
        ArrayList<HoodieFileGroupId> fileGroupIds = new ArrayList<HoodieFileGroupId>(ids);
        Collections.sort(fileGroupIds);
        try (HFileScanner scanner = this.fileIdIndexReader().getScanner(true, false);){
            for (HoodieFileGroupId fileGroupId : fileGroupIds) {
                KeyValue keyValue = new KeyValue(StringUtils.getUTF8Bytes(HFileBootstrapIndex.getFileGroupKey(fileGroupId)), new byte[0], new byte[0], Long.MAX_VALUE, KeyValue.Type.Put, new byte[0]);
                if (scanner.seekTo(keyValue) != 0) continue;
                ByteBuffer readValue = scanner.getValue();
                byte[] valBytes = IOUtils.toBytes(readValue);
                HoodieBootstrapFilePartitionInfo fileInfo = TimelineMetadataUtils.deserializeAvroMetadataLegacy(valBytes, HoodieBootstrapFilePartitionInfo.class);
                BootstrapFileMapping mapping = new BootstrapFileMapping(this.bootstrapBasePath, fileInfo.getBootstrapPartitionPath(), fileInfo.getPartitionPath(), fileInfo.getBootstrapFileStatus(), fileGroupId.getFileId());
                result.put(fileGroupId, mapping);
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
        return result;
    }

    @Override
    public void close() {
        try {
            if (this.indexByPartitionReader != null) {
                this.indexByPartitionReader.close(true);
                this.indexByPartitionReader = null;
            }
            if (this.indexByFileIdReader != null) {
                this.indexByFileIdReader.close(true);
                this.indexByFileIdReader = null;
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    private static class HFilePathForReader
    extends Path {
        public HFilePathForReader(String pathString) throws IllegalArgumentException {
            super(pathString);
        }

        public String getName() {
            return this.toString();
        }
    }
}

