/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.client.timeline.ActiveActionWithDetails;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.ActiveAction;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.v1.CommitMetadataSerDeV1;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyArchivedMetaEntryReader {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyArchivedMetaEntryReader.class);
    private static final Pattern ARCHIVE_FILE_PATTERN = Pattern.compile("^\\.commits_\\.archive\\.([0-9]+).*");
    public static final String MERGE_ARCHIVE_PLAN_NAME = "mergeArchivePlan";
    private static final String ACTION_TYPE_KEY = "actionType";
    private static final String ACTION_STATE = "actionState";
    private static final String STATE_TRANSITION_TIME = "stateTransitionTime";
    private final HoodieTableMetaClient metaClient;

    public LegacyArchivedMetaEntryReader(HoodieTableMetaClient metaClient) {
        this.metaClient = metaClient;
    }

    public ClosableIterator<ActiveAction> getActiveActionsIterator() {
        return this.loadInstants(null);
    }

    public ClosableIterator<ActiveAction> getActiveActionsIterator(HoodieArchivedTimeline.TimeRangeFilter filter) {
        return this.loadInstants(filter);
    }

    private Pair<HoodieInstant, Option<byte[]>> readInstant(GenericRecord record) {
        String instantTime = record.get("commitTime").toString();
        String action = record.get(ACTION_TYPE_KEY).toString();
        String stateTransitionTime = (String)record.get(STATE_TRANSITION_TIME);
        Option<byte[]> details = this.getMetadataKey(action).map(key -> {
            Object actionData = record.get(key);
            if (actionData != null) {
                if (actionData instanceof IndexedRecord) {
                    return HoodieAvroUtils.avroToBytes((IndexedRecord)actionData);
                }
                try {
                    HoodieInstant instant = this.metaClient.getInstantGenerator().createNewInstant(HoodieInstant.State.COMPLETED, action, instantTime, stateTransitionTime);
                    byte[] instantBytes = StringUtils.getUTF8Bytes(actionData.toString());
                    HoodieCommitMetadata commitMetadata = new CommitMetadataSerDeV1().deserialize(instant, new ByteArrayInputStream(instantBytes), () -> instantBytes.length == 0, HoodieCommitMetadata.class);
                    return TimelineMetadataUtils.convertMetadataToByteArray(commitMetadata, this.metaClient.getCommitMetadataSerDe());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        });
        InstantGenerator instantGenerator = this.metaClient.getInstantGenerator();
        HoodieInstant instant = instantGenerator.createNewInstant(HoodieInstant.State.valueOf(record.get(ACTION_STATE).toString()), action, instantTime, stateTransitionTime);
        return Pair.of(instant, details);
    }

    @Nonnull
    private Option<String> getMetadataKey(String action) {
        switch (action) {
            case "clean": {
                return Option.of("hoodieCleanMetadata");
            }
            case "commit": 
            case "deltacommit": {
                return Option.of("hoodieCommitMetadata");
            }
            case "rollback": {
                return Option.of("hoodieRollbackMetadata");
            }
            case "savepoint": {
                return Option.of("hoodieSavePointMetadata");
            }
            case "compaction": 
            case "logcompaction": {
                return Option.of("hoodieCompactionPlan");
            }
            case "replacecommit": {
                return Option.of("hoodieReplaceCommitMetadata");
            }
            case "clustering": {
                return Option.of("hoodieReplaceCommitMetadata");
            }
            case "indexing": {
                return Option.of("hoodieIndexCommitMetadata");
            }
        }
        LOG.error(String.format("Unknown action in metadata (%s)", action));
        return Option.empty();
    }

    private ClosableIterator<ActiveAction> loadInstants(final HoodieArchivedTimeline.TimeRangeFilter filter) {
        try {
            List<StoragePathInfo> pathInfoList = this.metaClient.getStorage().globEntries(new StoragePath(this.metaClient.getArchivePath(), ".commits_.archive*"));
            pathInfoList.sort(new ArchiveLogVersionComparator());
            final ClosableIterator<HoodieRecord<IndexedRecord>> itr = this.getRecordIterator(pathInfoList);
            return new ClosableIterator<ActiveAction>(){
                private ActiveAction activeAction;
                private Pair<HoodieInstant, Option<byte[]>> nextInstantAndDetail;

                @Override
                public void close() {
                    itr.close();
                }

                @Override
                public boolean hasNext() {
                    ArrayList<Pair<HoodieInstant, Option<byte[]>>> instantAndDetails = new ArrayList<Pair<HoodieInstant, Option<byte[]>>>();
                    String lastInstantTime = null;
                    if (this.nextInstantAndDetail != null) {
                        instantAndDetails.add(this.nextInstantAndDetail);
                        lastInstantTime = this.nextInstantAndDetail.getKey().requestedTime();
                        this.nextInstantAndDetail = null;
                    }
                    while (itr.hasNext()) {
                        HoodieRecord record = (HoodieRecord)itr.next();
                        Pair instantAndDetail = LegacyArchivedMetaEntryReader.this.readInstant((GenericRecord)record.getData());
                        String instantTime = ((HoodieInstant)instantAndDetail.getKey()).requestedTime();
                        if (filter != null && !filter.isInRange(instantTime)) continue;
                        if (lastInstantTime == null) {
                            instantAndDetails.add(instantAndDetail);
                            lastInstantTime = instantTime;
                            continue;
                        }
                        if (lastInstantTime.equals(instantTime)) {
                            instantAndDetails.add(instantAndDetail);
                            continue;
                        }
                        this.nextInstantAndDetail = instantAndDetail;
                        break;
                    }
                    if (!instantAndDetails.isEmpty()) {
                        this.activeAction = ActiveActionWithDetails.fromInstantAndDetails(instantAndDetails);
                        return true;
                    }
                    return false;
                }

                @Override
                public ActiveAction next() {
                    return this.activeAction;
                }
            };
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not load archived commit timeline from path " + this.metaClient.getArchivePath(), e);
        }
    }

    private ClosableIterator<HoodieRecord<IndexedRecord>> getRecordIterator(final List<StoragePathInfo> pathInfoList) throws IOException {
        return new ClosableIterator<HoodieRecord<IndexedRecord>>(){
            final Iterator<StoragePathInfo> pathInfoIterator;
            HoodieLogFormat.Reader reader;
            ClosableIterator<HoodieRecord<IndexedRecord>> recordItr;
            {
                this.pathInfoIterator = pathInfoList.iterator();
            }

            @Override
            public void close() {
                if (this.reader != null) {
                    LegacyArchivedMetaEntryReader.this.closeLogFormatReader(this.reader);
                }
            }

            @Override
            public boolean hasNext() {
                if (this.recordItr != null && this.recordItr.hasNext()) {
                    return true;
                }
                if (this.reader != null) {
                    while (this.reader.hasNext()) {
                        HoodieLogBlock block = (HoodieLogBlock)this.reader.next();
                        if (!(block instanceof HoodieAvroDataBlock)) continue;
                        HoodieAvroDataBlock avroBlock = (HoodieAvroDataBlock)block;
                        this.recordItr = avroBlock.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                        if (!this.recordItr.hasNext()) continue;
                        return true;
                    }
                    LegacyArchivedMetaEntryReader.this.closeLogFormatReader(this.reader);
                    this.reader = null;
                }
                while (this.pathInfoIterator.hasNext()) {
                    StoragePathInfo pathInfo = this.pathInfoIterator.next();
                    try {
                        this.reader = HoodieLogFormat.newReader(LegacyArchivedMetaEntryReader.this.metaClient.getStorage(), new HoodieLogFile(pathInfo.getPath()), HoodieArchivedMetaEntry.getClassSchema());
                    }
                    catch (IOException ioe) {
                        throw new HoodieIOException("Error initializing the reader for archived log: " + pathInfo.getPath(), ioe);
                    }
                    while (this.reader.hasNext()) {
                        HoodieLogBlock block = (HoodieLogBlock)this.reader.next();
                        if (!(block instanceof HoodieAvroDataBlock)) continue;
                        HoodieAvroDataBlock avroBlock = (HoodieAvroDataBlock)block;
                        this.recordItr = avroBlock.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                        if (!this.recordItr.hasNext()) continue;
                        return true;
                    }
                    if (this.reader.hasNext()) continue;
                    try {
                        this.reader.close();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to close log reader " + pathInfo.getPath());
                    }
                }
                return false;
            }

            @Override
            public HoodieRecord<IndexedRecord> next() {
                return (HoodieRecord)this.recordItr.next();
            }
        };
    }

    private void closeLogFormatReader(HoodieLogFormat.Reader reader) {
        try {
            reader.close();
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error closing log format reader", ioe);
        }
    }

    private static int getArchivedFileSuffix(StoragePathInfo f) {
        try {
            Matcher fileMatcher = ARCHIVE_FILE_PATTERN.matcher(f.getPath().getName());
            if (fileMatcher.matches()) {
                return Integer.parseInt(fileMatcher.group(1));
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("error getting suffix for archived file: " + f.getPath());
        }
        return 0;
    }

    public static class ArchiveLogVersionComparator
    implements Comparator<StoragePathInfo>,
    Serializable {
        @Override
        public int compare(StoragePathInfo f1, StoragePathInfo f2) {
            return Integer.compare(LegacyArchivedMetaEntryReader.getArchivedFileSuffix(f2), LegacyArchivedMetaEntryReader.getArchivedFileSuffix(f1));
        }
    }
}

