/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import io.hops.hudi.org.apache.commons.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.ByteBuffInputStream;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class CellCodecWithTags
implements Codec {
    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        return new CellDecoder(is);
    }

    @Override
    public Codec.Decoder getDecoder(ByteBuff buf) {
        return this.getDecoder(new ByteBuffInputStream(buf));
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        return new CellEncoder(os);
    }

    static class CellDecoder
    extends BaseDecoder {
        private final ExtendedCellBuilder cellBuilder = ExtendedCellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);

        public CellDecoder(InputStream in) {
            super(in);
        }

        @Override
        protected Cell parseCell() throws IOException {
            byte[] row = this.readByteArray(this.in);
            byte[] family = this.readByteArray(this.in);
            byte[] qualifier = this.readByteArray(this.in);
            byte[] longArray = new byte[8];
            IOUtils.readFully(this.in, longArray);
            long timestamp = Bytes.toLong(longArray);
            byte type = (byte)this.in.read();
            byte[] value = this.readByteArray(this.in);
            byte[] tags = this.readByteArray(this.in);
            byte[] memstoreTSArray = new byte[8];
            IOUtils.readFully(this.in, memstoreTSArray);
            long memstoreTS = Bytes.toLong(memstoreTSArray);
            return this.cellBuilder.clear().setRow(row).setFamily(family).setQualifier(qualifier).setTimestamp(timestamp).setType(type).setValue(value).setSequenceId(memstoreTS).setTags(tags).build();
        }

        private byte[] readByteArray(InputStream in) throws IOException {
            byte[] intArray = new byte[4];
            IOUtils.readFully(in, intArray);
            int length = Bytes.toInt(intArray);
            byte[] bytes = new byte[length];
            IOUtils.readFully(in, bytes);
            return bytes;
        }
    }

    static class CellEncoder
    extends BaseEncoder {
        CellEncoder(OutputStream out) {
            super(out);
        }

        @Override
        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            this.write(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
            this.write(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
            this.write(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            this.out.write(Bytes.toBytes(cell.getTimestamp()));
            this.out.write(cell.getTypeByte());
            this.write(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            this.write(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
            this.out.write(Bytes.toBytes(cell.getSequenceId()));
        }

        private void write(byte[] bytes, int offset, int length) throws IOException {
            this.out.write(Bytes.toBytes(length));
            this.out.write(bytes, offset, length);
        }
    }
}

