/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.roaringbitmap;

import io.hops.hudi.org.roaringbitmap.ArrayContainer;
import io.hops.hudi.org.roaringbitmap.BitmapContainer;
import io.hops.hudi.org.roaringbitmap.CharIterator;
import io.hops.hudi.org.roaringbitmap.Container;
import io.hops.hudi.org.roaringbitmap.RunContainer;
import java.util.Arrays;

public final class Util {
    public static final boolean USE_HYBRID_BINSEARCH = true;

    public static Container[] addOffset(Container source, char offsets) {
        if (source instanceof ArrayContainer) {
            ArrayContainer c = (ArrayContainer)source;
            ArrayContainer low = new ArrayContainer(c.cardinality);
            ArrayContainer high = new ArrayContainer(c.cardinality);
            for (int k = 0; k < c.cardinality; ++k) {
                int val = c.content[k];
                if ((val += offsets) <= 65535) {
                    low.content[low.cardinality++] = (char)val;
                    continue;
                }
                high.content[high.cardinality++] = (char)val;
            }
            return new Container[]{low, high};
        }
        if (source instanceof BitmapContainer) {
            BitmapContainer c = (BitmapContainer)source;
            BitmapContainer low = new BitmapContainer();
            BitmapContainer high = new BitmapContainer();
            low.cardinality = -1;
            high.cardinality = -1;
            int b = offsets >>> 6;
            int i = offsets % 64;
            if (i == 0) {
                System.arraycopy(c.bitmap, 0, low.bitmap, b, 1024 - b);
                System.arraycopy(c.bitmap, 1024 - b, high.bitmap, 0, b);
            } else {
                int k;
                low.bitmap[b + 0] = c.bitmap[0] << i;
                for (k = 1; k < 1024 - b; ++k) {
                    low.bitmap[b + k] = c.bitmap[k] << i | c.bitmap[k - 1] >>> 64 - i;
                }
                for (k = 1024 - b; k < 1024; ++k) {
                    high.bitmap[k - (1024 - b)] = c.bitmap[k] << i | c.bitmap[k - 1] >>> 64 - i;
                }
                high.bitmap[b] = c.bitmap[1023] >>> 64 - i;
            }
            return new Container[]{low.repairAfterLazy(), high.repairAfterLazy()};
        }
        if (source instanceof RunContainer) {
            RunContainer input = (RunContainer)source;
            RunContainer low = new RunContainer();
            RunContainer high = new RunContainer();
            for (int k = 0; k < input.nbrruns; ++k) {
                int val = input.getValue(k);
                int finalval = (val += offsets) + input.getLength(k);
                if (val <= 65535) {
                    if (finalval <= 65535) {
                        low.smartAppend((char)val, input.getLength(k));
                        continue;
                    }
                    low.smartAppend((char)val, (char)(65535 - val));
                    high.smartAppend('\u0000', (char)finalval);
                    continue;
                }
                high.smartAppend((char)val, input.getLength(k));
            }
            return new Container[]{low, high};
        }
        throw new RuntimeException("unknown container type");
    }

    public static int advanceUntil(char[] array, int pos, int length, char min) {
        int upper;
        int lower = pos + 1;
        if (lower >= length || array[lower] >= min) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < length && array[lower + spansize] < min) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < length ? lower + spansize : length - 1;
        if (array[upper] == min) {
            return upper;
        }
        if (array[upper] < min) {
            return length;
        }
        lower += spansize >>> 1;
        while (lower + 1 != upper) {
            int mid = lower + upper >>> 1;
            char arraymid = array[mid];
            if (arraymid == min) {
                return mid;
            }
            if (arraymid < min) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    public static int reverseUntil(char[] array, int pos, int length, char max) {
        int upper;
        int lower = pos - 1;
        if (lower <= 0 || array[lower] <= max) {
            return lower;
        }
        int spansize = 1;
        while (lower - spansize > 0 && array[lower - spansize] > max) {
            spansize *= 2;
        }
        int n = upper = lower - spansize > 0 ? lower - spansize : 0;
        if (array[upper] == max) {
            return upper;
        }
        if (array[upper] > max) {
            return 0;
        }
        lower -= spansize >>> 1;
        while (lower - 1 != upper) {
            int mid = lower + upper >>> 1;
            char arraymid = array[mid];
            if (arraymid == max) {
                return mid;
            }
            if (arraymid > max) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    public static int iterateUntil(char[] array, int pos, int length, int min) {
        while (pos < length && array[pos] < min) {
            ++pos;
        }
        return pos;
    }

    protected static int branchyUnsignedBinarySearch(char[] array, int begin, int end, char k) {
        if (end > 0 && array[end - 1] < k) {
            return -end - 1;
        }
        int low = begin;
        int high = end - 1;
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            char middleValue = array[middleIndex];
            if (middleValue < k) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > k) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    public static void fillArrayAND(char[] container, long[] bitmap1, long[] bitmap2) {
        int pos = 0;
        if (bitmap1.length != bitmap2.length) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.length; ++k) {
            for (long bitset = bitmap1[k] & bitmap2[k]; bitset != 0L; bitset &= bitset - 1L) {
                container[pos++] = (char)(k * 64 + Long.numberOfTrailingZeros(bitset));
            }
        }
    }

    public static void fillArrayANDNOT(char[] container, long[] bitmap1, long[] bitmap2) {
        int pos = 0;
        if (bitmap1.length != bitmap2.length) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.length; ++k) {
            for (long bitset = bitmap1[k] & (bitmap2[k] ^ 0xFFFFFFFFFFFFFFFFL); bitset != 0L; bitset &= bitset - 1L) {
                container[pos++] = (char)(k * 64 + Long.numberOfTrailingZeros(bitset));
            }
        }
    }

    public static void fillArrayXOR(char[] container, long[] bitmap1, long[] bitmap2) {
        int pos = 0;
        if (bitmap1.length != bitmap2.length) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.length; ++k) {
            for (long bitset = bitmap1[k] ^ bitmap2[k]; bitset != 0L; bitset &= bitset - 1L) {
                container[pos++] = (char)(k * 64 + Long.numberOfTrailingZeros(bitset));
            }
        }
    }

    public static void flipBitmapRange(long[] bitmap, int start2, int end) {
        if (start2 == end) {
            return;
        }
        int firstword = start2 / 64;
        int endword = (end - 1) / 64;
        int n = firstword;
        bitmap[n] = bitmap[n] ^ (-1L << start2 ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i = firstword; i < endword; ++i) {
            bitmap[i] = bitmap[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endword;
        bitmap[n2] = bitmap[n2] ^ -1L >>> -end;
    }

    @Deprecated
    public static int cardinalityInBitmapWordRange(long[] bitmap, int start2, int end) {
        if (start2 >= end) {
            return 0;
        }
        int firstword = start2 / 64;
        int endword = (end - 1) / 64;
        int answer = 0;
        for (int i = firstword; i <= endword; ++i) {
            answer += Long.bitCount(bitmap[i]);
        }
        return answer;
    }

    public static int cardinalityInBitmapRange(long[] bitmap, int start2, int end) {
        if (start2 >= end) {
            return 0;
        }
        int firstword = start2 / 64;
        int endword = (end - 1) / 64;
        if (firstword == endword) {
            return Long.bitCount(bitmap[firstword] & (-1L << start2 & -1L >>> -end));
        }
        int answer = Long.bitCount(bitmap[firstword] & -1L << start2);
        for (int i = firstword + 1; i < endword; ++i) {
            answer += Long.bitCount(bitmap[i]);
        }
        return answer += Long.bitCount(bitmap[endword] & -1L >>> -end);
    }

    protected static char highbits(int x) {
        return (char)(x >>> 16);
    }

    protected static char highbits(long x) {
        return (char)(x >>> 16);
    }

    protected static int hybridUnsignedBinarySearch(char[] array, int begin, int end, char k) {
        int x;
        if (end > 0 && array[end - 1] < k) {
            return -end - 1;
        }
        int low = begin;
        int high = end - 1;
        while (low + 32 <= high) {
            int middleIndex = low + high >>> 1;
            char middleValue = array[middleIndex];
            if (middleValue < k) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > k) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        for (x = low; x <= high; ++x) {
            char val = array[x];
            if (val < k) continue;
            if (val != k) break;
            return x;
        }
        return -(x + 1);
    }

    protected static char lowbits(int x) {
        return (char)x;
    }

    protected static char lowbits(long x) {
        return (char)x;
    }

    protected static int lowbitsAsInteger(int x) {
        return x & 0xFFFF;
    }

    protected static int lowbitsAsInteger(long x) {
        return (int)(x & 0xFFFFL);
    }

    public static int maxLowBitAsInteger() {
        return 65535;
    }

    public static void resetBitmapRange(long[] bitmap, int start2, int end) {
        if (start2 == end) {
            return;
        }
        int firstword = start2 / 64;
        int endword = (end - 1) / 64;
        if (firstword == endword) {
            int n = firstword;
            bitmap[n] = bitmap[n] & (-1L << start2 & -1L >>> -end ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        int n = firstword;
        bitmap[n] = bitmap[n] & (-1L << start2 ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i = firstword + 1; i < endword; ++i) {
            bitmap[i] = 0L;
        }
        int n2 = endword;
        bitmap[n2] = bitmap[n2] & (-1L >>> -end ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int intersectArrayIntoBitmap(long[] bitmap, char[] array, int length) {
        int lastWordIndex = 0;
        int wordIndex = 0;
        long word = 0L;
        int cardinality = 0;
        for (int i = 0; i < length; ++i) {
            wordIndex = array[i] >>> 6;
            if (wordIndex != lastWordIndex) {
                int n = lastWordIndex;
                bitmap[n] = bitmap[n] & word;
                cardinality += Long.bitCount(bitmap[lastWordIndex]);
                word = 0L;
                Arrays.fill(bitmap, lastWordIndex + 1, wordIndex, 0L);
                lastWordIndex = wordIndex;
            }
            word |= 1L << array[i];
        }
        if (word != 0L) {
            int n = wordIndex;
            bitmap[n] = bitmap[n] & word;
            cardinality += Long.bitCount(bitmap[lastWordIndex]);
        }
        if (wordIndex < bitmap.length) {
            Arrays.fill(bitmap, wordIndex + 1, bitmap.length, 0L);
        }
        return cardinality;
    }

    public static int select(long w, int j) {
        int counter;
        int ww;
        int seen = 0;
        int part = (int)w;
        int n = Integer.bitCount(part);
        if (n <= j) {
            part = (int)(w >>> 32);
            seen += 32;
            j -= n;
        }
        if ((n = Integer.bitCount(part = (ww = part) & 0xFFFF)) <= j) {
            part = ww >>> 16;
            seen += 16;
            j -= n;
        }
        if ((n = Integer.bitCount(part = (ww = part) & 0xFF)) <= j) {
            part = ww >>> 8;
            seen += 8;
            j -= n;
        }
        ww = part;
        for (counter = 0; counter < 8 && (j -= ww >>> counter & 1) >= 0; ++counter) {
        }
        return seen + counter;
    }

    public static void setBitmapRange(long[] bitmap, int start2, int end) {
        if (start2 == end) {
            return;
        }
        int firstword = start2 / 64;
        int endword = (end - 1) / 64;
        if (firstword == endword) {
            int n = firstword;
            bitmap[n] = bitmap[n] | -1L << start2 & -1L >>> -end;
            return;
        }
        int n = firstword;
        bitmap[n] = bitmap[n] | -1L << start2;
        for (int i = firstword + 1; i < endword; ++i) {
            bitmap[i] = -1L;
        }
        int n2 = endword;
        bitmap[n2] = bitmap[n2] | -1L >>> -end;
    }

    @Deprecated
    public static int setBitmapRangeAndCardinalityChange(long[] bitmap, int start2, int end) {
        int cardbefore = Util.cardinalityInBitmapWordRange(bitmap, start2, end);
        Util.setBitmapRange(bitmap, start2, end);
        int cardafter = Util.cardinalityInBitmapWordRange(bitmap, start2, end);
        return cardafter - cardbefore;
    }

    @Deprecated
    public static int flipBitmapRangeAndCardinalityChange(long[] bitmap, int start2, int end) {
        int cardbefore = Util.cardinalityInBitmapWordRange(bitmap, start2, end);
        Util.flipBitmapRange(bitmap, start2, end);
        int cardafter = Util.cardinalityInBitmapWordRange(bitmap, start2, end);
        return cardafter - cardbefore;
    }

    @Deprecated
    public static int resetBitmapRangeAndCardinalityChange(long[] bitmap, int start2, int end) {
        int cardbefore = Util.cardinalityInBitmapWordRange(bitmap, start2, end);
        Util.resetBitmapRange(bitmap, start2, end);
        int cardafter = Util.cardinalityInBitmapWordRange(bitmap, start2, end);
        return cardafter - cardbefore;
    }

    public static int unsignedBinarySearch(char[] array, int begin, int end, char k) {
        return Util.hybridUnsignedBinarySearch(array, begin, end, k);
    }

    public static int unsignedDifference(char[] set1, int length1, char[] set2, int length2, char[] buffer) {
        int pos = 0;
        int k1 = 0;
        int k2 = 0;
        if (0 == length2) {
            System.arraycopy(set1, 0, buffer, 0, length1);
            return length1;
        }
        if (0 == length1) {
            return 0;
        }
        char s1 = set1[k1];
        char s2 = set2[k2];
        while (true) {
            if (s1 < s2) {
                buffer[pos++] = s1;
                if (++k1 >= length1) break;
                s1 = set1[k1];
                continue;
            }
            if (s1 == s2) {
                ++k2;
                if (++k1 >= length1) break;
                if (k2 >= length2) {
                    System.arraycopy(set1, k1, buffer, pos, length1 - k1);
                    return pos + length1 - k1;
                }
                s1 = set1[k1];
                s2 = set2[k2];
                continue;
            }
            if (++k2 >= length2) {
                System.arraycopy(set1, k1, buffer, pos, length1 - k1);
                return pos + length1 - k1;
            }
            s2 = set2[k2];
        }
        return pos;
    }

    public static int unsignedDifference(CharIterator set1, CharIterator set2, char[] buffer) {
        int pos = 0;
        if (!set2.hasNext()) {
            while (set1.hasNext()) {
                buffer[pos++] = set1.next();
            }
            return pos;
        }
        if (!set1.hasNext()) {
            return 0;
        }
        char v1 = set1.next();
        char v2 = set2.next();
        while (true) {
            if (v1 < v2) {
                buffer[pos++] = v1;
                if (!set1.hasNext()) {
                    return pos;
                }
                v1 = set1.next();
                continue;
            }
            if (v1 == v2) {
                if (!set1.hasNext()) break;
                if (!set2.hasNext()) {
                    while (set1.hasNext()) {
                        buffer[pos++] = set1.next();
                    }
                    return pos;
                }
                v1 = set1.next();
                v2 = set2.next();
                continue;
            }
            if (!set2.hasNext()) {
                buffer[pos++] = v1;
                while (set1.hasNext()) {
                    buffer[pos++] = set1.next();
                }
                return pos;
            }
            v2 = set2.next();
        }
        return pos;
    }

    public static int unsignedExclusiveUnion2by2(char[] set1, int length1, char[] set2, int length2, char[] buffer) {
        int pos = 0;
        int k1 = 0;
        int k2 = 0;
        if (0 == length2) {
            System.arraycopy(set1, 0, buffer, 0, length1);
            return length1;
        }
        if (0 == length1) {
            System.arraycopy(set2, 0, buffer, 0, length2);
            return length2;
        }
        char s1 = set1[k1];
        char s2 = set2[k2];
        while (true) {
            if (s1 < s2) {
                buffer[pos++] = s1;
                if (++k1 >= length1) {
                    System.arraycopy(set2, k2, buffer, pos, length2 - k2);
                    return pos + length2 - k2;
                }
                s1 = set1[k1];
                continue;
            }
            if (s1 == s2) {
                ++k2;
                if (++k1 >= length1) {
                    System.arraycopy(set2, k2, buffer, pos, length2 - k2);
                    return pos + length2 - k2;
                }
                if (k2 >= length2) {
                    System.arraycopy(set1, k1, buffer, pos, length1 - k1);
                    return pos + length1 - k1;
                }
                s1 = set1[k1];
                s2 = set2[k2];
                continue;
            }
            buffer[pos++] = s2;
            if (++k2 >= length2) {
                System.arraycopy(set1, k1, buffer, pos, length1 - k1);
                return pos + length1 - k1;
            }
            s2 = set2[k2];
        }
    }

    public static int unsignedIntersect2by2(char[] set1, int length1, char[] set2, int length2, char[] buffer) {
        int THRESHOLD = 25;
        if (set1.length * 25 < set2.length) {
            return Util.unsignedOneSidedGallopingIntersect2by2(set1, length1, set2, length2, buffer);
        }
        if (set2.length * 25 < set1.length) {
            return Util.unsignedOneSidedGallopingIntersect2by2(set2, length2, set1, length1, buffer);
        }
        return Util.unsignedLocalIntersect2by2(set1, length1, set2, length2, buffer);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean unsignedIntersects(char[] set1, int length1, char[] set2, int length2) {
        if (0 == length1) return false;
        if (0 == length2) {
            return false;
        }
        int k1 = 0;
        int k2 = 0;
        char s1 = set1[k1];
        char s2 = set2[k2];
        while (true) {
            if (s2 < s1) {
                do {
                    if (++k2 != length2) continue;
                    return false;
                } while ((s2 = set2[k2]) < s1);
            }
            if (s1 >= s2) return true;
            do {
                if (++k1 != length1) continue;
                return false;
            } while ((s1 = set1[k1]) < s2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static int unsignedLocalIntersect2by2(char[] set1, int length1, char[] set2, int length2, char[] buffer) {
        if (0 == length1) return 0;
        if (0 == length2) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        char s1 = set1[k1];
        char s2 = set2[k2];
        while (true) {
            char v1;
            char v2;
            if ((v2 = s2) < (v1 = s1)) {
                do {
                    if (++k2 != length2) continue;
                    return pos;
                } while ((v2 = (s2 = set2[k2])) < v1);
            }
            if (v1 >= v2) {
                buffer[pos++] = s1;
                if (++k1 == length1) {
                    return pos;
                }
                if (++k2 == length2) {
                    return pos;
                }
                s1 = set1[k1];
                s2 = set2[k2];
                continue;
            }
            do {
                if (++k1 != length1) continue;
                return pos;
            } while ((v1 = (s1 = set1[k1])) < v2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int unsignedLocalIntersect2by2Cardinality(char[] set1, int length1, char[] set2, int length2) {
        if (0 == length1) return 0;
        if (0 == length2) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        char s1 = set1[k1];
        char s2 = set2[k2];
        while (true) {
            char v1;
            char v2;
            if ((v2 = s2) < (v1 = s1)) {
                do {
                    if (++k2 != length2) continue;
                    return pos;
                } while ((v2 = (s2 = set2[k2])) < v1);
            }
            if (v1 >= v2) {
                ++pos;
                if (++k1 == length1) {
                    return pos;
                }
                if (++k2 == length2) {
                    return pos;
                }
                s1 = set1[k1];
                s2 = set2[k2];
                continue;
            }
            do {
                if (++k1 != length1) continue;
                return pos;
            } while ((v1 = (s1 = set1[k1])) < v2);
        }
    }

    protected static int unsignedOneSidedGallopingIntersect2by2(char[] smallSet, int smallLength, char[] largeSet, int largeLength, char[] buffer) {
        if (0 == smallLength) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        char s1 = largeSet[k1];
        char s2 = smallSet[k2];
        while (true) {
            if (s1 < s2) {
                if ((k1 = Util.advanceUntil(largeSet, k1, largeLength, s2)) == largeLength) break;
                s1 = largeSet[k1];
            }
            if (s2 < s1) {
                if (++k2 == smallLength) break;
                s2 = smallSet[k2];
                continue;
            }
            buffer[pos++] = s2;
            if (++k2 == smallLength || (k1 = Util.advanceUntil(largeSet, k1, largeLength, s2 = smallSet[k2])) == largeLength) break;
            s1 = largeSet[k1];
        }
        return pos;
    }

    public static int unsignedUnion2by2(char[] set1, int offset1, int length1, char[] set2, int offset2, int length2, char[] buffer) {
        if (0 == length2) {
            System.arraycopy(set1, offset1, buffer, 0, length1);
            return length1;
        }
        if (0 == length1) {
            System.arraycopy(set2, offset2, buffer, 0, length2);
            return length2;
        }
        int pos = 0;
        int k1 = offset1;
        int k2 = offset2;
        char s1 = set1[k1];
        char s2 = set2[k2];
        while (true) {
            char v2;
            char v1;
            if ((v1 = s1) < (v2 = s2)) {
                buffer[pos++] = s1;
                if (++k1 >= length1 + offset1) {
                    System.arraycopy(set2, k2, buffer, pos, length2 - k2 + offset2);
                    return pos + length2 - k2 + offset2;
                }
                s1 = set1[k1];
                continue;
            }
            if (v1 == v2) {
                buffer[pos++] = s1;
                ++k2;
                if (++k1 >= length1 + offset1) {
                    System.arraycopy(set2, k2, buffer, pos, length2 - k2 + offset2);
                    return pos + length2 - k2 + offset2;
                }
                if (k2 >= length2 + offset2) {
                    System.arraycopy(set1, k1, buffer, pos, length1 - k1 + offset1);
                    return pos + length1 - k1 + offset1;
                }
                s1 = set1[k1];
                s2 = set2[k2];
                continue;
            }
            buffer[pos++] = s2;
            if (++k2 >= length2 + offset2) {
                System.arraycopy(set1, k1, buffer, pos, length1 - k1 + offset1);
                return pos + length1 - k1 + offset1;
            }
            s2 = set2[k2];
        }
    }

    public static long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static void partialRadixSort(int[] data) {
        boolean sortHigh;
        int[] low = new int[257];
        int[] high = new int[257];
        for (int value : data) {
            int n = (value >>> 16 & 0xFF) + 1;
            low[n] = low[n] + 1;
            int n2 = (value >>> 24) + 1;
            high[n2] = high[n2] + 1;
        }
        boolean sortLow = low[1] < data.length;
        boolean bl = sortHigh = high[1] < data.length;
        if (!sortLow && !sortHigh) {
            return;
        }
        int[] copy = new int[data.length];
        if (sortLow) {
            for (int i = 1; i < low.length; ++i) {
                int n = i;
                low[n] = low[n] + low[i - 1];
            }
            for (int value : data) {
                int n = value >>> 16 & 0xFF;
                int n3 = low[n];
                low[n] = n3 + 1;
                copy[n3] = value;
            }
        }
        if (sortHigh) {
            for (int i = 1; i < high.length; ++i) {
                int n = i;
                high[n] = high[n] + high[i - 1];
            }
            if (sortLow) {
                for (int value : copy) {
                    int n = value >>> 24;
                    int n4 = high[n];
                    high[n] = n4 + 1;
                    data[n4] = value;
                }
            } else {
                for (int value : data) {
                    int n = value >>> 24;
                    int n5 = high[n];
                    high[n] = n5 + 1;
                    copy[n5] = value;
                }
                System.arraycopy(copy, 0, data, 0, data.length);
            }
        } else {
            System.arraycopy(copy, 0, data, 0, data.length);
        }
    }

    private Util() {
    }
}

