/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.persistence;

import io.hops.hopsworks.persistence.entity.pki.CAType;
import io.hops.hopsworks.persistence.entity.pki.SerialNumber;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class SerialNumberFacade {
    private static final Logger LOGGER = Logger.getLogger(SerialNumberFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public void initialize(CAType type) {
        LOGGER.log(Level.INFO, "Initializing serial number for CA " + type);
        SerialNumber sn = new SerialNumber(type, Long.valueOf(0L));
        this.em.persist((Object)sn);
        this.em.flush();
    }

    public void initializeWithNumber(CAType type, Long number) {
        LOGGER.log(Level.INFO, "Initializing serial number for CA " + type + " with number " + number);
        SerialNumber sn = new SerialNumber(type, number);
        this.em.persist((Object)sn);
        this.em.flush();
    }

    public boolean isInitialized(CAType type) {
        try {
            this.em.createNamedQuery("SerialNumber.forCAType", SerialNumber.class).setParameter("type", (Object)type).getSingleResult();
            return true;
        }
        catch (NoResultException ex) {
            return false;
        }
    }

    public Long nextSerialNumber(CAType type) {
        TypedQuery query = this.em.createNamedQuery("SerialNumber.forCAType", SerialNumber.class).setParameter("type", (Object)type);
        SerialNumber sn = (SerialNumber)query.getSingleResult();
        Long current = sn.getNumber();
        sn.setNumber(Long.valueOf(current + 1L));
        LOGGER.log(Level.FINE, "Next serial number for CA " + type + " is " + sn.getNumber());
        this.em.merge((Object)sn);
        return current;
    }
}

