/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.controllers;

import com.google.common.base.Strings;
import io.hops.hopsworks.ca.configuration.CAConf;
import io.hops.hopsworks.ca.controllers.CACertificateNotFoundException;
import io.hops.hopsworks.ca.controllers.CAException;
import io.hops.hopsworks.ca.controllers.CAInitializationException;
import io.hops.hopsworks.ca.controllers.CertificateAlreadyExistsException;
import io.hops.hopsworks.ca.controllers.CertificateNotFoundException;
import io.hops.hopsworks.ca.controllers.CertificateType;
import io.hops.hopsworks.ca.controllers.CertificationRequestValidationException;
import io.hops.hopsworks.ca.controllers.PKIUtils;
import io.hops.hopsworks.ca.persistence.PKICertificateFacade;
import io.hops.hopsworks.persistence.entity.pki.CAType;
import io.hops.hopsworks.persistence.entity.pki.PKICertificate;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.naming.InvalidNameException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.RandomStringUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStrictStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

@Stateless
public class PKIUtils {
    @EJB
    private CAConf CAConf;
    @EJB
    private PKICertificateFacade pkiCertificateFacade;
    protected static final long TEN_YEARS = 3650L;
    private static final Map<String, ChronoUnit> TIME_SUFFIXES;
    private static final String CERTIFICATE_TYPE_NOT_RECOGNIZED_ERR = "Certificate type not recognized";
    private static final Pattern HOST_CERTIFICATE_SUBJECT;
    private static final Pattern APP_CERTIFICATE_SUBJECT;
    private static final Pattern TIME_CONF_PATTERN;
    private static final Base64 B64;
    private JcaPEMKeyConverter pemKeyConverter;
    private JcaX509CertificateConverter x509Converter;

    @PostConstruct
    public void init() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.pemKeyConverter = new JcaPEMKeyConverter().setProvider((Provider)new BouncyCastleProvider());
        this.x509Converter = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider());
    }

    public X500Name parseCertificateSubjectName(String subject, CertificateType certificateType) throws InvalidNameException {
        switch (1.$SwitchMap$io$hops$hopsworks$ca$controllers$CertificateType[certificateType.ordinal()]) {
            case 1: {
                return this.parseApplicationCertificateSubjectName(subject);
            }
            case 2: {
                return this.parseHostCertificateSubjectName(subject);
            }
        }
        return this.parseGenericCertificateSubjectName(subject);
    }

    public X500Name parseHostCertificateSubjectName(String subject) throws InvalidNameException {
        Matcher match = HOST_CERTIFICATE_SUBJECT.matcher(subject);
        if (match.matches()) {
            X500NameBuilder name = new X500NameBuilder(BCStrictStyle.INSTANCE);
            name.addRDN(BCStyle.CN, match.group("cn"));
            name.addRDN(BCStyle.L, match.group("l"));
            name.addRDN(BCStyle.OU, match.group("ou"));
            return name.build();
        }
        throw new InvalidNameException("Cannot parse Host certificate subject: " + subject);
    }

    public X500Name parseGenericCertificateSubjectName(String subject) throws InvalidNameException {
        if (Strings.isNullOrEmpty((String)subject)) {
            throw new InvalidNameException("Certificate subject cannot be null or empty");
        }
        X500NameBuilder name = new X500NameBuilder(BCStrictStyle.INSTANCE);
        name.addRDN(BCStyle.CN, subject);
        return name.build();
    }

    public X500Name parseApplicationCertificateSubjectName(String subject) throws InvalidNameException {
        Matcher match = APP_CERTIFICATE_SUBJECT.matcher(subject);
        if (match.matches()) {
            X500NameBuilder name = new X500NameBuilder(BCStrictStyle.INSTANCE);
            name.addRDN(BCStyle.CN, match.group("cn"));
            name.addRDN(BCStyle.O, match.group("o"));
            name.addRDN(BCStyle.OU, match.group("ou"));
            return name.build();
        }
        throw new InvalidNameException("Cannot parse Application certificate subject: " + subject);
    }

    public TemporalAmount getValidityPeriod(CertificateType type) {
        switch (1.$SwitchMap$io$hops$hopsworks$ca$controllers$CertificateType[type.ordinal()]) {
            case 1: {
                return this.getAppCertificateValidityPeriod();
            }
            case 2: {
                return this.getServiceCertificateValidityPeriod();
            }
            case 3: 
            case 4: {
                return Duration.ofSeconds(TimeUnit.SECONDS.convert(3650L, TimeUnit.DAYS));
            }
        }
        throw new IllegalArgumentException(CERTIFICATE_TYPE_NOT_RECOGNIZED_ERR);
    }

    private TemporalAmount getServiceCertificateValidityPeriod() {
        long validity = -1L;
        validity = this.CAConf.getBoolean(CAConf.CAConfKeys.SERVICE_KEY_ROTATION_ENABLED) == false ? TimeUnit.SECONDS.convert(3650L, TimeUnit.DAYS) : this.getCertificateValidityInS(this.CAConf.getString(CAConf.CAConfKeys.SERVICE_KEY_ROTATION_INTERVAL) + TimeUnit.SECONDS.convert(4L, TimeUnit.DAYS));
        return Duration.ofSeconds(validity);
    }

    private TemporalAmount getAppCertificateValidityPeriod() {
        long s = this.getCertificateValidityInS(this.CAConf.getString(CAConf.CAConfKeys.APPLICATION_CERTIFICATE_VALIDITY_PERIOD));
        return Duration.ofSeconds(s);
    }

    protected long getCertificateValidityInS(String rawConfigurationProperty) {
        Long timeValue = this.getConfTimeValue(rawConfigurationProperty);
        ChronoUnit unitValue = this.getConfTimeTimeUnit(rawConfigurationProperty);
        return Duration.of(timeValue, unitValue).getSeconds();
    }

    public CAType getResponsibleCA(CertificateType certType) {
        switch (1.$SwitchMap$io$hops$hopsworks$ca$controllers$CertificateType[certType.ordinal()]) {
            case 1: 
            case 2: 
            case 4: {
                return CAType.INTERMEDIATE;
            }
            case 3: {
                return CAType.KUBECA;
            }
        }
        throw new IllegalArgumentException(CERTIFICATE_TYPE_NOT_RECOGNIZED_ERR);
    }

    public List<String> findAllHostCertificateSubjectsForHost(String hostname) {
        return this.pkiCertificateFacade.findAllSubjectsWithStatusAndPartialSubject(String.format("CN=%s", hostname), PKICertificate.Status.VALID);
    }

    public List<String> findAllValidSubjectsWithPartialMatch(String partialSubject) {
        return this.pkiCertificateFacade.findAllSubjectsWithStatusAndPartialSubject(partialSubject, PKICertificate.Status.VALID);
    }

    public String convertToPEM(X509Extension certificate) throws IOException {
        try (StringWriter sw = new StringWriter();){
            JcaPEMWriter pw = new JcaPEMWriter((Writer)sw);
            JcaMiscPEMGenerator pog = new JcaMiscPEMGenerator((Object)certificate);
            pw.writeObject((PemObjectGenerator)pog.generate());
            pw.flush();
            sw.flush();
            pw.close();
            String string = sw.toString();
            return string;
        }
    }

    public CAException csrSigningExceptionConvertToCAException(Throwable e, CertificateType certType) {
        if (e instanceof CAInitializationException) {
            return new CAException(RESTCodes.CAErrorCode.CA_INITIALIZATION_ERROR, Level.SEVERE, certType, "Failed to initialize CA", "Failed to initialize CA", e.getCause());
        }
        if (e instanceof CertificateEncodingException) {
            return new CAException(RESTCodes.CAErrorCode.BADSIGNREQUEST, Level.FINE, certType, "Empty or malformed CSR", "Could not parse CSR to PKCS10CertificationRequest", e);
        }
        if (e instanceof CertificationRequestValidationException) {
            return new CAException(RESTCodes.CAErrorCode.BADSIGNREQUEST, Level.FINE, certType, e.getMessage(), e.getMessage(), e);
        }
        if (e instanceof KeyException || e instanceof SignatureException || e instanceof CACertificateNotFoundException) {
            return new CAException(RESTCodes.CAErrorCode.CSR_GENERIC_ERROR, Level.SEVERE, certType, "Generic PKI error", "Error while signing CSR. Check logs", e);
        }
        if (e instanceof CertificateAlreadyExistsException) {
            return new CAException(RESTCodes.CAErrorCode.CERTEXISTS, Level.FINE, certType, "Certificate with the same X.509 Subject name already exists", "Certificat with same Subject", e);
        }
        if (e instanceof NoSuchAlgorithmException || e instanceof CertIOException || e instanceof OperatorCreationException || e instanceof CertificateException) {
            return new CAException(RESTCodes.CAErrorCode.CSR_SIGNING_ERROR, Level.SEVERE, certType, "Failed to sign CSR", "Failed to sign CSR. Check logs", e);
        }
        return new CAException(RESTCodes.CAErrorCode.CSR_GENERIC_ERROR, Level.SEVERE, certType, "Unknown error while signing CSR", "Unknown error while signing CSR. Check logs", e);
    }

    public CAException certificateRevocationExceptionConvertToCAException(Throwable e, CertificateType certType) {
        if (e instanceof CAInitializationException) {
            return new CAException(RESTCodes.CAErrorCode.CA_INITIALIZATION_ERROR, Level.SEVERE, certType, "Failed to initialize CA", "Failed to initialize CA", e.getCause());
        }
        if (e instanceof InvalidNameException) {
            return new CAException(RESTCodes.CAErrorCode.BAD_SUBJECT_NAME, Level.FINE, CertificateType.APP, "Bad certificate identifier to revoke", e.getMessage(), e);
        }
        if (e instanceof CertificateNotFoundException) {
            return new CAException(RESTCodes.CAErrorCode.CERTNOTFOUND, Level.FINE, CertificateType.APP, e.getMessage(), e.getMessage(), e);
        }
        if (e instanceof CertificateException) {
            return new CAException(RESTCodes.CAErrorCode.CERTIFICATE_DECODING_ERROR, Level.FINE, CertificateType.APP, e.getMessage(), e.getMessage(), e);
        }
        if (e instanceof CRLException || e instanceof KeyException) {
            return new CAException(RESTCodes.CAErrorCode.CERTIFICATE_REVOCATION_FAILURE, Level.SEVERE, CertificateType.APP, "Failed to revoke certificate", e.getMessage(), e);
        }
        return new CAException(RESTCodes.CAErrorCode.CERTIFICATE_REVOCATION_FAILURE, Level.SEVERE, certType, "Unknown error while revoking certificate", e.getMessage(), e);
    }

    public CAException certificateLoadingExceptionConvertToCAException(Throwable e) {
        if (e instanceof CertificateNotFoundException) {
            return new CAException(RESTCodes.CAErrorCode.CERTNOTFOUND, Level.FINE, null, e.getMessage(), e.getMessage(), e);
        }
        if (e instanceof CertificateException) {
            return new CAException(RESTCodes.CAErrorCode.CERTIFICATE_DECODING_ERROR, Level.SEVERE, null, "Could not decode certificate", e.getMessage(), e);
        }
        return new CAException(RESTCodes.CAErrorCode.PKI_GENERIC_ERROR, Level.SEVERE, null, "Generic PKI error", e.getMessage(), e);
    }

    public Duration parseDuration(String duration) {
        return Duration.of(this.getConfTimeValue(duration), this.getConfTimeTimeUnit(duration));
    }

    private Long getConfTimeValue(String configurationTime) {
        Matcher matcher = TIME_CONF_PATTERN.matcher(configurationTime.toLowerCase());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid time in configuration: " + configurationTime);
        }
        return Long.parseLong(matcher.group(1));
    }

    private ChronoUnit getConfTimeTimeUnit(String configurationTime) {
        Matcher matcher = TIME_CONF_PATTERN.matcher(configurationTime.toLowerCase());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid time in configuration: " + configurationTime);
        }
        String timeUnitStr = matcher.group(2);
        if (null != timeUnitStr && !TIME_SUFFIXES.containsKey(timeUnitStr.toLowerCase())) {
            throw new IllegalArgumentException("Invalid time suffix in configuration: " + configurationTime);
        }
        return timeUnitStr == null ? ChronoUnit.MINUTES : (ChronoUnit)TIME_SUFFIXES.get(timeUnitStr.toLowerCase());
    }

    public KeyPair loadKeyPair(String privateKey, String password) throws IOException {
        return this.loadKeyPair((Reader)new StringReader(privateKey), password);
    }

    public KeyPair loadKeyPair(Path path, String password) throws IOException {
        return this.loadKeyPair((Reader)new FileReader(path.toFile()), password);
    }

    private KeyPair loadKeyPair(Reader reader, String password) throws IOException {
        try (PEMParser pemParser = new PEMParser(reader);){
            KeyPair kp;
            Object object = pemParser.readObject();
            if (object instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair ekp = (PEMEncryptedKeyPair)object;
                PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
                kp = this.pemKeyConverter.getKeyPair(ekp.decryptKeyPair(decryptorProvider));
            } else if (object instanceof PEMKeyPair) {
                PEMKeyPair ukp = (PEMKeyPair)object;
                kp = this.pemKeyConverter.getKeyPair(ukp);
            } else if (object instanceof PrivateKeyInfo) {
                PrivateKey privateKey = this.pemKeyConverter.getPrivateKey((PrivateKeyInfo)object);
                kp = new KeyPair(null, privateKey);
            } else {
                throw new UnsupportedEncodingException("Unsupported keypair encoding");
            }
            KeyPair keyPair = kp;
            return keyPair;
        }
    }

    public X509Certificate loadCertificate(Path path) throws IOException, CertificateException {
        return this.loadCertificate((Reader)new FileReader(path.toFile()));
    }

    public X509Certificate loadCertificate(String certificate) throws IOException, CertificateException {
        return this.loadCertificate((Reader)new StringReader(certificate));
    }

    private X509Certificate loadCertificate(Reader reader) throws IOException, CertificateException {
        try (PEMParser pemParser = new PEMParser(reader);){
            Object object = pemParser.readObject();
            if (object instanceof X509CertificateHolder) {
                X509Certificate x509Certificate = this.x509Converter.getCertificate((X509CertificateHolder)object);
                return x509Certificate;
            }
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
    }

    /*
     * Exception decompiling
     */
    public KeyStores<String> createB64Keystores(String privateKey, X509Certificate certificate, X509Certificate issuer, X509Certificate root) throws GeneralSecurityException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public char[] createKeystores(String privateKey, X509Certificate certificate, X509Certificate issuer, X509Certificate root, OutputStream keyStore, OutputStream trustStore) throws GeneralSecurityException, IOException {
        PrivateKey key = this.loadKeyPair((Reader)new StringReader(privateKey), "").getPrivate();
        char[] password = RandomStringUtils.randomAlphanumeric((int)15, (int)20).toCharArray();
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        Certificate[] chain = new X509Certificate[]{certificate, issuer};
        ks.setKeyEntry("own", key, password, chain);
        ks.store(keyStore, password);
        KeyStore ts = KeyStore.getInstance("JKS");
        ts.load(null, null);
        ts.setCertificateEntry("hw_root_ca", root);
        ts.store(trustStore, password);
        keyStore.flush();
        trustStore.flush();
        return password;
    }

    static {
        HOST_CERTIFICATE_SUBJECT = Pattern.compile("^(?<cn>.+)__(?<l>.+)__(?<ou>\\d+)$");
        APP_CERTIFICATE_SUBJECT = Pattern.compile("^(?<cn>.+)__(?<o>app.+)__(?<ou>\\d+)$");
        TIME_SUFFIXES = new HashMap(5);
        TIME_SUFFIXES.put("s", ChronoUnit.SECONDS);
        TIME_SUFFIXES.put("m", ChronoUnit.MINUTES);
        TIME_SUFFIXES.put("h", ChronoUnit.HOURS);
        TIME_SUFFIXES.put("d", ChronoUnit.DAYS);
        TIME_CONF_PATTERN = Pattern.compile("([0-9]+)([a-z]+)?");
        B64 = new Base64();
    }
}

