/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.controllers;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.lock.FencedLock;
import io.hops.hadoop.shaded.com.google.gson.Gson;
import io.hops.hopsworks.ca.configuration.CAConf;
import io.hops.hopsworks.ca.configuration.CAConfiguration;
import io.hops.hopsworks.ca.configuration.CAsConfiguration;
import io.hops.hopsworks.ca.configuration.KubeCAConfiguration;
import io.hops.hopsworks.ca.configuration.SubjectAlternativeName;
import io.hops.hopsworks.ca.configuration.UsernamesConfiguration;
import io.hops.hopsworks.ca.controllers.CACertificateNotFoundException;
import io.hops.hopsworks.ca.controllers.CAInitializationException;
import io.hops.hopsworks.ca.controllers.CertificateAlreadyExistsException;
import io.hops.hopsworks.ca.controllers.CertificateNotFoundException;
import io.hops.hopsworks.ca.controllers.CertificateType;
import io.hops.hopsworks.ca.controllers.CertificationRequestValidationException;
import io.hops.hopsworks.ca.controllers.PKI;
import io.hops.hopsworks.ca.controllers.PKIUtils;
import io.hops.hopsworks.ca.persistence.CRLFacade;
import io.hops.hopsworks.ca.persistence.KeyFacade;
import io.hops.hopsworks.ca.persistence.PKICertificateFacade;
import io.hops.hopsworks.ca.persistence.SerialNumberFacade;
import io.hops.hopsworks.persistence.entity.pki.CAType;
import io.hops.hopsworks.persistence.entity.pki.KeyIdentifier;
import io.hops.hopsworks.persistence.entity.pki.PKICertificate;
import io.hops.hopsworks.persistence.entity.pki.PKICertificateId;
import io.hops.hopsworks.persistence.entity.pki.PKICrl;
import io.hops.hopsworks.persistence.entity.pki.PKIKey;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.Utilities;
import io.hops.hopsworks.servicediscovery.tags.MysqlTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.naming.InvalidNameException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStrictStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v2CRLBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
@DependsOn(value={"CAConf"})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class PKI {
    private static final Logger LOGGER = Logger.getLogger(PKI.class.getName());
    private final RSAKeyGenParameterSpec keyGenSpecs = new RSAKeyGenParameterSpec(4096, RSAKeyGenParameterSpec.F4);
    private final Map<CAType, KeyPair> caKeys = new HashMap(3);
    private final Map<CAType, X509Certificate> caCertificates = new HashMap(3);
    public static final String SIGNATURE_ALGORITHM = "SHA256WithRSAEncryption";
    private static final CRLReason REVOCATION_REASON = CRLReason.lookup((int)9);
    private final AtomicBoolean CA_INITIALIZED = new AtomicBoolean(false);
    private static final GeneralName[] EMTPY_GENERAL_NAMES = new GeneralName[0];
    @EJB
    private SerialNumberFacade serialNumberFacade;
    @EJB
    private KeyFacade keyFacade;
    @EJB
    private PKICertificateFacade pkiCertificateFacade;
    @EJB
    private PKIUtils pkiUtils;
    @EJB
    private CRLFacade crlFacade;
    @EJB
    private CAConf caConf;
    @EJB
    private UsernamesConfiguration usernamesConfiguration;
    @Inject
    private HazelcastInstance hazelcastInstance;
    private KeyPairGenerator keyPairGenerator;
    private KeyFactory keyFactory;
    private JcaX509CertificateConverter converter;
    private JcaX509CRLConverter crlConverter;
    private CAsConfiguration conf;
    private static final Map<CAType, X500Name> CA_SUBJECT_NAME = new HashMap(3);
    private static final String CA_INIT_LOCK = "caInitLock";
    protected static final CAsConfiguration EMPTY_CONFIGURATION;
    private final Duration ROOT_CA_DEFAULT_VALIDITY_PERIOD = Duration.of(3650L, ChronoUnit.DAYS);
    private final Duration INTERMEDIATE_CA_DEFAULT_VALIDITY_PERIOD = Duration.of(3650L, ChronoUnit.DAYS);
    private final Duration KUBERNETES_CA_DEFAULT_VALIDITY_PERIOD = Duration.of(3650L, ChronoUnit.DAYS);
    protected static final Function<ExtensionsBuilderParameter, Void> EMPTY_CERTIFICATE_EXTENSIONS_BUILDER;
    protected final Function<ExtensionsBuilderParameter, Void> KUBE_CERTIFICATE_EXTENSIONS_BUILDER = b -> {
        Optional locality;
        KubeCAConfiguration kubeCAConf;
        if (this.conf.getKubernetesCA().isPresent() && (kubeCAConf = (KubeCAConfiguration)this.conf.getKubernetesCA().get()).getSubjectAlternativeName().isPresent()) {
            List ips;
            List dns;
            SubjectAlternativeName san = (SubjectAlternativeName)kubeCAConf.getSubjectAlternativeName().get();
            ArrayList<GeneralName> generalNames = null;
            if (san.getDns().isPresent() && !(dns = (List)san.getDns().get()).isEmpty()) {
                generalNames = new ArrayList<GeneralName>();
                for (String s : dns) {
                    generalNames.add(new GeneralName(2, s));
                }
            }
            if (san.getIp().isPresent() && !(ips = (List)san.getIp().get()).isEmpty()) {
                if (generalNames == null) {
                    generalNames = new ArrayList();
                }
                for (String s : ips) {
                    generalNames.add(new GeneralName(7, s));
                }
            }
            if (generalNames != null) {
                try {
                    GeneralName[] gn = generalNames.toArray(new GeneralName[0]);
                    this.appendSubjectAlternativeNames(ExtensionsBuilderParameter.access$1200((ExtensionsBuilderParameter)b), gn);
                }
                catch (CertIOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if ((locality = this.parseX509Locality(ExtensionsBuilderParameter.access$1100((ExtensionsBuilderParameter)b))).isPresent() && ((String)locality.get()).equals("strimzica")) {
            try {
                ExtensionsBuilderParameter.access$1200((ExtensionsBuilderParameter)b).replaceExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(3));
                ExtensionsBuilderParameter.access$1200((ExtensionsBuilderParameter)b).replaceExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(180));
            }
            catch (CertIOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    };
    protected final Function<ExtensionsBuilderParameter, Void> SAN_CERTIFICATE_EXTENSIONS_BUILDER = b -> {
        if (ExtensionsBuilderParameter.access$1000((ExtensionsBuilderParameter)b).equals((Object)CertificateType.HOST)) {
            Optional cn = this.parseX509CommonName(ExtensionsBuilderParameter.access$1100((ExtensionsBuilderParameter)b));
            if (!cn.isPresent()) {
                throw new RuntimeException("x509 subject " + ExtensionsBuilderParameter.access$1100((ExtensionsBuilderParameter)b).getSubject().toString() + " does not have CN field");
            }
            GeneralName hostname = new GeneralName(2, (String)cn.get());
            GeneralName[] names = new GeneralName[]{hostname};
            try {
                this.appendSubjectAlternativeNames(ExtensionsBuilderParameter.access$1200((ExtensionsBuilderParameter)b), names);
                Optional l = this.parseX509Locality(ExtensionsBuilderParameter.access$1100((ExtensionsBuilderParameter)b));
                if (l.isPresent()) {
                    GeneralName[] sanForUsername = this.getSanForUsername((String)l.get(), ExtensionsBuilderParameter.access$1300((ExtensionsBuilderParameter)b));
                    this.appendSubjectAlternativeNames(ExtensionsBuilderParameter.access$1200((ExtensionsBuilderParameter)b), sanForUsername);
                    HashSet extraSanSet = new HashSet();
                    this.conf.getIntermediateCA().ifPresent(c -> {
                        SubjectAlternativeName extraSan;
                        if (c.getExtraUsernameSAN() != null && (extraSan = (SubjectAlternativeName)c.getExtraUsernameSAN().get(l.get())) != null) {
                            extraSan.getDns().ifPresent(extraSanSet::addAll);
                        }
                    });
                    if (!extraSanSet.isEmpty()) {
                        this.appendSubjectAlternativeNames(ExtensionsBuilderParameter.access$1200((ExtensionsBuilderParameter)b), this.convertToGeneralNames(extraSanSet, false, null));
                    }
                }
            }
            catch (CertIOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    };
    private final Function<ExtensionsBuilderParameter, Void>[] HOST_CERTIFICATES_EXTENSION_BUILDERS = new Function[]{this.SAN_CERTIFICATE_EXTENSIONS_BUILDER};
    private final Function<ExtensionsBuilderParameter, Void>[] KUBERNETES_CERTIFICATES_EXTENSION_BUILDERS = new Function[]{this.KUBE_CERTIFICATE_EXTENSIONS_BUILDER, this.SAN_CERTIFICATE_EXTENSIONS_BUILDER};
    private final Function<ExtensionsBuilderParameter, Void>[] EMTPY_CERTIFICATES_EXTENSION_BUILDERS = new Function[0];
    private static final Function<X509v3CertificateBuilder, Void> INTERMEDIATE_EXTENSIONS;

    @PostConstruct
    public void init() {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Provider[] providers = Security.getProviders();
            this.keyPairGenerator = KeyPairGenerator.getInstance("RSA", (Provider)new BouncyCastleProvider());
            this.keyPairGenerator.initialize(this.keyGenSpecs);
            this.keyFactory = KeyFactory.getInstance("RSA");
            this.converter = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider());
            this.crlConverter = new JcaX509CRLConverter().setProvider((Provider)new BouncyCastleProvider());
            this.configure();
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException("Failed to initialize PKI", ex);
        }
    }

    private FencedLock getLock() {
        if (this.hazelcastInstance != null && this.hazelcastInstance.getCluster().getMembers().size() > 1) {
            return this.hazelcastInstance.getCPSubsystem().getLock("caInitLock");
        }
        return null;
    }

    public void configure() {
        this.conf = this.loadConfiguration();
        this.overrideCAX500Names(this.conf);
    }

    protected CAsConfiguration loadConfiguration() {
        String rawConf = this.caConf.getString(CAConf.CAConfKeys.CA_CONFIGURATION);
        if (rawConf.isEmpty()) {
            return EMPTY_CONFIGURATION;
        }
        Gson gson = new Gson();
        return (CAsConfiguration)gson.fromJson(rawConf, CAsConfiguration.class);
    }

    protected void overrideCAX500Names(CAsConfiguration conf) {
        conf.getRootCA().flatMap(CAConfiguration::getX509Name).ifPresent(v -> CA_SUBJECT_NAME.put(CAType.ROOT, new X500Name(BCStyle.INSTANCE, v)));
        conf.getIntermediateCA().flatMap(CAConfiguration::getX509Name).ifPresent(v -> CA_SUBJECT_NAME.put(CAType.INTERMEDIATE, new X500Name(BCStyle.INSTANCE, v)));
        conf.getKubernetesCA().flatMap(CAConfiguration::getX509Name).ifPresent(v -> CA_SUBJECT_NAME.put(CAType.KUBECA, new X500Name(BCStyle.INSTANCE, v)));
    }

    protected void maybeInitializeCA() throws GeneralSecurityException, IOException, OperatorCreationException {
        if (!this.CA_INITIALIZED.getAndSet(true)) {
            FencedLock lock = this.getLock();
            if (lock == null || lock.tryLock(3L, TimeUnit.MINUTES)) {
                try {
                    LOGGER.log(Level.INFO, "Initializing CAs");
                    this.initializeCertificateAuthorities();
                }
                catch (Exception ex) {
                    this.CA_INITIALIZED.set(false);
                    LOGGER.log(Level.SEVERE, "Error initializing CAs", ex);
                    throw ex;
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            } else {
                this.CA_INITIALIZED.set(false);
                LOGGER.log(Level.WARNING, "Timed out waiting for lock to initializing CAs");
            }
        } else {
            LOGGER.log(Level.FINE, "CAs already initialized");
        }
    }

    public Pair<String, String> getChainOfTrust(CAType type) throws CAInitializationException, IOException, GeneralSecurityException {
        try {
            this.maybeInitializeCA();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to initialize CA", ex);
            throw new CAInitializationException((Throwable)ex);
        }
        String intermediateCert = null;
        if (type != CAType.ROOT) {
            intermediateCert = this.pkiUtils.convertToPEM((X509Extension)this.caCertificates.get(type));
        }
        String rootCert = this.pkiUtils.convertToPEM((X509Extension)this.caCertificates.get(CAType.ROOT));
        return Pair.of((Object)rootCert, (Object)intermediateCert);
    }

    public String getCertificateRevocationListPEM(CAType type) throws CAInitializationException, GeneralSecurityException, IOException {
        try {
            this.maybeInitializeCA();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to initialize CA", ex);
            throw new CAInitializationException((Throwable)ex);
        }
        X509CRL crl = this.loadCRL(type);
        return this.pkiUtils.convertToPEM((X509Extension)crl);
    }

    protected void initializeCertificateAuthorities() throws GeneralSecurityException, IOException, OperatorCreationException {
        for (CAType ca : CAType.values()) {
            if (ca.equals((Object)CAType.KUBECA) && (!this.caConf.getBoolean(CAConf.CAConfKeys.KUBERNETES).booleanValue() || !this.caConf.getString(CAConf.CAConfKeys.KUBERNETES_TYPE).equals("local"))) continue;
            this.initializeCertificateAuthority(ca);
        }
    }

    private void initializeCertificateAuthority(CAType caType) throws IOException, GeneralSecurityException, OperatorCreationException {
        this.caInitializeSerialNumber(caType);
        this.caInitializeKeys(caType);
        this.caInitializeCertificate(caType);
        this.caInitializeCRL(caType);
    }

    protected void caInitializeSerialNumber(CAType type) throws IOException {
        if (!this.serialNumberFacade.isInitialized(type)) {
            if (this.loadFromFile()) {
                LOGGER.log(Level.INFO, "Loading serial number from file for: " + type);
                try {
                    Path path = this.getPathToSerialNumber(type);
                    this.migrateSerialNumber(type, path);
                    return;
                }
                catch (FileNotFoundException ex) {
                    throw new IOException("Bootstrapping serial number of " + type + " but openssl file could not be found", ex);
                }
            }
            this.serialNumberFacade.initialize(type);
        }
    }

    @VisibleForTesting
    protected Path getPathToSerialNumber(CAType type) throws FileNotFoundException {
        Path path;
        switch (1.$SwitchMap$io$hops$hopsworks$persistence$entity$pki$CAType[type.ordinal()]) {
            case 1: {
                path = Paths.get(this.caConf.getString(CAConf.CAConfKeys.CERTS_DIR), "serial");
                break;
            }
            case 2: {
                path = Paths.get(this.caConf.getString(CAConf.CAConfKeys.CERTS_DIR), "intermediate/serial");
                break;
            }
            case 3: {
                path = Paths.get(this.caConf.getString(CAConf.CAConfKeys.CERTS_DIR), "kube/serial");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CA type: " + type);
            }
        }
        if (!path.toFile().exists()) {
            throw new FileNotFoundException("File " + path.toFile() + " does not exist");
        }
        return path;
    }

    @VisibleForTesting
    protected void migrateSerialNumber(CAType type, Path path) throws IOException {
        Long sn = this.getSerialNumber(path);
        this.serialNumberFacade.initializeWithNumber(type, sn);
        LOGGER.log(Level.INFO, "Migrated Serial Number for " + type + " with next number " + sn);
    }

    private Long getSerialNumber(Path path) throws IOException {
        String hex = FileUtils.readFileToString((File)path.toFile(), (Charset)Charset.defaultCharset());
        return Long.parseUnsignedLong(hex.trim(), 16);
    }

    @VisibleForTesting
    protected boolean loadFromFile() {
        return Paths.get(this.caConf.getString(CAConf.CAConfKeys.CERTS_DIR), "private/ca.key.pem").toFile().exists();
    }

    protected void caInitializeKeys(CAType type) throws InvalidKeySpecException, IOException {
        Pair kp = this.loadOrGenerateKeypair(type.name());
        if (!((Boolean)kp.getLeft()).booleanValue()) {
            LOGGER.log(Level.INFO, "Saving key pair for " + type.name());
            PKIKey privateKey = new PKIKey(new KeyIdentifier(type.name(), PKIKey.Type.PRIVATE), ((KeyPair)kp.getRight()).getPrivate().getEncoded());
            PKIKey publicKey = new PKIKey(new KeyIdentifier(type.name(), PKIKey.Type.PUBLIC), ((KeyPair)kp.getRight()).getPublic().getEncoded());
            this.saveKeys(privateKey, publicKey);
        }
        this.caKeys.put(type, kp.getRight());
    }

    protected void caInitializeCertificate(CAType type) throws IOException, GeneralSecurityException, OperatorCreationException {
        Pair certificatePair = this.loadOrGenerateCACertificate(type);
        X509Certificate certificate = (X509Certificate)certificatePair.getRight();
        if (!((Boolean)certificatePair.getLeft()).booleanValue()) {
            LOGGER.log(Level.INFO, "Saving certificate for " + type);
            this.saveNewCertificate(CAType.ROOT, certificate);
        }
        this.caCertificates.put(type, certificate);
    }

    protected void caInitializeCRL(CAType type) throws GeneralSecurityException, CertIOException, IOException {
        LOGGER.log(Level.INFO, "Initializing Certificate Revocation List for " + type);
        if (this.crlFacade.exist(type)) {
            LOGGER.log(Level.INFO, "Skip CRL initialization for " + type + " as it already exists");
            return;
        }
        if (this.loadFromFile() && type.equals((Object)CAType.INTERMEDIATE)) {
            LOGGER.log(Level.INFO, "Loading CRL of " + type + " from file");
            X509CRL crl = this.loadCRL(Paths.get(this.caConf.getString(CAConf.CAConfKeys.CERTS_DIR), "intermediate/crl/intermediate.crl.pem"));
            if (crl != null) {
                this.initCRL(type, crl);
                return;
            }
            LOGGER.log(Level.WARNING, "CRL loaded from file for " + type + " is empty, continue generating new one");
        }
        KeyPair keyPair = this.getCAKeyPair(type);
        X509Certificate certificate = this.getCACertificate(type);
        Instant now = Instant.now();
        LOGGER.log(Level.INFO, "Generating initial CRL for " + type);
        JcaX509v2CRLBuilder builder = new JcaX509v2CRLBuilder(certificate, Date.from(now));
        Instant nextUpdate = now.plus(1L, ChronoUnit.DAYS);
        builder.setNextUpdate(Date.from(nextUpdate));
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(certificate));
        try {
            ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider((Provider)new BouncyCastleProvider()).build(keyPair.getPrivate());
            X509CRLHolder holder = builder.build(signer);
            X509CRL crl = this.crlConverter.getCRL(holder);
            this.initCRL(type, crl);
            LOGGER.log(Level.INFO, "Finished initializing CRL for " + type);
        }
        catch (OperatorCreationException ex) {
            throw new GeneralSecurityException(ex);
        }
    }

    protected void initCRL(CAType type, X509CRL crl) throws CRLException {
        PKICrl pkiCrl = new PKICrl(type, crl.getEncoded());
        this.crlFacade.init(pkiCrl);
    }

    protected void updateCRL(CAType type, X509CRL crl) throws CRLException {
        PKICrl pkiCrl = new PKICrl(type, crl.getEncoded());
        this.crlFacade.update(pkiCrl);
    }

    protected void saveNewCertificate(CAType caType, X509Certificate certificate) throws CertificateEncodingException {
        Long serialNumber = certificate.getSerialNumber().longValue();
        String subject = certificate.getSubjectDN().toString();
        byte[] certEncoded = certificate.getEncoded();
        PKICertificateId id = new PKICertificateId(PKICertificate.Status.VALID, subject);
        PKICertificate certificateToSave = new PKICertificate(id, caType, serialNumber, certEncoded, certificate.getNotBefore(), certificate.getNotAfter());
        this.pkiCertificateFacade.saveCertificate(certificateToSave);
    }

    protected Pair<Boolean, KeyPair> loadOrGenerateKeypair(String owner) throws InvalidKeySpecException, IOException {
        LOGGER.log(Level.INFO, "Loading key pair for " + owner);
        Optional kp = this.loadKeyPair(owner);
        if (kp.isPresent()) {
            LOGGER.log(Level.INFO, "Loaded key pair for " + owner);
            return Pair.of((Object)true, kp.get());
        }
        if (this.loadFromFile()) {
            LOGGER.log(Level.INFO, "Key pair for " + owner + " does NOT exist but will load from file");
            try {
                return Pair.of((Object)false, (Object)this.loadKeyPairFromFile(owner));
            }
            catch (FileNotFoundException ex) {
                throw new InvalidKeySpecException("Bootstrapping private key of " + owner + " but openssl file could not be found", ex);
            }
        }
        LOGGER.log(Level.INFO, "Key pair for " + owner + " does NOT exist, generating new");
        return Pair.of((Object)false, (Object)this.generateKeyPair());
    }

    protected KeyPair loadKeyPairFromFile(String owner) throws IOException {
        Path keyPath = this.getPathToPrivateKey(owner);
        return this.pkiUtils.loadKeyPair(keyPath, this.getPrivateFileKeyPassword(owner));
    }

    private String getPrivateFileKeyPassword(String owner) {
        if (owner.toUpperCase().equals(CAType.KUBECA.toString())) {
            return this.caConf.getString(CAConf.CAConfKeys.KUBE_CA_PASSWORD);
        }
        return this.caConf.getString(CAConf.CAConfKeys.HOPSWORKS_SSL_MASTER_PASSWORD);
    }

    private Path getPathToPrivateKey(String owner) throws FileNotFoundException {
        Path path;
        switch (1.$SwitchMap$io$hops$hopsworks$persistence$entity$pki$CAType[CAType.valueOf((String)owner).ordinal()]) {
            case 1: {
                path = Paths.get(this.caConf.getString(CAConf.CAConfKeys.CERTS_DIR), "private/ca.key.pem");
                break;
            }
            case 2: {
                path = Paths.get(this.caConf.getString(CAConf.CAConfKeys.CERTS_DIR), "intermediate/private/intermediate.key.pem");
                break;
            }
            case 3: {
                path = Paths.get(this.caConf.getString(CAConf.CAConfKeys.CERTS_DIR), "kube/private/kube-ca.key.pem");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown private key owner: " + owner);
            }
        }
        if (!path.toFile().exists()) {
            throw new FileNotFoundException("File " + path.toFile() + " does not exist");
        }
        return path;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    protected KeyPair generateKeyPair() {
        return this.keyPairGenerator.generateKeyPair();
    }

    protected Optional<KeyPair> loadKeyPair(String owner) throws InvalidKeySpecException {
        byte[] privateKey = this.keyFacade.getEncodedKey(owner, PKIKey.Type.PRIVATE);
        if (privateKey != null) {
            byte[] publicKey = this.keyFacade.getEncodedKey(owner, PKIKey.Type.PUBLIC);
            return Optional.of(this.restoreKeypair(privateKey, publicKey));
        }
        return Optional.empty();
    }

    protected void saveKeys(PKIKey privateKey, PKIKey publicKey) {
        this.keyFacade.saveKey(privateKey);
        this.keyFacade.saveKey(publicKey);
        LOGGER.log(Level.INFO, "Saved keys");
    }

    private KeyPair restoreKeypair(byte[] privateKey, byte[] publicKey) throws InvalidKeySpecException {
        PrivateKey prK = this.keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKey));
        PublicKey puK = this.keyFactory.generatePublic(new X509EncodedKeySpec(publicKey));
        return new KeyPair(puK, prK);
    }

    protected Pair<Boolean, X509Certificate> loadOrGenerateCACertificate(CAType type) throws IOException, CertificateException, NoSuchAlgorithmException, CertificateException, KeyException, OperatorCreationException {
        LOGGER.log(Level.INFO, "Loading certificate for " + type);
        X500Name name = (X500Name)CA_SUBJECT_NAME.get(type);
        Optional cert = this.loadCertificate(name.toString());
        if (cert.isPresent()) {
            LOGGER.log(Level.INFO, "Loaded ROOT CA certificate");
            return Pair.of((Object)true, cert.get());
        }
        if (this.loadFromFile()) {
            LOGGER.log(Level.INFO, "Loading certificate of " + type + " CA from file");
            try {
                return Pair.of((Object)false, (Object)this.loadCACertificate(type));
            }
            catch (FileNotFoundException ex) {
                throw new CertificateException("Bootstrapping certificate of " + type + " CA but openssl file could not be found", ex);
            }
        }
        switch (1.$SwitchMap$io$hops$hopsworks$persistence$entity$pki$CAType[type.ordinal()]) {
            case 1: {
                LOGGER.log(Level.INFO, "Root CA certificate does not exist, generating...");
                return Pair.of((Object)false, (Object)this.generateRootCACertificate());
            }
            case 2: {
                LOGGER.log(Level.INFO, "Intermediate CA certificate does not exist, generating...");
                return Pair.of((Object)false, (Object)this.generateCertificate(this.prepareIntermediateCAGenerationParams()));
            }
            case 3: {
                LOGGER.log(Level.INFO, "Kubernetes CA certificate does not exist, generating...");
                return Pair.of((Object)false, (Object)this.generateCertificate(this.prepareKubernetesCAGenerationParams()));
            }
        }
        throw new RuntimeException("Unknown CA type " + type);
    }

    @VisibleForTesting
    protected X509Certificate loadCACertificate(CAType type) throws IOException, CertificateException {
        Path certPath = this.getCACertificatePath(type);
        return this.pkiUtils.loadCertificate(certPath);
    }

    private Path getCACertificatePath(CAType type) throws FileNotFoundException {
        Path path;
        switch (1.$SwitchMap$io$hops$hopsworks$persistence$entity$pki$CAType[type.ordinal()]) {
            case 1: {
                path = Paths.get(this.caConf.getString(CAConf.CAConfKeys.CERTS_DIR), "certs/ca.cert.pem");
                break;
            }
            case 2: {
                path = Paths.get(this.caConf.getString(CAConf.CAConfKeys.CERTS_DIR), "intermediate/certs/intermediate.cert.pem");
                break;
            }
            case 3: {
                path = Paths.get(this.caConf.getString(CAConf.CAConfKeys.CERTS_DIR), "kube/certs/kube-ca.cert.pem");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CA type: " + type);
            }
        }
        if (!path.toFile().exists()) {
            throw new FileNotFoundException("File " + path.toFile() + " does not exist");
        }
        return path;
    }

    protected Optional<X509Certificate> loadCertificate(String subject) throws IOException, CertificateException {
        LOGGER.log(Level.INFO, "Loading certificate with subject " + subject);
        Optional pkiCert = this.pkiCertificateFacade.findBySubjectAndStatus(subject, PKICertificate.Status.VALID);
        if (!pkiCert.isPresent()) {
            LOGGER.log(Level.INFO, "There is no certificate with subject: " + subject);
            return Optional.empty();
        }
        LOGGER.log(Level.INFO, "Found encoded certificate and decoding it to " + X509Certificate.class.getName());
        byte[] encoded = ((PKICertificate)pkiCert.get()).getCertificate();
        X509Certificate certificate = this.converter.getCertificate(new X509CertificateHolder(encoded));
        return Optional.of(certificate);
    }

    private Duration getCAValidityPeriod(Optional<? extends CAConfiguration> conf, Duration defaultDuration) {
        if (conf.isPresent() && conf.get().getValidityDuration().isPresent()) {
            return this.pkiUtils.parseDuration((String)conf.get().getValidityDuration().get());
        }
        return defaultDuration;
    }

    protected X509Certificate generateRootCACertificate() throws KeyException, NoSuchAlgorithmException, CertificateException, CertIOException, OperatorCreationException {
        KeyPair keyPair = (KeyPair)this.caKeys.get(CAType.ROOT);
        if (keyPair == null) {
            String msg = "Could not find Root CA key pair in cache. Have you initialized?";
            LOGGER.log(Level.SEVERE, msg);
            throw new KeyException(msg);
        }
        Long sn = this.serialNumberFacade.nextSerialNumber(CAType.ROOT);
        Duration validityPeriod = this.getCAValidityPeriod(this.conf.getRootCA(), this.ROOT_CA_DEFAULT_VALIDITY_PERIOD);
        Instant notBefore = Instant.now().minus(3L, ChronoUnit.MINUTES);
        Instant notAfter = notBefore.plus(validityPeriod);
        X500Name name = (X500Name)CA_SUBJECT_NAME.get(CAType.ROOT);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(name, BigInteger.valueOf(sn), Date.from(notBefore), Date.from(notAfter), name, keyPair.getPublic());
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        SubjectKeyIdentifier subjectKeyIdentifier = extUtils.createSubjectKeyIdentifier(keyPair.getPublic());
        AuthorityKeyIdentifier authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(keyPair.getPublic());
        builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(10)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134)).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)subjectKeyIdentifier).addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)authorityKeyIdentifier);
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider((Provider)new BouncyCastleProvider()).build(keyPair.getPrivate());
        X509CertificateHolder holder = builder.build(signer);
        X509Certificate certificate = this.converter.getCertificate(holder);
        LOGGER.log(Level.INFO, "Generated ROOT CA certificate");
        return certificate;
    }

    protected CertificateGenerationParameters prepareIntermediateCAGenerationParams() throws KeyException, CertificateException {
        KeyPair rootCAKeypair = this.getCAKeyPair(CAType.ROOT);
        X509Certificate rootCACert = this.getCACertificate(CAType.ROOT);
        CertificateSigner signer = new CertificateSigner(rootCAKeypair, rootCACert);
        KeyPair intermediateKeypair = this.getCAKeyPair(CAType.INTERMEDIATE);
        Long serialNumber = this.serialNumberFacade.nextSerialNumber(CAType.ROOT);
        X500Name name = (X500Name)CA_SUBJECT_NAME.get(CAType.INTERMEDIATE);
        Duration validityDuration = this.getCAValidityPeriod(this.conf.getIntermediateCA(), this.INTERMEDIATE_CA_DEFAULT_VALIDITY_PERIOD);
        Instant notBefore = Instant.now().minus(3L, ChronoUnit.MINUTES);
        Instant notAfter = notBefore.plus(validityDuration);
        CertificateValidityPeriod validityPeriod = new CertificateValidityPeriod(notBefore, notAfter);
        return new CertificateGenerationParameters(signer, intermediateKeypair, serialNumber, name, validityPeriod, INTERMEDIATE_EXTENSIONS);
    }

    protected CertificateGenerationParameters prepareKubernetesCAGenerationParams() throws KeyException, CertificateException {
        KeyPair rootCAKeypair = this.getCAKeyPair(CAType.ROOT);
        X509Certificate rootCACert = this.getCACertificate(CAType.ROOT);
        CertificateSigner signer = new CertificateSigner(rootCAKeypair, rootCACert);
        KeyPair intermediateKeypair = this.getCAKeyPair(CAType.KUBECA);
        Long serialNumber = this.serialNumberFacade.nextSerialNumber(CAType.ROOT);
        X500Name name = (X500Name)CA_SUBJECT_NAME.get(CAType.KUBECA);
        Duration validityDuration = this.getCAValidityPeriod(this.conf.getKubernetesCA(), this.KUBERNETES_CA_DEFAULT_VALIDITY_PERIOD);
        Instant notBefore = Instant.now().minus(3L, ChronoUnit.MINUTES);
        Instant notAfter = notBefore.plus(validityDuration);
        CertificateValidityPeriod validityPeriod = new CertificateValidityPeriod(notBefore, notAfter);
        return new CertificateGenerationParameters(signer, intermediateKeypair, serialNumber, name, validityPeriod, INTERMEDIATE_EXTENSIONS);
    }

    protected X509Certificate generateCertificate(CertificateGenerationParameters params) throws NoSuchAlgorithmException, CertificateException, CertIOException, OperatorCreationException {
        CertificateSigner signer = CertificateGenerationParameters.access$000((CertificateGenerationParameters)params);
        Long sn = CertificateGenerationParameters.access$100((CertificateGenerationParameters)params);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(CertificateSigner.access$200((CertificateSigner)signer), BigInteger.valueOf(sn), Date.from(CertificateValidityPeriod.access$400((CertificateValidityPeriod)CertificateGenerationParameters.access$300((CertificateGenerationParameters)params))), Date.from(CertificateValidityPeriod.access$500((CertificateValidityPeriod)CertificateGenerationParameters.access$300((CertificateGenerationParameters)params))), CertificateGenerationParameters.access$600((CertificateGenerationParameters)params), CertificateGenerationParameters.access$700((CertificateGenerationParameters)params).getPublic());
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        SubjectKeyIdentifier subjectKeyIdentifier = extUtils.createSubjectKeyIdentifier(CertificateGenerationParameters.access$700((CertificateGenerationParameters)params).getPublic());
        AuthorityKeyIdentifier authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(CertificateSigner.access$800((CertificateSigner)signer).getPublic());
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)subjectKeyIdentifier).addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)authorityKeyIdentifier);
        try {
            CertificateGenerationParameters.access$900((CertificateGenerationParameters)params).apply(builder);
        }
        catch (RuntimeException ex) {
            throw new CertIOException("Failed to add certificate extensions", ex.getCause());
        }
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider((Provider)new BouncyCastleProvider()).build(CertificateSigner.access$800((CertificateSigner)signer).getPrivate());
        X509CertificateHolder holder = builder.build(contentSigner);
        X509Certificate certificate = this.converter.getCertificate(holder);
        LOGGER.log(Level.INFO, "Generated certificate");
        return certificate;
    }

    public X509Certificate signCertificateSigningRequest(String csrStr, CertificateType certificateType, String region) throws CAInitializationException, IOException, KeyException, NoSuchAlgorithmException, OperatorCreationException, CertificateException, SignatureException, CertificationRequestValidationException {
        try {
            this.maybeInitializeCA();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to initialize CA", ex);
            throw new CAInitializationException((Throwable)ex);
        }
        CAType caType = this.pkiUtils.getResponsibleCA(certificateType);
        Function[] certificateExtensionsBuilder = this.getExtensionsBuilders(caType, certificateType);
        X509Certificate certificate = this.signCertificateSigningRequest(csrStr, certificateType, caType, region, certificateExtensionsBuilder);
        LOGGER.log(Level.FINE, "Signed certificate and going to Save");
        this.saveNewCertificate(caType, certificate);
        LOGGER.log(Level.FINE, "Saved certificate");
        LOGGER.log(Level.INFO, "Generated and saved certificate with name " + certificate.getSubjectDN().toString());
        return certificate;
    }

    GeneralName[] getSanForUsername(String username, String region) {
        String normalizedUsername = this.usernamesConfiguration.getNormalizedUsername(username);
        if (normalizedUsername == null) {
            return EMTPY_GENERAL_NAMES;
        }
        switch (normalizedUsername) {
            case "glassfish": 
            case "glassfishinternal": {
                return this.convertToGeneralNames(HopsworksService.GLASSFISH.domains(), true, region);
            }
            case "hdfs": {
                return this.convertToGeneralNames(this.mergeSets(new Set[]{HopsworksService.NAMENODE.domains(), HopsworksService.SPARK_HISTORY_SERVER.domains()}), true, region);
            }
            case "hive": {
                return this.convertToGeneralNames(HopsworksService.HIVE.domains(), true, region);
            }
            case "livy": {
                return this.convertToGeneralNames(HopsworksService.LIVY.domains(), true, region);
            }
            case "flink": {
                return this.convertToGeneralNames(HopsworksService.FLINK.domains(), true, region);
            }
            case "consul": {
                return this.convertToGeneralNames(HopsworksService.CONSUL.domains(), true, region);
            }
            case "hopsmon": {
                return this.convertToGeneralNames(HopsworksService.PROMETHEUS.domains(), true, region);
            }
            case "zookeeper": {
                return this.convertToGeneralNames(HopsworksService.ZOOKEEPER.domains(), true, region);
            }
            case "rmyarn": {
                return this.convertToGeneralNames(HopsworksService.RESOURCE_MANAGER.domains(), true, region);
            }
            case "onlinefs": {
                HashSet<String> onlinefsDomain = new HashSet<String>();
                onlinefsDomain.add(HopsworksService.MYSQL.getNameWithTag((ServiceTags)MysqlTags.onlinefs));
                return this.convertToGeneralNames(onlinefsDomain, true, region);
            }
            case "elastic": {
                return this.convertToGeneralNames(this.mergeSets(new Set[]{HopsworksService.LOGSTASH.domains(), HopsworksService.OPENSEARCH.domains()}), true, region);
            }
            case "flyingduck": {
                return this.convertToGeneralNames(HopsworksService.FLYING_DUCK.domains(), true, region);
            }
            case "kagent": {
                return this.convertToGeneralNames(HopsworksService.DOCKER_REGISTRY.domains(), true, region);
            }
            case "mysql": {
                return this.convertToGeneralNames(this.mergeSets(new Set[]{HopsworksService.MYSQL.domains(), HopsworksService.RDRS.domains()}), true, region);
            }
        }
        return EMTPY_GENERAL_NAMES;
    }

    Set<String> mergeSets(Set<String> ... sets) {
        HashSet<String> merged = new HashSet<String>();
        for (Set<String> set : sets) {
            merged.addAll(set);
        }
        return merged;
    }

    GeneralName[] convertToGeneralNames(Set<String> domains, boolean isServiceDiscoveryDomain, String region) {
        GeneralName[] names = new GeneralName[domains.size()];
        Iterator<String> i = domains.iterator();
        int idx = 0;
        while (i.hasNext()) {
            String domain;
            String fqdn = domain = i.next();
            if (isServiceDiscoveryDomain) {
                fqdn = Utilities.constructServiceFQDN((String)domain, (String)this.caConf.getString(CAConf.CAConfKeys.SERVICE_DISCOVERY_DOMAIN));
            }
            names[idx] = new GeneralName(2, fqdn);
            ++idx;
        }
        return names;
    }

    @VisibleForTesting
    Optional<String> parseX509CommonName(PKCS10CertificationRequest csr) {
        return this.parseX509Rdn(csr, BCStyle.CN);
    }

    @VisibleForTesting
    Optional<String> parseX509Locality(PKCS10CertificationRequest csr) {
        if (csr == null) {
            return Optional.empty();
        }
        return this.parseX509Rdn(csr, BCStyle.L);
    }

    private Optional<String> parseX509Rdn(PKCS10CertificationRequest csr, ASN1ObjectIdentifier identifier) {
        RDN[] rdns = csr.getSubject().getRDNs(identifier);
        if (rdns.length == 0) {
            return Optional.empty();
        }
        return Optional.of(IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue()));
    }

    void appendSubjectAlternativeNames(X509v3CertificateBuilder certificateBuilder, GeneralName[] namesToAdd) throws CertIOException {
        if (!certificateBuilder.hasExtension(Extension.subjectAlternativeName)) {
            certificateBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(namesToAdd));
        } else {
            Extension existingExtension = certificateBuilder.getExtension(Extension.subjectAlternativeName);
            Extensions existingExtensions = new Extensions(existingExtension);
            GeneralNames existingGeneralNames = GeneralNames.fromExtensions((Extensions)existingExtensions, (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
            GeneralName[] existingNames = existingGeneralNames.getNames();
            HashSet<GeneralName> uniqueGeneralNames = new HashSet<GeneralName>(Arrays.asList(existingNames));
            uniqueGeneralNames.addAll(Arrays.asList(namesToAdd));
            GeneralName[] finalNames = new GeneralName[uniqueGeneralNames.size()];
            uniqueGeneralNames.toArray(finalNames);
            certificateBuilder.replaceExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(finalNames));
        }
    }

    protected Function<ExtensionsBuilderParameter, Void>[] getExtensionsBuilders(CAType caType, CertificateType certificateType) {
        if (certificateType.equals((Object)CertificateType.HOST)) {
            return this.HOST_CERTIFICATES_EXTENSION_BUILDERS;
        }
        if (caType.equals((Object)CAType.KUBECA)) {
            return this.KUBERNETES_CERTIFICATES_EXTENSION_BUILDERS;
        }
        return this.EMTPY_CERTIFICATES_EXTENSION_BUILDERS;
    }

    protected X509Certificate signCertificateSigningRequest(String csrStr, CertificateType certificateType, CAType caType, String region, Function<ExtensionsBuilderParameter, Void>[] extensionsBuilders) throws IOException, KeyException, NoSuchAlgorithmException, OperatorCreationException, CertificateException, SignatureException, CertificationRequestValidationException {
        LOGGER.log(Level.FINE, "Signing CSR for type " + certificateType);
        PKCS10CertificationRequest csr = this.parseCertificateRequest(csrStr);
        if (!certificateType.equals((Object)CertificateType.APP)) {
            LOGGER.log(Level.INFO, "Signing certificate with Subject " + csr.getSubject().toString());
        }
        this.validateCertificateSigningRequest(csr, caType);
        KeyPair signerKeyPair = this.getCAKeyPair(caType);
        X509Certificate signerCertificate = this.getCACertificate(certificateType);
        X500Name signerName = new JcaX509CertificateHolder(signerCertificate).getSubject();
        Optional exists = this.pkiCertificateFacade.findBySubjectAndStatus(csr.getSubject().toString(), PKICertificate.Status.VALID);
        if (exists.isPresent()) {
            if (certificateType.equals((Object)CertificateType.HOST) && !this.caConf.getString(CAConf.CAConfKeys.CLOUD_EVENTS_ENDPOINT).isEmpty()) {
                try {
                    this.revokeCertificate(csr.getSubject(), certificateType);
                }
                catch (Exception ex) {
                    String msg = "Certificate with Subject " + csr.getSubject() + " already exists. Because running on Managed Cloud we tried to revoke the previous certificate but we failed";
                    LOGGER.log(Level.SEVERE, msg, ex);
                    throw new CertificateAlreadyExistsException(msg, (Throwable)ex);
                }
            } else {
                throw new CertificateAlreadyExistsException("Certificate with Subject name " + csr.getSubject() + " already exists");
            }
        }
        LOGGER.log(Level.FINE, "CSR subject: " + csr.getSubject().toString());
        Long serialNumber = this.serialNumberFacade.nextSerialNumber(caType);
        Instant notBefore = Instant.now().minus(3L, ChronoUnit.MINUTES);
        Instant notAfter = this.getCertificateNotAfter(certificateType, notBefore);
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(signerName, BigInteger.valueOf(serialNumber), Date.from(notBefore), Date.from(notAfter), csr.getSubject(), csr.getSubjectPublicKeyInfo());
        builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(176)).addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(signerCertificate)).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(csr.getSubjectPublicKeyInfo()));
        try {
            for (Function<ExtensionsBuilderParameter, Void> f : extensionsBuilders) {
                f.apply(ExtensionsBuilderParameter.of((X509v3CertificateBuilder)builder, (PKCS10CertificationRequest)csr, (CertificateType)certificateType, (String)region));
            }
        }
        catch (Exception ex) {
            throw new CertIOException("Failed to add extension to certificate", (Throwable)ex);
        }
        LOGGER.log(Level.FINE, "Built Certificate builder");
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider((Provider)new BouncyCastleProvider()).build(signerKeyPair.getPrivate());
        X509CertificateHolder holder = builder.build(signer);
        LOGGER.log(Level.FINE, "Signed certificate");
        X509Certificate signedCertificate = this.converter.getCertificate(holder);
        LOGGER.log(Level.FINE, "Converted to X509Certificate");
        signedCertificate.verify(signerKeyPair.getPublic(), (Provider)new BouncyCastleProvider());
        LOGGER.log(Level.FINE, "Verified certificate");
        return signedCertificate;
    }

    private Instant getCertificateNotAfter(CertificateType certificateType, Instant notBefore) {
        TemporalAmount validity = this.pkiUtils.getValidityPeriod(certificateType);
        return notBefore.plus(validity);
    }

    private KeyPair getCAKeyPair(CAType type) throws KeyException {
        KeyPair keyPair = (KeyPair)this.caKeys.get(type);
        if (keyPair == null) {
            throw new KeyException("Could not load Key pair from cache for " + type);
        }
        return keyPair;
    }

    private X509Certificate getCACertificate(CertificateType certificateType) throws CACertificateNotFoundException {
        CAType caType = null;
        switch (1.$SwitchMap$io$hops$hopsworks$ca$controllers$CertificateType[certificateType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                caType = CAType.INTERMEDIATE;
                break;
            }
            case 4: {
                caType = CAType.KUBECA;
                break;
            }
            default: {
                throw new CACertificateNotFoundException("Could not find suitable CA for " + certificateType);
            }
        }
        return this.getCACertificate(caType);
    }

    private X509Certificate getCACertificate(CAType type) throws CACertificateNotFoundException {
        X509Certificate cert = (X509Certificate)this.caCertificates.get(type);
        if (cert == null) {
            throw new CACertificateNotFoundException("Failed to load " + type + " X509 certificate");
        }
        return cert;
    }

    protected void validateCertificateSigningRequest(PKCS10CertificationRequest csr, CAType caType) throws CertificationRequestValidationException {
        X500Name requestedName = csr.getSubject();
        LOGGER.log(Level.FINE, "Validating CSR name against CA names");
        for (X500Name n : CA_SUBJECT_NAME.values()) {
            if (!n.equals((Object)requestedName)) continue;
            throw new CertificationRequestValidationException("Requested Name " + requestedName + " collides with Certificate Authority name");
        }
    }

    private PKCS10CertificationRequest parseCertificateRequest(String csr) throws IOException, CertificateEncodingException {
        PEMParser pemParser = new PEMParser((Reader)new StringReader(csr));
        Object csrObject = pemParser.readObject();
        if (csrObject instanceof PKCS10CertificationRequest) {
            return (PKCS10CertificationRequest)csrObject;
        }
        throw new CertificateEncodingException("Failed to parse CSR to " + PKCS10CertificationRequest.class.getName());
    }

    public void revokeCertificate(String identifier, CertificateType certificateType) throws CAInitializationException, InvalidNameException, CertificateException, KeyException, CRLException {
        X500Name certificateName = this.pkiUtils.parseCertificateSubjectName(identifier, certificateType);
        this.revokeCertificate(certificateName, certificateType);
    }

    public void revokeCertificate(X500Name certificateName, CertificateType certificateType) throws CAInitializationException, CertificateException, KeyException, CRLException {
        X509Certificate certificate;
        Optional maybeCert;
        try {
            this.maybeInitializeCA();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to initialize CA", ex);
            throw new CAInitializationException((Throwable)ex);
        }
        if (!certificateType.equals((Object)CertificateType.APP)) {
            LOGGER.log(Level.INFO, "Revoking certificate with Subject " + certificateName);
        }
        if (!(maybeCert = this.pkiCertificateFacade.findById(new PKICertificateId(PKICertificate.Status.VALID, certificateName.toString()))).isPresent()) {
            throw new CertificateNotFoundException("Could not find certificate with Name " + certificateName.toString() + " to revoke");
        }
        PKICertificate pkiCert = (PKICertificate)maybeCert.get();
        LOGGER.log(Level.FINE, "Deleted certificate " + certificateName + " from database");
        byte[] encoded = pkiCert.getCertificate();
        try {
            certificate = this.converter.getCertificate(this.parseToX509CertificateHolder(encoded));
        }
        catch (IOException ex) {
            throw new CertificateException("Failed to decode certificate from CA database", ex);
        }
        if (!this.shouldCertificateTypeSkipCRL(certificateType)) {
            CAType caType = this.pkiUtils.getResponsibleCA(certificateType);
            X509CRL newCRL = this.addRevocationToCRL(caType, certificate);
            this.updateCRL(caType, newCRL);
            LOGGER.log(Level.FINE, "Updated CRL");
        } else if (certificate != null) {
            LOGGER.log(Level.FINE, "Certificate " + certificate.getSubjectDN().toString() + " of type " + certificateType + " is not added to CRL");
        }
        this.updateRevokedCertificate(pkiCert);
        if (certificate != null) {
            LOGGER.log(Level.INFO, "Revoked certificate with X.509 name " + certificate.getSubjectDN().toString());
        }
    }

    protected boolean shouldCertificateTypeSkipCRL(CertificateType certificateType) {
        return certificateType.equals((Object)CertificateType.APP);
    }

    protected X509CertificateHolder parseToX509CertificateHolder(byte[] encoded) throws IOException {
        return new X509CertificateHolder(encoded);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    protected void updateRevokedCertificate(PKICertificate certificate) {
        Optional maybeRevoked = this.pkiCertificateFacade.findById(certificate.getCertificateId());
        if (!maybeRevoked.isPresent()) {
            LOGGER.log(Level.WARNING, "Tried to update revoked certificate " + certificate.getCertificateId() + " but certificate does not exist in database. Skip updating");
            return;
        }
        PKICertificate revoked = (PKICertificate)maybeRevoked.get();
        revoked.getCertificateId().setStatus(PKICertificate.Status.REVOKED);
        revoked.setCertificate(null);
        this.pkiCertificateFacade.updateCertificate(revoked);
        this.pkiCertificateFacade.deleteCertificate(certificate);
    }

    protected X509CRL loadCRL(CAType type) throws CRLException, IOException {
        Optional maybeCrl = this.crlFacade.getCRL(type);
        if (!maybeCrl.isPresent()) {
            throw new CRLException("CRL for " + type + " is not present");
        }
        return this.crlConverter.getCRL(new X509CRLHolder(((PKICrl)maybeCrl.get()).getCrl()));
    }

    private X509CRL loadCRL(Path path) throws IOException, CRLException {
        try (PEMParser pemParser = new PEMParser((Reader)new FileReader(path.toFile()));){
            Object object = pemParser.readObject();
            if (object instanceof X509CRLHolder) {
                X509CRL x509CRL = this.crlConverter.getCRL((X509CRLHolder)object);
                return x509CRL;
            }
            X509CRL x509CRL = null;
            return x509CRL;
        }
    }

    protected X509CRL addRevocationToCRL(CAType caType, X509Certificate certificate) throws CRLException, KeyException {
        try {
            X509CRL crl = this.loadCRL(caType);
            KeyPair keyPair = this.getCAKeyPair(caType);
            JcaX509v2CRLBuilder builder = new JcaX509v2CRLBuilder(crl);
            builder.setNextUpdate(Date.from(Instant.now().plus(1L, ChronoUnit.DAYS)));
            ExtensionsGenerator extGen = new ExtensionsGenerator();
            extGen.addExtension(Extension.reasonCode, false, (ASN1Encodable)REVOCATION_REASON);
            builder.addCRLEntry(certificate.getSerialNumber(), new Date(), extGen.generate());
            ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider((Provider)new BouncyCastleProvider()).build(keyPair.getPrivate());
            return this.crlConverter.getCRL(builder.build(signer));
        }
        catch (IOException | OperatorCreationException ex) {
            throw new CRLException(ex);
        }
    }

    public X509Certificate loadCertificate(String name, PKICertificate.Status status) throws CertificateNotFoundException, CertificateException {
        Optional maybeCertificate = this.pkiCertificateFacade.findBySubjectAndStatus(name, status);
        if (!maybeCertificate.isPresent()) {
            throw new CertificateNotFoundException("Certificate with subject " + name + " and Status " + status + " does not exist");
        }
        PKICertificate pkiCertificate = (PKICertificate)maybeCertificate.get();
        byte[] encoded = pkiCertificate.getCertificate();
        try {
            return this.converter.getCertificate(new X509CertificateHolder(encoded));
        }
        catch (IOException ex) {
            throw new CertificateException("Failed to decode certificate from CA database", ex);
        }
    }

    @VisibleForTesting
    protected void setSerialNumberFacade(SerialNumberFacade serialNumberFacade) {
        this.serialNumberFacade = serialNumberFacade;
    }

    @VisibleForTesting
    protected void setCaConf(CAConf caConf) {
        this.caConf = caConf;
    }

    @VisibleForTesting
    protected void setKeyFacade(KeyFacade keyFacade) {
        this.keyFacade = keyFacade;
    }

    @VisibleForTesting
    protected void setPkiCertificateFacade(PKICertificateFacade pkiCertificateFacade) {
        this.pkiCertificateFacade = pkiCertificateFacade;
    }

    @VisibleForTesting
    protected Map<CAType, X500Name> getCaSubjectNames() {
        return CA_SUBJECT_NAME;
    }

    @VisibleForTesting
    protected Map<CAType, KeyPair> getCaKeys() {
        return this.caKeys;
    }

    @VisibleForTesting
    protected Map<CAType, X509Certificate> getCaCertificates() {
        return this.caCertificates;
    }

    @VisibleForTesting
    protected void setCRLFacade(CRLFacade crlFacade) {
        this.crlFacade = crlFacade;
    }

    @VisibleForTesting
    protected void setPKIUtils(PKIUtils pkiUtils) {
        this.pkiUtils = pkiUtils;
    }

    @VisibleForTesting
    protected void setConverter(JcaX509CertificateConverter converter) {
        this.converter = converter;
    }

    @VisibleForTesting
    protected void setUsernamesConfiguration(UsernamesConfiguration usernamesConfiguration) {
        this.usernamesConfiguration = usernamesConfiguration;
    }

    static {
        X500NameBuilder rootNameBuilder = new X500NameBuilder(BCStrictStyle.INSTANCE);
        rootNameBuilder.addRDN(BCStyle.C, "SE");
        rootNameBuilder.addRDN(BCStyle.O, "Hopsworks");
        rootNameBuilder.addRDN(BCStyle.OU, "core");
        rootNameBuilder.addRDN(BCStyle.CN, "HopsRootCA");
        X500Name rootCAName = rootNameBuilder.build();
        CA_SUBJECT_NAME.put(CAType.ROOT, rootCAName);
        X500NameBuilder intermediateNameBuilder = new X500NameBuilder(BCStrictStyle.INSTANCE);
        intermediateNameBuilder.addRDN(BCStyle.C, "SE");
        intermediateNameBuilder.addRDN(BCStyle.O, "Hopsworks");
        intermediateNameBuilder.addRDN(BCStyle.OU, "core");
        intermediateNameBuilder.addRDN(BCStyle.CN, "HopsIntermediateCA");
        X500Name intermediateCAName = intermediateNameBuilder.build();
        CA_SUBJECT_NAME.put(CAType.INTERMEDIATE, intermediateCAName);
        X500NameBuilder kubeNameBuilder = new X500NameBuilder(BCStrictStyle.INSTANCE);
        kubeNameBuilder.addRDN(BCStyle.C, "SE");
        kubeNameBuilder.addRDN(BCStyle.O, "Hopsworks");
        kubeNameBuilder.addRDN(BCStyle.OU, "core");
        kubeNameBuilder.addRDN(BCStyle.CN, "KubeHopsIntermediateCA");
        X500Name kubeName = kubeNameBuilder.build();
        CA_SUBJECT_NAME.put(CAType.KUBECA, kubeName);
        EMPTY_CONFIGURATION = new CAsConfiguration(null, null, null);
        EMPTY_CERTIFICATE_EXTENSIONS_BUILDER = b -> null;
        INTERMEDIATE_EXTENSIONS = builder -> {
            try {
                builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(5));
                builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134));
                return null;
            }
            catch (CertIOException ex) {
                throw new RuntimeException(ex);
            }
        };
    }
}

