/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.configuration;

import io.hops.hadoop.shaded.com.google.gson.Gson;
import io.hops.hadoop.shaded.com.google.gson.JsonSyntaxException;
import io.hops.hopsworks.ca.configuration.UsernamesConfiguration;
import io.hops.hopsworks.persistence.entity.util.Variables;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class UsernamesConfiguration {
    private static final String UNIX_USERNAMES_VARIABLE = "unix_usernames_conf";
    private Map<String, String> unixUsernames = new HashMap();
    private Map<String, String> inverseUnixUsernames = new HashMap();
    private final Gson gson = new Gson();
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @PostConstruct
    public void init() {
        this.populateDefaultValues();
        Variables v = (Variables)this.em.find(Variables.class, (Object)"unix_usernames_conf");
        if (v != null) {
            String rawValue = v.getValue();
            try {
                Map confUnixUsernames = (Map)this.gson.fromJson(rawValue, Map.class);
                for (Map.Entry k : confUnixUsernames.entrySet()) {
                    this.unixUsernames.put(k.getKey(), k.getValue());
                    this.inverseUnixUsernames.put(k.getValue(), k.getKey());
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
    }

    private void populateDefaultValues() {
        for (Username u : Username.values()) {
            this.unixUsernames.put(u.name().toLowerCase(), Username.access$000((Username)u));
            this.inverseUnixUsernames.put(Username.access$000((Username)u), u.name().toLowerCase());
        }
    }

    public String getUsername(Username username) {
        String configuredUsername = (String)this.unixUsernames.get(username.name().toLowerCase());
        if (configuredUsername != null) {
            return configuredUsername;
        }
        return Username.access$000((Username)username);
    }

    public String getNormalizedUsername(String username) {
        return (String)this.inverseUnixUsernames.get(username.toLowerCase());
    }
}

