/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.configuration;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.hops.hopsworks.ca.configuration.CAConf;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class CAConf {
    private LoadingCache<CAConfKeys, String> caConfiguration;
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @PostConstruct
    public void init() {
        this.caConfiguration = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String get(CAConfKeys confKey) {
        try {
            return (String)this.caConfiguration.get((Object)confKey);
        }
        catch (ExecutionException e) {
            return confKey.getDefaultValue();
        }
    }

    public String getString(CAConfKeys confKey) {
        return this.get(confKey);
    }

    public Boolean getBoolean(CAConfKeys confKey) {
        return Boolean.valueOf(this.get(confKey));
    }

    public Integer getInt(CAConfKeys confKey) {
        return Integer.valueOf(this.get(confKey));
    }

    public Long getLong(CAConfKeys confKeys) {
        return Long.valueOf(this.get(confKeys));
    }

    static /* synthetic */ EntityManager access$000(CAConf x0) {
        return x0.em;
    }
}

