/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.api.filter;

import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.hops.hopsworks.api.auth.key.ApiKeyRequired;
import io.hops.hopsworks.ca.api.exception.mapper.CAJsonResponse;
import io.hops.hopsworks.ca.api.filter.AuthFilter;
import io.hops.hopsworks.ca.configuration.CAConf;
import io.hops.hopsworks.jwt.AlgorithmFactory;
import io.hops.hopsworks.jwt.JWTController;
import io.hops.hopsworks.jwt.annotation.JWTRequired;
import io.hops.hopsworks.jwt.exception.SigningKeyNotFoundException;
import io.hops.hopsworks.jwt.filter.JWTFilter;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ejb.EJB;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

@Provider
@JWTRequired
@Priority(value=1000)
public class AuthFilter
extends JWTFilter {
    private static final Logger LOGGER = Logger.getLogger(AuthFilter.class.getName());
    @EJB
    private JWTController jwtController;
    @EJB
    private AlgorithmFactory algorithmFactory;
    @EJB
    private CAConf CAConf;
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private UriInfo uriInfo;

    public Algorithm getAlgorithm(DecodedJWT jwt) throws SigningKeyNotFoundException {
        return this.algorithmFactory.getAlgorithm(jwt);
    }

    public boolean isTokenValid(DecodedJWT jwt) {
        return !this.jwtController.isTokenInvalidated(jwt);
    }

    public boolean preJWTFilter(ContainerRequestContext requestContext) throws IOException {
        String authorizationHeader = requestContext.getHeaderString("Authorization");
        if (authorizationHeader != null && authorizationHeader.startsWith("ApiKey ")) {
            LOGGER.log(Level.FINEST, "{0} found, leaving JWT interceptor", "ApiKey ");
            if (this.getApiKeyAnnotation() == null) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Bearer realm=\"Cauth Realm\"").entity(this.responseEntity(Response.Status.UNAUTHORIZED, "Authorization method not supported.")).build());
            }
            return false;
        }
        return true;
    }

    public String getIssuer() {
        return this.CAConf.getString(CAConf.CAConfKeys.JWT_ISSUER);
    }

    public Set<String> allowedRoles() {
        JWTRequired rolesAnnotation;
        Class resourceClass = this.resourceInfo.getResourceClass();
        Method method = this.resourceInfo.getResourceMethod();
        JWTRequired methodRolesAnnotation = method.getAnnotation(JWTRequired.class);
        JWTRequired classRolesAnnotation = resourceClass.getAnnotation(JWTRequired.class);
        JWTRequired jWTRequired = rolesAnnotation = methodRolesAnnotation != null ? methodRolesAnnotation : classRolesAnnotation;
        if (rolesAnnotation == null) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(rolesAnnotation.allowedUserRoles()));
    }

    public Set<String> acceptedTokens() {
        JWTRequired acceptedTokens;
        Class resourceClass = this.resourceInfo.getResourceClass();
        Method method = this.resourceInfo.getResourceMethod();
        JWTRequired methodAcceptedTokens = method.getAnnotation(JWTRequired.class);
        JWTRequired classAcceptedTokens = resourceClass.getAnnotation(JWTRequired.class);
        JWTRequired jWTRequired = acceptedTokens = methodAcceptedTokens != null ? methodAcceptedTokens : classAcceptedTokens;
        if (acceptedTokens == null) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(acceptedTokens.acceptedTokens()));
    }

    public void postJWTFilter(ContainerRequestContext requestContext, DecodedJWT jwt) throws IOException {
    }

    public Object responseEntity(Response.Status status, String msg) {
        CAJsonResponse jsonResponse = new CAJsonResponse();
        if (null == status) {
            jsonResponse.setErrorCode(RESTCodes.GenericErrorCode.UNKNOWN_ERROR.getCode());
        } else {
            switch (1.$SwitchMap$javax$ws$rs$core$Response$Status[status.ordinal()]) {
                case 1: {
                    jsonResponse.setErrorCode(RESTCodes.SecurityErrorCode.EJB_ACCESS_LOCAL.getCode());
                    break;
                }
                case 2: {
                    jsonResponse.setErrorCode(RESTCodes.SecurityErrorCode.REST_ACCESS_CONTROL.getCode());
                    break;
                }
                default: {
                    jsonResponse.setErrorCode(RESTCodes.GenericErrorCode.UNKNOWN_ERROR.getCode());
                }
            }
        }
        jsonResponse.setErrorMsg(msg);
        return jsonResponse;
    }

    private ApiKeyRequired getApiKeyAnnotation() {
        Class resourceClass = this.resourceInfo.getResourceClass();
        Method method = this.resourceInfo.getResourceMethod();
        ApiKeyRequired methodRolesAnnotation = method.getAnnotation(ApiKeyRequired.class);
        ApiKeyRequired classRolesAnnotation = resourceClass.getAnnotation(ApiKeyRequired.class);
        return methodRolesAnnotation != null ? methodRolesAnnotation : classRolesAnnotation;
    }
}

