/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.api.certificates;

import io.hops.hopsworks.api.auth.key.ApiKeyRequired;
import io.hops.hopsworks.ca.api.filter.NoCacheResponse;
import io.hops.hopsworks.ca.controllers.PKI;
import io.hops.hopsworks.jwt.annotation.JWTRequired;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiScope;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/pki")
@RequestScoped
@JWTRequired(acceptedTokens={"services", "api"}, allowedUserRoles={"HOPS_ADMIN"})
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class PKIResource {
    private static final Logger LOGGER = Logger.getLogger(PKIResource.class.getName());
    @EJB
    private NoCacheResponse noCacheResponse;
    @EJB
    private PKI pki;

    @PUT
    @Path(value="/configuration")
    @ApiKeyRequired(acceptedScopes={ApiScope.AUTH}, allowedUserRoles={"AGENT"})
    public Response reconfigure() {
        LOGGER.log(Level.INFO, "Loading PKI configuration");
        this.pki.configure();
        return this.noCacheResponse.getNoCacheResponseBuilder(Response.Status.OK).build();
    }
}

